/*
 * Decompiled with CFR 0.152.
 */
package io.github.matyrobbrt.curseforgeapi.request.query;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.github.matyrobbrt.curseforgeapi.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;

public class FeaturedModsQuery {
    private final int gameId;
    private final List<Integer> excludedModIds = new ArrayList<Integer>();
    @Nullable
    private Integer gameVersionTypeId;

    public static FeaturedModsQuery of(int gameId, int ... excludedModIds) {
        return new FeaturedModsQuery(gameId).excludeMods(excludedModIds);
    }

    private FeaturedModsQuery(int gameId) {
        this.gameId = gameId;
    }

    public FeaturedModsQuery excludeMod(int modId) {
        this.excludedModIds.add(modId);
        return this;
    }

    public FeaturedModsQuery excludeMods(int ... modIds) {
        for (int id : modIds) {
            this.excludedModIds.add(id);
        }
        return this;
    }

    public FeaturedModsQuery gameVersionTypeId(int gameVersionTypeId) {
        this.gameVersionTypeId = gameVersionTypeId;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("gameId", this.gameId);
        JsonArray excArray = new JsonArray();
        this.excludedModIds.forEach(excArray::add);
        json.add("excludedModIds", excArray);
        if (this.gameVersionTypeId != null) {
            json.addProperty("gameVersionTypeId", this.gameVersionTypeId);
        }
        return json;
    }
}

