/*
 * Decompiled with CFR 0.152.
 */
package io.github.matyrobbrt.curseforgeapi.request.helper;

import io.github.matyrobbrt.curseforgeapi.CurseForgeAPI;
import io.github.matyrobbrt.curseforgeapi.annotation.Nullable;
import io.github.matyrobbrt.curseforgeapi.request.AsyncRequest;
import io.github.matyrobbrt.curseforgeapi.request.Request;
import io.github.matyrobbrt.curseforgeapi.request.Requests;
import io.github.matyrobbrt.curseforgeapi.request.Response;
import io.github.matyrobbrt.curseforgeapi.request.helper.IRequestHelper;
import io.github.matyrobbrt.curseforgeapi.request.query.FeaturedModsQuery;
import io.github.matyrobbrt.curseforgeapi.request.query.GetFuzzyMatchesQuery;
import io.github.matyrobbrt.curseforgeapi.request.query.ModSearchQuery;
import io.github.matyrobbrt.curseforgeapi.request.query.PaginationQuery;
import io.github.matyrobbrt.curseforgeapi.schemas.Category;
import io.github.matyrobbrt.curseforgeapi.schemas.PaginatedData;
import io.github.matyrobbrt.curseforgeapi.schemas.file.File;
import io.github.matyrobbrt.curseforgeapi.schemas.fingerprint.FingerprintFuzzyMatch;
import io.github.matyrobbrt.curseforgeapi.schemas.fingerprint.FingerprintsMatchesResult;
import io.github.matyrobbrt.curseforgeapi.schemas.game.Game;
import io.github.matyrobbrt.curseforgeapi.schemas.game.GameVersionType;
import io.github.matyrobbrt.curseforgeapi.schemas.game.GameVersionsByType;
import io.github.matyrobbrt.curseforgeapi.schemas.mod.FeaturedMods;
import io.github.matyrobbrt.curseforgeapi.schemas.mod.Mod;
import io.github.matyrobbrt.curseforgeapi.util.CurseForgeException;
import java.util.List;

public class AsyncRequestHelper
implements IRequestHelper {
    private final CurseForgeAPI api;

    public AsyncRequestHelper(CurseForgeAPI api) {
        this.api = api;
    }

    @Override
    public AsyncRequest<Response<File>> getModFile(int modId, int fileId) throws CurseForgeException {
        return this.api.makeAsyncRequest(Requests.getModFile(modId, fileId));
    }

    @Override
    public AsyncRequest<Response<List<File>>> getModFiles(int modId) throws CurseForgeException {
        return this.api.makeAsyncRequest(Requests.getModFiles(modId));
    }

    @Override
    public AsyncRequest<Response<List<File>>> getModFiles(int modId, @Nullable Integer gameVersionTypeId, @Nullable PaginationQuery paginationQuery) throws CurseForgeException {
        return this.api.makeAsyncRequest(Requests.getModFiles(modId, gameVersionTypeId, paginationQuery));
    }

    @Override
    public AsyncRequest<Response<List<Category>>> getCategories(int gameId) throws CurseForgeException {
        return this.api.makeAsyncRequest(Requests.getCategories(gameId));
    }

    @Override
    public AsyncRequest<Response<List<Category>>> getCategories(int gameId, int classId) throws CurseForgeException {
        return this.api.makeAsyncRequest(Requests.getCategories(gameId, classId));
    }

    @Override
    public AsyncRequest<Response<Mod>> getMod(int modId) throws CurseForgeException {
        return this.api.makeAsyncRequest(Requests.getMod(modId));
    }

    @Override
    public AsyncRequest<Response<List<Mod>>> searchMods(ModSearchQuery query) throws CurseForgeException {
        return this.api.makeAsyncRequest(Requests.searchMods(query));
    }

    @Override
    public AsyncRequest<Response<PaginatedData<List<Mod>>>> searchModsPaginated(ModSearchQuery query) throws CurseForgeException {
        return this.api.makeAsyncRequest(Requests.searchModsPaginated(query));
    }

    @Override
    public AsyncRequest<Response<Game>> getGame(int gameId) throws CurseForgeException {
        return this.mr(Requests.getGame(gameId));
    }

    @Override
    public AsyncRequest<Response<List<Game>>> getGames() throws CurseForgeException {
        return this.mr(Requests.getGames());
    }

    @Override
    public AsyncRequest<Response<List<Game>>> getGames(PaginationQuery paginationQuery) throws CurseForgeException {
        return this.mr(Requests.getGames(paginationQuery));
    }

    @Override
    public AsyncRequest<Response<List<GameVersionsByType>>> getGameVersions(int gameId) throws CurseForgeException {
        return this.mr(Requests.getGameVersions(gameId));
    }

    @Override
    public AsyncRequest<Response<List<GameVersionType>>> getGameVersionTypes(int gameId) throws CurseForgeException {
        return this.mr(Requests.getGameVersionTypes(gameId));
    }

    @Override
    public AsyncRequest<Response<String>> getModDescription(int modId) throws CurseForgeException {
        return this.mr(Requests.getModDescription(modId));
    }

    @Override
    public AsyncRequest<Response<FeaturedMods>> getFeaturedMods(FeaturedModsQuery query) throws CurseForgeException {
        return this.mr(Requests.getFeaturedMods(query));
    }

    @Override
    public AsyncRequest<Response<List<File>>> getModFiles(Mod mod) throws CurseForgeException {
        return this.mr(Requests.getModFiles(mod));
    }

    @Override
    public AsyncRequest<Response<List<File>>> getFiles(int ... fileIds) throws CurseForgeException {
        return this.mr(Requests.getFiles(fileIds));
    }

    @Override
    public AsyncRequest<Response<String>> getModFileChangelog(int modId, int fileId) throws CurseForgeException {
        return this.mr(Requests.getModFileChangelog(modId, fileId));
    }

    @Override
    public AsyncRequest<Response<String>> getModFileDownloadURL(int modId, int fileId) throws CurseForgeException {
        return this.mr(Requests.getModFileDownloadURL(modId, fileId));
    }

    @Override
    public AsyncRequest<Response<FingerprintsMatchesResult>> getFingerprintMatches(int ... fingerprints) throws CurseForgeException {
        return this.mr(Requests.getFingerprintMatches(fingerprints));
    }

    @Override
    public AsyncRequest<Response<List<FingerprintFuzzyMatch>>> getFingerprintsFuzzyMatches(GetFuzzyMatchesQuery query) throws CurseForgeException {
        return this.mr(Requests.getFingerprintsFuzzyMatches(query));
    }

    private <T> AsyncRequest<Response<T>> mr(Request<T> req) throws CurseForgeException {
        return this.api.makeAsyncRequest(req);
    }
}

