/*
 * Decompiled with CFR 0.152.
 */
package io.github.matyrobbrt.curseforgeapi.request.async;

import io.github.matyrobbrt.curseforgeapi.annotation.Nonnull;
import io.github.matyrobbrt.curseforgeapi.request.AsyncRequest;
import io.github.matyrobbrt.curseforgeapi.request.async.AsyncRequestValues;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public record OfCompletableFutureAsyncRequest<T>(@Nonnull CompletableFuture<T> future) implements AsyncRequest<T>
{
    public static void setFutureExecutor(@Nonnull Executor executor) {
        AsyncRequestValues.setFutureExecutor(executor);
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public void queue(Consumer<? super T> onSuccess, Consumer<? super Throwable> onFailure) {
        AsyncRequestValues.futureExecutor.execute(() -> {
            try {
                CompletionStage tFuture = this.future.whenComplete((o, t2) -> {
                    if (o != null && onSuccess != null) {
                        onSuccess.accept(o);
                    }
                    if (t2 != null) {
                        if (onFailure != null) {
                            onFailure.accept((Throwable)t2);
                        } else {
                            AsyncRequestValues.defaultFailure.accept((Throwable)t2);
                        }
                    }
                });
                while (!((CompletableFuture)tFuture).isDone()) {
                    Thread.sleep(100L);
                }
                ((CompletableFuture)tFuture).get();
            }
            catch (ExecutionException e) {
                if (onFailure != null) {
                    onFailure.accept(e.getCause());
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("InterruptedException while awaiting request!", e);
                throw new RuntimeException(e);
            }
        });
    }
}

