/*
 * Decompiled with CFR 0.152.
 */
package io.github.matyrobbrt.curseforgeapi.request.async;

import io.github.matyrobbrt.curseforgeapi.annotation.Nullable;
import io.github.matyrobbrt.curseforgeapi.request.AsyncRequest;
import io.github.matyrobbrt.curseforgeapi.request.async.AsyncRequestOperator;
import io.github.matyrobbrt.curseforgeapi.request.async.AsyncRequestValues;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;

public class FlatMapAsyncRequest<I, O>
extends AsyncRequestOperator<I, O> {
    private final Function<? super I, ? extends AsyncRequest<O>> function;

    public FlatMapAsyncRequest(AsyncRequest<I> action, Function<? super I, ? extends AsyncRequest<O>> function) {
        super(action);
        this.function = function;
    }

    private AsyncRequest<O> supply(I input) {
        return this.function.apply(input);
    }

    @Override
    public void queue(@Nullable Consumer<? super O> success, @Nullable Consumer<? super Throwable> failure) {
        Consumer<? super Throwable> contextFailure = failure == null ? AsyncRequestValues.defaultFailure : failure;
        this.action.queue((? super T result) -> {
            AsyncRequest<O> then2 = this.supply(result);
            if (then2 == null) {
                contextFailure.accept(new IllegalStateException("FlatMap operand is null"));
            } else {
                then2.queue(success, contextFailure);
            }
        }, contextFailure);
    }

    @Override
    public O get() throws InterruptedException, ExecutionException {
        return this.function.apply(this.action.get()).get();
    }
}

