/*
 * Decompiled with CFR 0.152.
 */
package io.github.matyrobbrt.curseforgeapi.request.async;

import io.github.matyrobbrt.curseforgeapi.annotation.Nonnull;
import io.github.matyrobbrt.curseforgeapi.request.AsyncRequest;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

public class AsyncRequestValues {
    @Nonnull
    static Executor futureExecutor = Executors.newSingleThreadExecutor(r -> new Thread(r, "AsyncRequestHandler"));
    static Consumer<? super Throwable> defaultFailure = t2 -> {
        if (t2 instanceof CancellationException || t2 instanceof TimeoutException) {
            AsyncRequest.LOGGER.debug(t2.getMessage());
        } else if (t2.getCause() != null) {
            AsyncRequest.LOGGER.error("AsyncRequest queue returned failure: [{}] {}", t2.getClass().getSimpleName(), t2.getMessage(), t2.getCause());
        } else {
            AsyncRequest.LOGGER.error("AsyncRequest queue returned failure: [{}] {}", (Object)t2.getClass().getSimpleName(), (Object)t2.getMessage());
        }
    };
    static boolean emptyRequestThrows = false;

    public static void setEmptyRequestThrows(boolean emptyRequestThrows) {
        AsyncRequestValues.emptyRequestThrows = emptyRequestThrows;
    }

    @Nonnull
    public static Consumer<? super Throwable> getDefaultFailure() {
        return defaultFailure;
    }

    public static void setDefaultFailure(Consumer<? super Throwable> callback) {
        defaultFailure = callback == null ? t2 -> {} : callback;
    }

    public static void setFutureExecutor(@Nonnull Executor executor) {
        futureExecutor = Objects.requireNonNull(executor);
    }
}

