/*
 * Decompiled with CFR 0.152.
 */
package io.github.matyrobbrt.curseforgeapi.request;

import io.github.matyrobbrt.curseforgeapi.annotation.Nonnull;
import io.github.matyrobbrt.curseforgeapi.annotation.Nullable;
import io.github.matyrobbrt.curseforgeapi.util.ExceptionFunction;
import io.github.matyrobbrt.curseforgeapi.util.ExceptionSupplier;
import io.github.matyrobbrt.curseforgeapi.util.Utils;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class Response<T> {
    private final T value;
    private final Integer statusCode;

    public static <T> Response<T> empty(@Nullable Integer statusCode) {
        return new Response<Object>(null, statusCode);
    }

    public static <T> Response<T> of(@Nonnull T value, @Nullable Integer statusCode) {
        return new Response<T>(Objects.requireNonNull(value), statusCode);
    }

    public static <T> Response<T> ofNullable(@Nullable T value, @Nullable Integer statusCode) {
        return value == null ? Response.empty(statusCode) : Response.of(value, statusCode);
    }

    public static <T> Response<T> ofNullableAndStatusCode(@Nullable T value, @Nullable Integer statusCode) {
        if (statusCode == 404) {
            return Response.empty(statusCode);
        }
        return value == null ? Response.empty(statusCode) : Response.of(value, statusCode);
    }

    private Response(@Nullable T value, @Nullable Integer statusCode) {
        this.value = value;
        this.statusCode = statusCode;
    }

    @Nonnull
    public Integer getStatusCode() {
        return this.statusCode;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public void ifPresent(Consumer<? super T> action) {
        if (this.value != null) {
            action.accept(this.value);
        }
    }

    public void ifPresentOrElse(Consumer<? super T> action, Runnable emptyAction) {
        if (this.value != null) {
            action.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    public Response<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this.value) ? this : Response.empty(this.statusCode);
    }

    public <U> Response<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return Response.empty(this.statusCode);
        }
        return Response.ofNullable(mapper.apply(this.value), this.statusCode);
    }

    public <U> U mapOrElse(Function<? super T, ? extends U> mapper, Supplier<U> orElse) {
        Objects.requireNonNull(mapper);
        if (this.isPresent()) {
            return mapper.apply(this.value);
        }
        return orElse.get();
    }

    public <U> U mapOrElseWithException(ExceptionFunction<? super T, ? extends U, ?> mapper, ExceptionSupplier<U, ?> orElse) {
        return this.mapOrElseWithException(mapper, orElse, null);
    }

    public <U> U mapOrElseWithException(ExceptionFunction<? super T, ? extends U, ?> mapper, ExceptionSupplier<U, ?> orElse, @Nullable Function<Exception, U> onException) {
        try {
            Objects.requireNonNull(mapper);
            if (this.isPresent()) {
                return mapper.apply(this.value);
            }
            return orElse.get();
        }
        catch (Exception e) {
            if (onException == null) {
                Utils.sneakyThrow(e);
                return null;
            }
            return onException.apply(e);
        }
    }

    public <U> Response<U> flatMap(Function<? super T, ? extends Response<? extends U>> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return Response.empty(this.statusCode);
        }
        Response<? extends U> r = mapper.apply(this.value);
        return Objects.requireNonNull(r);
    }

    public <U> Response<U> flatMapWithException(ExceptionFunction<? super T, ? extends Response<? extends U>, ?> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return Response.empty(this.statusCode);
        }
        Response<? extends U> r = null;
        try {
            r = mapper.apply(this.value);
        }
        catch (Exception e) {
            Utils.sneakyThrow(e);
        }
        return Objects.requireNonNull(r);
    }

    public Response<T> or(Supplier<? extends Response<? extends T>> supplier) {
        Objects.requireNonNull(supplier);
        if (this.isPresent()) {
            return this;
        }
        Response<? extends T> r = supplier.get();
        return Objects.requireNonNull(r);
    }

    public Stream<T> stream() {
        if (!this.isPresent()) {
            return Stream.empty();
        }
        return Stream.of(this.value);
    }

    public T orElse(T other) {
        return this.value != null ? this.value : other;
    }

    public T orElseGet(Supplier<? extends T> supplier) {
        return this.value != null ? this.value : supplier.get();
    }

    public T get() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public T orElseThrow() {
        return this.orElseThrow(() -> new NoSuchElementException("No value present"));
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.value != null) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public Optional<T> toOptional() {
        return this.isPresent() ? Optional.of(this.value) : Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Response)) return false;
        Response other = (Response)obj;
        if (!Objects.equals(this.value, other.value)) return false;
        if (this.statusCode != other.statusCode) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hashCode(this.value) + 31 * Objects.hashCode(this.statusCode);
    }
}

