/*
 * Decompiled with CFR 0.152.
 */
package io.github.matyrobbrt.curseforgeapi.request;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import io.github.matyrobbrt.curseforgeapi.annotation.Nonnull;
import io.github.matyrobbrt.curseforgeapi.annotation.Nullable;
import io.github.matyrobbrt.curseforgeapi.request.Arguments;
import io.github.matyrobbrt.curseforgeapi.request.Method;
import io.github.matyrobbrt.curseforgeapi.request.Request;
import io.github.matyrobbrt.curseforgeapi.request.query.FeaturedModsQuery;
import io.github.matyrobbrt.curseforgeapi.request.query.GetFuzzyMatchesQuery;
import io.github.matyrobbrt.curseforgeapi.request.query.ModSearchQuery;
import io.github.matyrobbrt.curseforgeapi.request.query.PaginationQuery;
import io.github.matyrobbrt.curseforgeapi.request.query.Query;
import io.github.matyrobbrt.curseforgeapi.schemas.Category;
import io.github.matyrobbrt.curseforgeapi.schemas.PaginatedData;
import io.github.matyrobbrt.curseforgeapi.schemas.file.File;
import io.github.matyrobbrt.curseforgeapi.schemas.fingerprint.FingerprintFuzzyMatch;
import io.github.matyrobbrt.curseforgeapi.schemas.fingerprint.FingerprintsMatchesResult;
import io.github.matyrobbrt.curseforgeapi.schemas.game.Game;
import io.github.matyrobbrt.curseforgeapi.schemas.game.GameVersionType;
import io.github.matyrobbrt.curseforgeapi.schemas.game.GameVersionsByType;
import io.github.matyrobbrt.curseforgeapi.schemas.mod.FeaturedMods;
import io.github.matyrobbrt.curseforgeapi.schemas.mod.Mod;
import java.lang.reflect.Type;
import java.util.List;

public final class Requests {
    public static Request<Game> getGame(int gameId) {
        return new Request<Game>("/v1/games/" + gameId, Method.GET, "data", Types.GAME);
    }

    public static Request<List<Game>> getGames() {
        return Requests.getGames(null);
    }

    public static Request<List<Game>> getGames(@Nullable PaginationQuery paginationQuery) {
        return new Request<List<Game>>(Requests.format("/v1/games", paginationQuery), Method.GET, "data", Types.GAME_LIST);
    }

    public static Request<List<GameVersionsByType>> getGameVersions(int gameId) {
        return new Request<List<GameVersionsByType>>("/v1/games/%s/versions".formatted(gameId), Method.GET, "data", Types.GAME_VERSIONS_BY_TYPE_LIST);
    }

    public static Request<List<GameVersionType>> getGameVersionTypes(int gameId) {
        return new Request<List<GameVersionType>>("/v1/games/%s/version-types".formatted(gameId), Method.GET, "data", Types.GAME_VERSION_TYPE_LIST);
    }

    public static Request<List<Category>> getCategories(int gameId) {
        return new Request<List<Category>>("/v1/categories?gameId=" + gameId, Method.GET, "data", Types.CATEGORY_LIST);
    }

    public static Request<List<Category>> getCategories(int gameId, int classId) {
        return new Request<List<Category>>("/v1/categories?gameId=%s&classId=%s".formatted(gameId, classId), Method.GET, "data", Types.CATEGORY_LIST);
    }

    public static Request<Mod> getMod(int modId) {
        return new Request<Mod>("/v1/mods/" + modId, Method.GET, "data", Types.MOD);
    }

    public static Request<String> getModDescription(int modId) {
        return new Request<String>("/v1/mods/%s/description".formatted(modId), Method.GET, "data", Types.STRING);
    }

    public static Request<List<Mod>> searchMods(ModSearchQuery query) {
        return new Request<List<Mod>>(Requests.format("/v1/mods/search", query.toArgs()), Method.GET, "data", Types.MOD_LIST);
    }

    public static Request<PaginatedData<List<Mod>>> searchModsPaginated(ModSearchQuery query) {
        return new Request<PaginatedData<List<Mod>>>(Requests.format("/v1/mods/search", query.toArgs()), Method.GET, (g2, j) -> PaginatedData.fromJson(g2, j, Types.MOD_LIST));
    }

    public static Request<FeaturedMods> getFeaturedMods(FeaturedModsQuery query) {
        return new Request<FeaturedMods>("/v1/mods/featured", Method.POST, query.toJson(), "data", Types.FEATURED_MODS);
    }

    public static Request<File> getModFile(int modId, int fileId) {
        return new Request<File>("/v1/mods/%s/files/%s".formatted(modId, fileId), Method.GET, "data", Types.FILE);
    }

    public static Request<List<File>> getModFiles(Mod mod) {
        return Requests.getModFiles(mod.id());
    }

    public static Request<List<File>> getModFiles(int modid) {
        return Requests.getModFiles(modid, null, null);
    }

    public static Request<List<File>> getModFiles(int modId, @Nullable Integer gameVersionTypeId, @Nullable PaginationQuery paginationQuery) {
        return new Request<List<File>>(Requests.format("/v1/mods/%s/files".formatted(modId), Arguments.EMPTY.put("gameVersionTypeId", gameVersionTypeId).putAll(paginationQuery == null ? null : paginationQuery.toArgs())), Method.GET, "data", Types.FILE_LIST);
    }

    public static Request<List<File>> getFiles(int ... fileIds) {
        JsonObject body = new JsonObject();
        JsonArray array = new JsonArray();
        for (int id : fileIds) {
            array.add(id);
        }
        body.add("fileIds", array);
        return new Request<List<File>>("/v1/mods/files", Method.POST, body, "data", Types.FILE_LIST);
    }

    public static Request<String> getModFileChangelog(int modId, int fileId) {
        return new Request<String>("/v1/mods/%s/files/%s/changelog".formatted(modId, fileId), Method.GET, "data", Types.STRING);
    }

    public static Request<String> getModFileDownloadURL(int modId, int fileId) {
        return new Request<String>("/v1/mods/%s/files/%s/download-url".formatted(modId, fileId), Method.GET, "data", Types.STRING);
    }

    public static Request<FingerprintsMatchesResult> getFingerprintMatches(int ... fingerprints) {
        JsonObject jObj = new JsonObject();
        JsonArray array = new JsonArray();
        for (int f : fingerprints) {
            array.add(f);
        }
        jObj.add("fingerprints", array);
        return new Request<FingerprintsMatchesResult>("/v1/fingerprints", Method.POST, jObj, "data", Types.FINGERPRINTS_MATCHES);
    }

    public static Request<List<FingerprintFuzzyMatch>> getFingerprintsFuzzyMatches(@Nonnull GetFuzzyMatchesQuery query) {
        return new Request<List<FingerprintFuzzyMatch>>("/v1/fingerprints/fuzzy", Method.POST, query.toJson(), (gson, json) -> (List)gson.fromJson((JsonElement)json.get("data").getAsJsonObject().get("fuzzyMatches").getAsJsonArray(), Types.FINGERPRINTS_FUZY_MATCH_LIST));
    }

    public static String format(String str, @Nullable Query query) {
        return Requests.format(str, query == null ? null : query.toArgs());
    }

    public static String format(String str, @Nullable Arguments args2) {
        if (args2 == null) {
            return str;
        }
        return str + "?" + args2.build();
    }

    public static final class Types {
        public static final Type GAME = new TypeToken<Game>(){}.getType();
        public static final Type GAME_LIST = new TypeToken<List<Game>>(){}.getType();
        public static final Type GAME_VERSION_TYPE_LIST = new TypeToken<List<GameVersionType>>(){}.getType();
        public static final Type GAME_VERSIONS_BY_TYPE_LIST = new TypeToken<List<GameVersionsByType>>(){}.getType();
        public static final Type CATEGORY_LIST = new TypeToken<List<Category>>(){}.getType();
        public static final Type MOD = new TypeToken<Mod>(){}.getType();
        public static final Type MOD_LIST = new TypeToken<List<Mod>>(){}.getType();
        public static final Type FEATURED_MODS = new TypeToken<FeaturedMods>(){}.getType();
        public static final Type FILE = new TypeToken<File>(){}.getType();
        public static final Type FILE_LIST = new TypeToken<List<File>>(){}.getType();
        public static final Type FINGERPRINTS_MATCHES = new TypeToken<FingerprintsMatchesResult>(){}.getType();
        public static final Type FINGERPRINTS_FUZY_MATCH_LIST = new TypeToken<List<FingerprintFuzzyMatch>>(){}.getType();
        public static final Type STRING = new TypeToken<String>(){}.getType();
    }
}

