/*
 * Decompiled with CFR 0.152.
 */
package io.github.matyrobbrt.curseforgeapi.request;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.matyrobbrt.curseforgeapi.request.GenericRequest;
import io.github.matyrobbrt.curseforgeapi.request.Method;
import java.lang.reflect.Type;
import java.util.function.BiFunction;

public class Request<R>
extends GenericRequest {
    private final BiFunction<Gson, JsonObject, R> responseDecoder;

    public Request(String endpoint, Method method, JsonElement body, BiFunction<Gson, JsonObject, R> responseDecoder) {
        super(endpoint, method, body);
        this.responseDecoder = responseDecoder;
    }

    public Request(String endpoint, Method method, BiFunction<Gson, JsonObject, R> responseDecoder) {
        this(endpoint, method, null, responseDecoder);
    }

    public Request(String endpoint, Method method, JsonElement body, String responseObjectName, Type type) {
        super(endpoint, method, body);
        this.responseDecoder = (g2, j) -> {
            JsonElement dataElement = j.get(responseObjectName);
            if (dataElement.isJsonPrimitive()) {
                return g2.fromJson((JsonElement)dataElement.getAsJsonPrimitive(), type);
            }
            return g2.fromJson(dataElement.isJsonArray() ? dataElement.getAsJsonArray() : dataElement.getAsJsonObject(), type);
        };
    }

    public Request(String endpoint, Method method, String responseObjectName, Type type) {
        this(endpoint, method, null, responseObjectName, type);
    }

    public R decodeResponse(Gson gson, JsonObject response) {
        return this.responseDecoder.apply(gson, response);
    }
}

