/*
 * Decompiled with CFR 0.152.
 */
package io.github.matyrobbrt.curseforgeapi.request;

import io.github.matyrobbrt.curseforgeapi.annotation.Nonnull;
import io.github.matyrobbrt.curseforgeapi.annotation.Nullable;
import io.github.matyrobbrt.curseforgeapi.request.DoubleAsyncRequest;
import io.github.matyrobbrt.curseforgeapi.request.async.AsyncRequestValues;
import io.github.matyrobbrt.curseforgeapi.request.async.EmptyAsyncRequest;
import io.github.matyrobbrt.curseforgeapi.request.async.FlatMapAsyncRequest;
import io.github.matyrobbrt.curseforgeapi.request.async.MapAsyncRequest;
import io.github.matyrobbrt.curseforgeapi.request.async.OfCompletableFutureAsyncRequest;
import io.github.matyrobbrt.curseforgeapi.request.async.OfValueAsyncRequest;
import io.github.matyrobbrt.curseforgeapi.request.async.PairAsyncRequest;
import io.github.matyrobbrt.curseforgeapi.request.async.WithExceptionAsyncRequest;
import io.github.matyrobbrt.curseforgeapi.util.ExceptionFunction;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface AsyncRequest<T> {
    public static final Logger LOGGER = LoggerFactory.getLogger(AsyncRequest.class);

    public static void setFutureExecutor(@Nonnull Executor executor) {
        AsyncRequestValues.setFutureExecutor(executor);
    }

    public static void setDefaultFailure(@Nullable Consumer<? super Throwable> callback) {
        AsyncRequestValues.setDefaultFailure(callback);
    }

    public static void setEmptyRequestThrows(boolean emptyRequestThrows) {
        AsyncRequestValues.setEmptyRequestThrows(emptyRequestThrows);
    }

    public static <T> AsyncRequest<T> of(@Nonnull Supplier<T> supplier) {
        return new OfCompletableFutureAsyncRequest<T>(CompletableFuture.supplyAsync(supplier));
    }

    public static <T> AsyncRequest<T> of(T value) {
        return new OfValueAsyncRequest<T>(value);
    }

    public static <T> AsyncRequest<T> ofNullable(@Nullable T value) {
        return value == null ? AsyncRequest.empty() : AsyncRequest.of(value);
    }

    public static <T> AsyncRequest<T> empty() {
        return EmptyAsyncRequest.INSTANCE;
    }

    @Nonnull
    default public <U> AsyncRequest<U> map(@Nonnull Function<? super T, ? extends U> mapper) {
        return new MapAsyncRequest<T, U>(this, Objects.requireNonNull(mapper));
    }

    @Nonnull
    default public <U> AsyncRequest<U> mapWithException(@Nonnull ExceptionFunction<? super T, ? extends U, ?> mapper) {
        return this.map(mapper::applyNoException);
    }

    @Nonnull
    default public <U> AsyncRequest<U> flatMap(@Nonnull Function<? super T, ? extends AsyncRequest<U>> mapper) {
        return new FlatMapAsyncRequest(this, Objects.requireNonNull(mapper));
    }

    @Nonnull
    default public <U, E extends Exception> AsyncRequest<U> flatMapWithException(@Nonnull ExceptionFunction<? super T, ? extends AsyncRequest<U>, E> mapper) {
        return this.flatMap(v -> {
            try {
                return (AsyncRequest)mapper.apply(v);
            }
            catch (Exception e) {
                return new WithExceptionAsyncRequest(e);
            }
        });
    }

    @Nonnull
    default public <U> DoubleAsyncRequest<T, U> and(@Nonnull AsyncRequest<U> other) {
        return new PairAsyncRequest(this, Objects.requireNonNull(other));
    }

    @Nullable
    public T get() throws InterruptedException, ExecutionException;

    default public void queue() {
        this.queue(null, AsyncRequestValues.getDefaultFailure());
    }

    default public void queue(@Nullable Consumer<? super T> onSuccess) {
        this.queue(onSuccess, AsyncRequestValues.getDefaultFailure());
    }

    public void queue(@Nullable Consumer<? super T> var1, @Nullable Consumer<? super Throwable> var2);

    public static final class EmptyRequestException
    extends Exception {
        private static final long serialVersionUID = 586245362476362933L;
    }
}

