/*
 * Decompiled with CFR 0.152.
 */
package io.github.matyrobbrt.curseforgeapi.request;

import io.github.matyrobbrt.curseforgeapi.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;

public class Arguments {
    public static final Arguments EMPTY = new Arguments(new HashMap<String, String>()).immutable();
    final Map<String, String> args;

    public static Arguments of(String key, Object value) {
        return new Arguments(new HashMap<String, String>()).put(key, value);
    }

    Arguments(Map<String, String> args2) {
        this.args = args2;
    }

    public Arguments put(String key, @Nullable Object value) {
        if (value != null) {
            this.args.put(key, value.toString());
        }
        return this;
    }

    public Arguments copy() {
        return new Arguments(new HashMap<String, String>(this.args));
    }

    public Arguments putAll(@Nullable Arguments other) {
        if (other == null) {
            return this;
        }
        this.args.putAll(other.args);
        return this;
    }

    public String build() {
        return String.join((CharSequence)"&", (CharSequence[])this.args.entrySet().stream().map(e -> "%s=%s".formatted(e.getKey(), e.getValue())).toArray(String[]::new));
    }

    public String toString() {
        return this.build();
    }

    public Arguments immutable() {
        return new Immutable(this.args);
    }

    private static final class Immutable
    extends Arguments {
        Immutable(Map<String, String> args2) {
            super(Map.copyOf(args2));
        }

        @Override
        public Arguments put(String key, Object value) {
            HashMap<String, String> newArgs = new HashMap<String, String>(this.args);
            if (value == null) {
                return new Arguments(newArgs);
            }
            newArgs.put(key, value.toString());
            return new Arguments(newArgs);
        }

        @Override
        public Arguments putAll(@Nullable Arguments other) {
            HashMap<String, String> newArgs = new HashMap<String, String>(this.args);
            if (other == null) {
                return new Arguments(newArgs);
            }
            newArgs.putAll(other.args);
            return new Arguments(newArgs);
        }
    }
}

