/*
 * Decompiled with CFR 0.152.
 */
package io.github.matyrobbrt.curseforgeapi;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.matyrobbrt.curseforgeapi.annotation.Nonnull;
import io.github.matyrobbrt.curseforgeapi.annotation.Nullable;
import io.github.matyrobbrt.curseforgeapi.request.AsyncRequest;
import io.github.matyrobbrt.curseforgeapi.request.GenericRequest;
import io.github.matyrobbrt.curseforgeapi.request.Method;
import io.github.matyrobbrt.curseforgeapi.request.Request;
import io.github.matyrobbrt.curseforgeapi.request.Requests;
import io.github.matyrobbrt.curseforgeapi.request.Response;
import io.github.matyrobbrt.curseforgeapi.request.async.OfHttpResponseAsyncRequest;
import io.github.matyrobbrt.curseforgeapi.request.helper.AsyncRequestHelper;
import io.github.matyrobbrt.curseforgeapi.request.helper.RequestHelper;
import io.github.matyrobbrt.curseforgeapi.request.uploadapi.UploadApiRequest;
import io.github.matyrobbrt.curseforgeapi.request.uploadapi.UploadApiRequests;
import io.github.matyrobbrt.curseforgeapi.schemas.ApiStatus;
import io.github.matyrobbrt.curseforgeapi.schemas.HashAlgo;
import io.github.matyrobbrt.curseforgeapi.schemas.Status;
import io.github.matyrobbrt.curseforgeapi.schemas.file.FileRelationType;
import io.github.matyrobbrt.curseforgeapi.schemas.file.FileReleaseType;
import io.github.matyrobbrt.curseforgeapi.schemas.file.FileStatus;
import io.github.matyrobbrt.curseforgeapi.schemas.mod.ModStatus;
import io.github.matyrobbrt.curseforgeapi.util.CurseForgeException;
import io.github.matyrobbrt.curseforgeapi.util.Utils;
import io.github.matyrobbrt.curseforgeapi.util.gson.CFSchemaEnumTypeAdapter;
import io.github.matyrobbrt.curseforgeapi.util.gson.RecordTypeAdapterFactory;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.security.auth.login.LoginException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurseForgeAPI {
    public static final String REQUEST_TARGET = "https://api.curseforge.com";
    public static final String UPLOAD_REQUEST_TARGET = "https://%s.curseforge.com";
    public static final Gson DEFAULT_GSON = Utils.makeWithSupplier(() -> {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().serializeNulls().registerTypeAdapterFactory(new RecordTypeAdapterFactory());
        List<Class<ModStatus>> cfSchemaEnums = List.of(ApiStatus.class, FileRelationType.class, FileReleaseType.class, FileStatus.class, HashAlgo.class, Status.class, ModStatus.class);
        cfSchemaEnums.forEach(e -> gsonBuilder.registerTypeAdapter((Type)e, CFSchemaEnumTypeAdapter.constructUnsafe(e)));
        return gsonBuilder.create();
    });
    public static final Supplier<HttpClient> DEFAULT_HTTP_CLIENT_FACTORY = () -> HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
    @Nullable
    private final String apiKey;
    @Nullable
    private final String uploadApiToken;
    private final HttpClient httpClient;
    private final Gson gson;
    private final Logger logger;
    private final RequestHelper helper = new RequestHelper(this);
    private final AsyncRequestHelper asyncHelper = new AsyncRequestHelper(this);

    private CurseForgeAPI(@Nullable String apiKey, @Nullable String uploadApiToken, HttpClient httpClient, Gson gson, Logger logger) {
        if (StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass() != Builder.class) {
            throw new IllegalCallerException("Illegal access to constructor!");
        }
        this.apiKey = apiKey;
        this.uploadApiToken = uploadApiToken;
        this.httpClient = httpClient;
        this.gson = gson;
        this.logger = logger;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated(since="1.5.0", forRemoval=true)
    public CurseForgeAPI(String apiKey) {
        this.apiKey = apiKey;
        this.uploadApiToken = null;
        this.gson = DEFAULT_GSON;
        this.httpClient = DEFAULT_HTTP_CLIENT_FACTORY.get();
        this.logger = LoggerFactory.getLogger(CurseForgeAPI.class);
        if (!this.isAuthorized()) {
            throw new IllegalArgumentException("Invalid API Key!");
        }
    }

    @Deprecated(since="1.5.0", forRemoval=true)
    public CurseForgeAPI(String apiKey, HttpClient httpClient, Gson gson, Logger logger) {
        this.apiKey = apiKey;
        this.httpClient = httpClient;
        this.gson = gson;
        this.logger = logger;
        this.uploadApiToken = null;
        if (!this.isAuthorized()) {
            throw new IllegalArgumentException("Invalid API Key!");
        }
    }

    public boolean isAuthorized() {
        try {
            Integer statusCode = this.makeRequest(Requests.getGame(432)).getStatusCode();
            return statusCode != 401 && statusCode != 403;
        }
        catch (CurseForgeException e) {
            this.logger.error("Could not check if the API Key is valid due to an exception.", e);
            return false;
        }
    }

    public boolean isAuthorizedForUpload() {
        try {
            Integer statusCode = this.makeUploadApiRequest("minecraft", UploadApiRequests.getGameVersions()).getStatusCode();
            return statusCode != 401 && statusCode != 403;
        }
        catch (CurseForgeException e) {
            this.logger.error("Could not check if the Upload API Token is valid due to an exception.", e);
            return false;
        }
    }

    public Gson getGson() {
        return this.gson;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Nullable
    public String getApiKey() {
        return this.apiKey;
    }

    @Nullable
    public String getUploadApiToken() {
        return this.uploadApiToken;
    }

    public RequestHelper getHelper() {
        return this.helper;
    }

    public AsyncRequestHelper getAsyncHelper() {
        return this.asyncHelper;
    }

    public <R> Response<R> makeRequest(Request<? extends R> request) throws CurseForgeException {
        return this.makeGenericRequest(request).map(j -> request.decodeResponse(this.getGson(), (JsonObject)j));
    }

    @Nonnull
    public Response<JsonObject> makeGenericRequest(GenericRequest genericRequest) throws CurseForgeException {
        if (this.apiKey == null) {
            throw new CurseForgeException("Cannot make requests with a null API key!");
        }
        int statusCode = 0;
        try {
            URL target = new URL(REQUEST_TARGET + genericRequest.endpoint());
            HttpRequest httpRequest = Utils.makeWithSupplier(() -> {
                HttpRequest.Builder r = HttpRequest.newBuilder(URI.create(target.toString())).header("Accept", "application/json").header("x-api-key", this.apiKey);
                r = switch (genericRequest.method()) {
                    default -> throw new IncompatibleClassChangeError();
                    case Method.GET -> r.GET();
                    case Method.POST -> r.POST(HttpRequest.BodyPublishers.ofString(genericRequest.body().toString())).header("Content-Type", "application/json");
                    case Method.PUT -> r.PUT(HttpRequest.BodyPublishers.ofString(genericRequest.body().toString()));
                };
                return r;
            }).build();
            HttpResponse<String> response = this.httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            statusCode = response.statusCode();
            if (statusCode == 503) {
                return Response.empty(statusCode);
            }
            return Response.ofNullableAndStatusCode(this.gson.fromJson(response.body(), JsonObject.class), statusCode);
        }
        catch (InterruptedException ine) {
            this.logger.error("InterruptedException while awaiting CurseForge response, which returned with the status code: ", ine);
            Thread.currentThread().interrupt();
            return Response.empty(statusCode);
        }
        catch (Exception e) {
            this.logger.info("Status code was {}", (Object)statusCode);
            throw new CurseForgeException(e);
        }
    }

    public <R> AsyncRequest<Response<R>> makeAsyncRequest(Request<? extends R> request) throws CurseForgeException {
        return this.makeAsyncGenericRequest(request).map(r -> r.map(j -> request.decodeResponse(this.getGson(), (JsonObject)j)));
    }

    @Nonnull
    public AsyncRequest<Response<JsonObject>> makeAsyncGenericRequest(GenericRequest genericRequest) throws CurseForgeException {
        if (this.apiKey == null) {
            throw new CurseForgeException("Cannot make requests with a null API key!");
        }
        try {
            URL target = new URL(REQUEST_TARGET + genericRequest.endpoint());
            HttpRequest httpRequest = Utils.makeWithSupplier(() -> {
                HttpRequest.Builder r = HttpRequest.newBuilder(URI.create(target.toString())).header("Accept", "application/json").header("x-api-key", this.apiKey);
                r = switch (genericRequest.method()) {
                    default -> throw new IncompatibleClassChangeError();
                    case Method.GET -> r.GET();
                    case Method.POST -> r.POST(HttpRequest.BodyPublishers.ofString(genericRequest.body().toString())).header("Content-Type", "application/json");
                    case Method.PUT -> r.PUT(HttpRequest.BodyPublishers.ofString(genericRequest.body().toString()));
                };
                return r;
            }).build();
            return new OfHttpResponseAsyncRequest<Response<JsonObject>>((CompletableFuture<Response<JsonObject>>)this.httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
                if (response.statusCode() == 503) {
                    return Response.empty(response.statusCode());
                }
                return Response.ofNullableAndStatusCode(this.gson.fromJson((String)response.body(), JsonObject.class), response.statusCode());
            }));
        }
        catch (Exception e) {
            throw new CurseForgeException(e);
        }
    }

    public <R> Response<R> makeUploadApiRequest(String gameSlug, UploadApiRequest<? extends R> request) throws CurseForgeException {
        if (this.uploadApiToken == null) {
            throw new CurseForgeException("Cannot make requests with a null Upload API token!");
        }
        int statusCode = 0;
        try {
            URL target = new URL(UPLOAD_REQUEST_TARGET.formatted(gameSlug) + request.endpoint());
            HttpRequest httpRequest = Utils.makeWithSupplier(() -> {
                HttpRequest.Builder r = HttpRequest.newBuilder(URI.create(target.toString())).header("X-Api-Token", this.uploadApiToken).header("Content-Type", request.contentType() == null ? "application/json" : request.contentType());
                r = switch (request.method()) {
                    default -> throw new IncompatibleClassChangeError();
                    case Method.GET -> r.GET();
                    case Method.POST -> r.POST(request.bodyPublisher());
                    case Method.PUT -> r.PUT(request.bodyPublisher());
                };
                return r;
            }).build();
            HttpResponse<String> response = this.httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            statusCode = response.statusCode();
            if (statusCode == 404 || statusCode == 503) {
                return Response.empty(statusCode);
            }
            return Response.ofNullableAndStatusCode(this.gson.fromJson(response.body(), JsonElement.class), statusCode).map(j -> request.responseDecoder().apply(this.gson, (JsonElement)j));
        }
        catch (InterruptedException ine) {
            this.logger.error("InterruptedException while awaiting CurseForge Upload API response, which returned with the status code: ", ine);
            Thread.currentThread().interrupt();
            return Response.empty(statusCode);
        }
        catch (Exception e) {
            this.logger.info("Status code was {}", (Object)statusCode);
            throw new CurseForgeException(e);
        }
    }

    public <R> AsyncRequest<Response<R>> makeAsyncUploadApiRequest(String gameSlug, UploadApiRequest<? extends R> request) throws CurseForgeException {
        if (this.uploadApiToken == null) {
            throw new CurseForgeException("Cannot make requests with a null Upload API token!");
        }
        try {
            URL target = new URL(UPLOAD_REQUEST_TARGET.formatted(gameSlug) + request.endpoint());
            HttpRequest httpRequest = Utils.makeWithSupplier(() -> {
                HttpRequest.Builder r = HttpRequest.newBuilder(URI.create(target.toString())).header("Accept", "application/json").header("X-Api-Token", this.uploadApiToken);
                r = switch (request.method()) {
                    default -> throw new IncompatibleClassChangeError();
                    case Method.GET -> r.GET();
                    case Method.POST -> r.POST(request.bodyPublisher());
                    case Method.PUT -> r.PUT(request.bodyPublisher());
                };
                return r;
            }).build();
            return new OfHttpResponseAsyncRequest<Response<R>>(this.httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofString()).thenApply(response -> Response.ofNullableAndStatusCode(response.statusCode() == 404 || response.statusCode() == 503 ? null : this.gson.fromJson((String)response.body(), JsonElement.class), response.statusCode()).map(j -> request.responseDecoder().apply(this.gson, (JsonElement)j))));
        }
        catch (Exception e) {
            throw new CurseForgeException(e);
        }
    }

    public static final class Builder {
        private String apiKey;
        private String uploadApiToken;
        private Gson gson = DEFAULT_GSON;
        private Logger logger = LoggerFactory.getLogger(CurseForgeAPI.class);
        private Supplier<HttpClient> httpClient = DEFAULT_HTTP_CLIENT_FACTORY;

        private Builder() {
        }

        public Builder apiKey(@Nullable String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder uploadApiToken(@Nullable String uploadApiToken) {
            this.uploadApiToken = uploadApiToken;
            return this;
        }

        public Builder gson(Gson gson) {
            this.gson = Objects.requireNonNull(gson, "Cannot build a CurseForgeAPI with a null Gson.");
            return this;
        }

        public Builder defaultGson(@Nullable Consumer<GsonBuilder> modifyingConsumer) {
            if (modifyingConsumer == null) {
                this.gson = DEFAULT_GSON;
            } else {
                GsonBuilder builder = DEFAULT_GSON.newBuilder();
                modifyingConsumer.accept(builder);
                this.gson = builder.create();
            }
            return this;
        }

        public Builder logger(Logger logger) {
            this.logger = Objects.requireNonNull(logger, "Cannot build a CurseForgeAPI with a null Logger.");
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = () -> Objects.requireNonNull(httpClient, "Cannot build a CurseForgeAPI with a null HttpClient.");
            return this;
        }

        public CurseForgeAPI build() throws LoginException {
            CurseForgeAPI api = new CurseForgeAPI(this.apiKey, this.uploadApiToken, this.httpClient.get(), this.gson, this.logger);
            if (this.apiKey != null && !api.isAuthorized()) {
                throw new LoginException("The apiKey provided is invalid.");
            }
            if (this.uploadApiToken != null && !api.isAuthorizedForUpload()) {
                throw new LoginException("The uploadApiToken provided is invalid.");
            }
            return api;
        }
    }
}

