/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.niofs.union;

import cpw.mods.niofs.union.UnionFileSystemProvider;
import cpw.mods.niofs.union.UnionPath;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class UnionFileSystem
extends FileSystem {
    private static final MethodHandle ZIPFS_EXISTS;
    static final String SEP_STRING = "/";
    private final UnionPath root = new UnionPath(this, "/");
    private final UnionPath notExistingPath = new UnionPath(this, "/SNOWMAN");
    private final UnionFileSystemProvider provider;
    private final String key;
    private final List<Path> basepaths;
    private final BiPredicate<String, String> pathFilter;
    private final Map<Path, EmbeddedFileSystemMetadata> embeddedFileSystems;

    public Path getPrimaryPath() {
        return this.basepaths.get(this.basepaths.size() - 1);
    }

    public BiPredicate<String, String> getFilesystemFilter() {
        return this.pathFilter;
    }

    String getKey() {
        return this.key;
    }

    public UnionFileSystem(UnionFileSystemProvider provider, BiPredicate<String, String> pathFilter, String key, Path ... basepaths) {
        this.pathFilter = pathFilter;
        this.provider = provider;
        this.key = key;
        this.basepaths = IntStream.range(0, basepaths.length).mapToObj(i -> basepaths[basepaths.length - i - 1]).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).toList();
        this.embeddedFileSystems = this.basepaths.stream().filter(path -> !Files.isDirectory(path, new LinkOption[0])).map(UnionFileSystem::openFileSystem).flatMap(Optional::stream).collect(Collectors.toMap(EmbeddedFileSystemMetadata::path, Function.identity()));
    }

    private static Optional<EmbeddedFileSystemMetadata> openFileSystem(Path path) {
        try {
            return Optional.of(new EmbeddedFileSystemMetadata(path, FileSystems.newFileSystem(path)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public UnionFileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public void close() {
        this.provider().removeFileSystem(this);
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public String getSeparator() {
        return SEP_STRING;
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return Collections.singletonList(this.root);
    }

    public Path getRoot() {
        return this.root;
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return Collections::emptyIterator;
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return Set.of("basic");
    }

    @Override
    public Path getPath(String first, String ... more) {
        if (more.length > 0) {
            String[] args2 = new String[more.length + 1];
            args2[0] = first;
            System.arraycopy(more, 0, args2, 1, more.length);
            return new UnionPath(this, args2);
        }
        return new UnionPath(this, first);
    }

    private Path fastPath(String ... parts) {
        return new UnionPath(this, false, parts);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchService newWatchService() {
        throw new UnsupportedOperationException();
    }

    List<Path> getBasePaths() {
        return this.basepaths;
    }

    private Optional<BasicFileAttributes> getFileAttributes(Path path) {
        try {
            if (path.getFileSystem() == FileSystems.getDefault() && !path.toFile().exists()) {
                return Optional.empty();
            }
            if (path.getFileSystem().provider().getScheme().equals("jar") && !UnionFileSystem.zipFsExists(path)) {
                return Optional.empty();
            }
            return Optional.of(path.getFileSystem().provider().readAttributes(path, BasicFileAttributes.class, new LinkOption[0]));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    private Optional<Path> findFirstPathAt(UnionPath path) {
        return this.basepaths.stream().map(p -> this.toRealPath((Path)p, path)).filter(p -> p != this.notExistingPath).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst();
    }

    private static boolean zipFsExists(Path path) {
        try {
            return ZIPFS_EXISTS.invoke(path);
        }
        catch (Throwable t2) {
            throw new IllegalStateException(t2);
        }
    }

    private Optional<Path> findFirstFiltered(UnionPath path) {
        for (Path p : this.basepaths) {
            Path realPath = this.toRealPath(p, path);
            if (realPath == this.notExistingPath || !this.testFilter(realPath, p) || !(realPath.getFileSystem() == FileSystems.getDefault() ? realPath.toFile().exists() : (realPath.getFileSystem().provider().getScheme().equals("jar") ? UnionFileSystem.zipFsExists(realPath) : Files.exists(realPath, new LinkOption[0])))) continue;
            return Optional.of(realPath);
        }
        return Optional.empty();
    }

    private <T> Stream<T> streamPathList(Function<Path, Optional<T>> function) {
        return this.basepaths.stream().map(function).flatMap(Optional::stream);
    }

    public <A extends BasicFileAttributes> A readAttributes(UnionPath path, Class<A> type, LinkOption ... options) throws IOException {
        if (type == BasicFileAttributes.class) {
            for (Path base : this.basepaths) {
                Optional<BasicFileAttributes> fileAttributes;
                Path realPath = this.toRealPath(base, path);
                if (realPath == this.notExistingPath || !(fileAttributes = this.getFileAttributes(realPath)).isPresent() || !this.testFilter(realPath, base)) continue;
                return (A)fileAttributes.get();
            }
            throw new NoSuchFileException(path.toString());
        }
        throw new UnsupportedOperationException();
    }

    public void checkAccess(UnionPath p, AccessMode ... modes) throws IOException {
        try {
            this.findFirstFiltered(p).ifPresentOrElse(path -> {
                try {
                    if (modes.length == 0 && path.getFileSystem() == FileSystems.getDefault()) {
                        if (!path.toFile().exists()) {
                            throw new UncheckedIOException(new NoSuchFileException(p.toString()));
                        }
                    } else {
                        path.getFileSystem().provider().checkAccess((Path)path, modes);
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }, () -> {
                throw new UncheckedIOException(new NoSuchFileException(p.toString()));
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private Path toRealPath(Path basePath, UnionPath path) {
        UnionPath embeddedpath = path.isAbsolute() ? this.root.relativize(path) : path;
        String resolvepath = embeddedpath.normalize().toString();
        EmbeddedFileSystemMetadata efsm = this.embeddedFileSystems.get(basePath);
        if (efsm != null) {
            return efsm.fs().getPath(resolvepath, new String[0]);
        }
        return basePath.resolve(resolvepath);
    }

    public SeekableByteChannel newReadByteChannel(UnionPath path) throws IOException {
        try {
            return this.findFirstFiltered(path).map(this::byteChannel).orElseThrow(FileNotFoundException::new);
        }
        catch (UncheckedIOException ioe) {
            throw ioe.getCause();
        }
    }

    private SeekableByteChannel byteChannel(Path path) {
        try {
            return Files.newByteChannel(path, StandardOpenOption.READ);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public DirectoryStream<Path> newDirStream(UnionPath path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        final LinkedHashSet allpaths = new LinkedHashSet();
        for (Path bp : this.basepaths) {
            Path dir = this.toRealPath(bp, path);
            if (dir == this.notExistingPath || dir.getFileSystem() == FileSystems.getDefault() && !dir.toFile().exists() || dir.getFileSystem().provider().getScheme() == "jar" && !UnionFileSystem.zipFsExists(dir) || Files.notExists(dir, new LinkOption[0])) continue;
            boolean isSimple = this.embeddedFileSystems.containsKey(bp);
            DirectoryStream<Path> ds = Files.newDirectoryStream(dir, filter);
            try {
                StreamSupport.stream(ds.spliterator(), false).filter(p -> this.testFilter((Path)p, bp)).map(other -> (String[])StreamSupport.stream(Spliterators.spliteratorUnknownSize((isSimple ? other : bp.relativize((Path)other)).iterator(), 16), false).map(Path::getFileName).map(Path::toString).toArray(String[]::new)).map(this::fastPath).forEachOrdered(allpaths::add);
            }
            finally {
                if (ds == null) continue;
                ds.close();
            }
        }
        return new DirectoryStream<Path>(){

            @Override
            public Iterator<Path> iterator() {
                return allpaths.iterator();
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    private boolean testFilter(Path path, Path basePath) {
        String sBasePath;
        if (this.pathFilter == null) {
            return true;
        }
        Object sPath = path.toString();
        if (path.getFileSystem() == basePath.getFileSystem()) {
            sPath = basePath.relativize(path).toString().replace('\\', '/');
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            sPath = (String)sPath + SEP_STRING;
        }
        if (((String)sPath).length() > 1 && ((String)sPath).startsWith(SEP_STRING)) {
            sPath = ((String)sPath).substring(1);
        }
        if ((sBasePath = basePath.toString().replace('\\', '/')).length() > 1 && sBasePath.startsWith(SEP_STRING)) {
            sBasePath = sBasePath.substring(1);
        }
        return this.pathFilter.test((String)sPath, sBasePath);
    }

    static {
        try {
            Field hackfield = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            hackfield.setAccessible(true);
            MethodHandles.Lookup hack = (MethodHandles.Lookup)hackfield.get(null);
            Class<?> clz = Class.forName("jdk.nio.zipfs.ZipPath");
            ZIPFS_EXISTS = hack.findSpecial(clz, "exists", MethodType.methodType(Boolean.TYPE), clz);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private record EmbeddedFileSystemMetadata(Path path, FileSystem fs) {
    }

    private static class UncheckedIOException
    extends java.io.UncheckedIOException {
        public UncheckedIOException(IOException cause) {
            super(cause);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    private static class NoSuchFileException
    extends java.nio.file.NoSuchFileException {
        public NoSuchFileException(String file) {
            super(file);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

