/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.flow;

import com.github.mizosoft.methanol.internal.flow.FlowSupport;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractSubscription<T>
implements Flow.Subscription {
    private static final System.Logger logger = System.getLogger(AbstractSubscription.class.getName());
    private static final int RUNNING = 1;
    private static final int KEEP_ALIVE = 2;
    private static final int CANCELLED = 4;
    private static final int SUBSCRIBED = 8;
    private static final VarHandle STATE;
    private static final VarHandle PENDING_ERROR;
    private static final VarHandle DEMAND;
    private final Flow.Subscriber<? super T> downstream;
    private final Executor executor;
    private volatile int state;
    private volatile long demand;
    private volatile @Nullable Throwable pendingError;

    protected AbstractSubscription(Flow.Subscriber<? super T> downstream, Executor executor) {
        this.downstream = downstream;
        this.executor = executor;
    }

    @Override
    public final void request(long n) {
        if (n > 0L && FlowSupport.getAndAddDemand(this, DEMAND, n) == 0L) {
            this.signal();
        } else if (n <= 0L) {
            this.signalError(FlowSupport.illegalRequest());
        }
    }

    @Override
    public final void cancel() {
        if ((this.getAndBitwiseOrState(4) & 4) == 0) {
            this.guardedAbort(true);
        }
    }

    public final void signal(boolean force) {
        if (force || this.demand > 0L) {
            this.signal();
        }
    }

    public final void signalError(Throwable error) {
        this.recordError(error);
        this.signal();
    }

    protected abstract long emit(Flow.Subscriber<? super T> var1, long var2);

    protected void abort(boolean flowInterrupted) {
    }

    private void guardedAbort(boolean flowInterrupted) {
        try {
            this.abort(flowInterrupted);
        }
        catch (Throwable t2) {
            logger.log(System.Logger.Level.WARNING, "exception thrown during subscription cancellation", t2);
        }
    }

    protected final boolean isCancelled() {
        return (this.state & 4) != 0;
    }

    protected final boolean hasPendingErrors() {
        return this.pendingError != null;
    }

    protected final void cancelOnError(Flow.Subscriber<? super T> downstream, Throwable error, boolean flowInterrupted) {
        if ((this.getAndBitwiseOrState(4) & 4) == 0) {
            this.guardedAbort(flowInterrupted);
            try {
                downstream.onError(error);
            }
            catch (Throwable t2) {
                logger.log(System.Logger.Level.WARNING, () -> "exception thrown by subscriber's onError: " + downstream, t2);
            }
        }
    }

    protected final void cancelOnComplete(Flow.Subscriber<? super T> downstream) {
        if ((this.getAndBitwiseOrState(4) & 4) == 0) {
            this.guardedAbort(false);
            try {
                downstream.onComplete();
            }
            catch (Throwable t2) {
                logger.log(System.Logger.Level.WARNING, () -> "exception thrown by subscriber's onComplete: " + downstream, t2);
            }
        }
    }

    protected final boolean submitOnNext(Flow.Subscriber<? super T> downstream, T item) {
        if (!this.isCancelled() && !this.hasPendingErrors()) {
            try {
                downstream.onNext(item);
                return true;
            }
            catch (Throwable t2) {
                this.cancelOnError(downstream, this.recordError(t2), true);
            }
        }
        return false;
    }

    private void signal() {
        int s2;
        while (((s2 = this.state) & 4) == 0) {
            int setBit = (s2 & 1) != 0 ? 2 : 1;
            if (!STATE.compareAndSet(this, s2, s2 | setBit)) continue;
            if (setBit != 1) break;
            try {
                this.executor.execute(this::run);
                break;
            }
            catch (Error | RuntimeException e) {
                logger.log(System.Logger.Level.ERROR, "subscription couldn't execute its signaller task", e);
                this.cancel();
                throw e;
            }
        }
    }

    private void run() {
        int s2;
        Flow.Subscriber<? super T> d = this.downstream;
        this.subscribeOnDrain(d);
        long x = 0L;
        long r = this.demand;
        while (((s2 = this.state) & 4) == 0) {
            int unsetBit;
            boolean exhausted;
            Throwable error = this.pendingError;
            if (error != null) {
                this.cancelOnError(d, error, false);
                continue;
            }
            long emitted = this.emit(d, r - x);
            if (emitted > 0L) {
                r = this.demand;
                if ((x += emitted) != r) continue;
                r = FlowSupport.subtractAndGetDemand(this, DEMAND, x);
                x = 0L;
                continue;
            }
            if (r != (r = this.demand)) continue;
            boolean bl = exhausted = x <= 0L;
            if (!exhausted) {
                r = FlowSupport.subtractAndGetDemand(this, DEMAND, x);
                x = 0L;
                exhausted = r <= 0L;
            }
            int n = unsetBit = (s2 & 2) != 0 ? 2 : 1;
            if (!exhausted || !STATE.compareAndSet(this, s2, s2 & ~unsetBit) || unsetBit != 1) continue;
            break;
        }
    }

    private void subscribeOnDrain(Flow.Subscriber<? super T> downstream) {
        if ((this.state & 0xC) == 0 && (this.getAndBitwiseOrState(8) & 0xC) == 0) {
            try {
                downstream.onSubscribe(this);
            }
            catch (Throwable t2) {
                this.cancelOnError(downstream, this.recordError(t2), true);
            }
        }
    }

    private Throwable recordError(Throwable error) {
        do {
            Throwable currentError;
            if ((currentError = this.pendingError) == null) continue;
            currentError.addSuppressed(error);
            return currentError;
        } while (!PENDING_ERROR.compareAndSet(this, null, error));
        return error;
    }

    private int getAndBitwiseOrState(int bits) {
        return STATE.getAndBitwiseOr(this, bits);
    }

    protected long currentDemand() {
        return this.demand;
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            STATE = lookup.findVarHandle(AbstractSubscription.class, "state", Integer.TYPE);
            DEMAND = lookup.findVarHandle(AbstractSubscription.class, "demand", Long.TYPE);
            PENDING_ERROR = lookup.findVarHandle(AbstractSubscription.class, "pendingError", Throwable.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

