/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.extensions;

import java.net.http.HttpHeaders;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiPredicate;

public final class HeadersBuilder {
    private final Map<String, List<String>> headersMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);

    public void add(String name, String value) {
        this.headersMap.computeIfAbsent(name, __ -> new ArrayList()).add(value);
    }

    public void add(String name, List<String> values2) {
        if (!values2.isEmpty()) {
            this.headersMap.computeIfAbsent(name, __ -> new ArrayList()).addAll(values2);
        }
    }

    public void addAll(Map<String, List<String>> headers) {
        headers.forEach(this::add);
    }

    public void addAll(HttpHeaders headers) {
        this.addAll(headers.map());
    }

    public void set(String name, String value) {
        this.set(name, List.of(value));
    }

    public void set(String name, List<String> values2) {
        if (!values2.isEmpty()) {
            this.headersMap.put(name, new ArrayList<String>(values2));
        }
    }

    public void setAll(HttpHeaders headers) {
        headers.map().forEach(this::set);
    }

    public boolean remove(String name) {
        return this.headersMap.remove(name) != null;
    }

    public void removeIf(BiPredicate<String, String> filter) {
        Iterator<Map.Entry<String, List<String>>> iter = this.headersMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, List<String>> entry = iter.next();
            String name = entry.getKey();
            List<String> values2 = entry.getValue();
            values2.removeIf((? super E value) -> filter.test(name, (String)value));
            if (!values2.isEmpty()) continue;
            iter.remove();
        }
    }

    public void clear() {
        this.headersMap.clear();
    }

    public HeadersBuilder deepCopy() {
        HeadersBuilder copy = new HeadersBuilder();
        copy.addAll(this.headersMap);
        return copy;
    }

    public HttpHeaders build() {
        return HttpHeaders.of(this.headersMap, (n, v) -> true);
    }
}

