/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.extensions;

import com.github.mizosoft.methanol.Methanol;
import com.github.mizosoft.methanol.internal.extensions.ImmutableResponseInfo;
import com.github.mizosoft.methanol.internal.extensions.ResponseBuilder;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.function.Function;

public class Handlers {
    private Handlers() {
    }

    public static <T> CompletableFuture<HttpResponse<T>> handleAsync(HttpResponse<Flow.Publisher<List<ByteBuffer>>> response, HttpResponse.BodyHandler<T> handler, Executor executor) {
        return Handlers.handleAsync(response, response.body(), handler, executor);
    }

    public static <T> CompletableFuture<HttpResponse<T>> handleAsync(HttpResponse<?> response, Flow.Publisher<List<ByteBuffer>> bodyPublisher, HttpResponse.BodyHandler<T> handler, Executor executor) {
        CompletableFuture<HttpResponse.BodySubscriber> subscriberFuture = CompletableFuture.supplyAsync(() -> handler.apply(ImmutableResponseInfo.from(response)), executor);
        subscriberFuture.thenAcceptAsync(bodyPublisher::subscribe, executor);
        return ((CompletableFuture)subscriberFuture.thenComposeAsync(HttpResponse.BodySubscriber::getBody, executor)).thenApply(body -> ResponseBuilder.newBuilder(response).body(body).build());
    }

    public static <T> Methanol.Interceptor.Chain<Flow.Publisher<List<ByteBuffer>>> toPublisherChain(Methanol.Interceptor.Chain<T> chain, Executor handlerExecutor) {
        HttpResponse.PushPromiseHandler screenedPushPromiseHandler = chain.pushPromiseHandler().map(pushHandler -> Handlers.screenPushPromiseHandler(pushHandler, handlerExecutor)).orElse(null);
        return chain.with(HttpResponse.BodyHandlers.ofPublisher(), screenedPushPromiseHandler);
    }

    private static <T> HttpResponse.PushPromiseHandler<Flow.Publisher<List<ByteBuffer>>> screenPushPromiseHandler(HttpResponse.PushPromiseHandler<T> downstreamPushPromiseHandler, Executor executor) {
        return (initiatingRequest, pushPromiseRequest, acceptor) -> {
            Function downstreamAcceptor = bodyHandler -> ((CompletableFuture)acceptor.apply(HttpResponse.BodyHandlers.ofPublisher())).thenCompose(response -> Handlers.handleAsync(response, bodyHandler, executor));
            downstreamPushPromiseHandler.applyPushPromise(initiatingRequest, pushPromiseRequest, downstreamAcceptor);
        };
    }
}

