/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.decoder;

import com.github.mizosoft.methanol.decoder.AsyncDecoder;
import com.github.mizosoft.methanol.internal.decoder.InflaterUtils;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.Inflater;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class DeflateDecoder
implements AsyncDecoder {
    static final String ENCODING = "deflate";
    private static final int CM_MASK = 3840;
    private static final int CM_DEFLATE = 2048;
    private static final Object CLOSED = new Object();
    private final AtomicReference<@MonotonicNonNull Object> inflaterReference = new AtomicReference();

    DeflateDecoder() {
    }

    @Override
    public String encoding() {
        return ENCODING;
    }

    @Override
    public void decode(AsyncDecoder.ByteSource source2, AsyncDecoder.ByteSink sink2) throws IOException {
        Inflater inflater;
        Object inflaterPlaceholder = this.inflaterReference.get();
        if (inflaterPlaceholder == null) {
            if (source2.remaining() < 2L) {
                return;
            }
            ByteBuffer header = ByteBuffer.allocate(2);
            source2.pullBytes(header);
            header.flip();
            boolean nowrap = !DeflateDecoder.isProbablyZLibHeader(header.getShort());
            inflater = new Inflater(nowrap);
            if (!this.inflaterReference.compareAndSet(null, inflater)) {
                inflater.end();
                return;
            }
            inflater.setInput(header.rewind());
        } else if (inflaterPlaceholder != CLOSED) {
            inflater = (Inflater)inflaterPlaceholder;
        } else {
            return;
        }
        InflaterUtils.inflateSource(inflater, source2, sink2);
        if (inflater.finished()) {
            if (source2.hasRemaining()) {
                throw new IOException("deflate stream finished prematurely");
            }
        } else if (source2.finalSource()) {
            assert (!source2.hasRemaining());
            throw new EOFException("unexpected end of deflate stream");
        }
    }

    @Override
    public void close() {
        Object inflater = this.inflaterReference.getAndSet(CLOSED);
        if (inflater instanceof Inflater) {
            ((Inflater)inflater).end();
        }
    }

    private static boolean isProbablyZLibHeader(short header) {
        return (header & 0xF00) == 2048 && header % 31 == 0;
    }
}

