/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.cache;

import com.github.mizosoft.methanol.HttpStatus;
import com.github.mizosoft.methanol.Methanol;
import com.github.mizosoft.methanol.MutableRequest;
import com.github.mizosoft.methanol.internal.Utils;
import com.github.mizosoft.methanol.internal.Validate;
import com.github.mizosoft.methanol.internal.extensions.Handlers;
import com.github.mizosoft.methanol.internal.extensions.ResponseBuilder;
import com.github.mizosoft.methanol.internal.flow.FlowSupport;
import com.github.mizosoft.methanol.internal.function.Unchecked;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class RedirectingInterceptor
implements Methanol.Interceptor {
    private static final int DEFAULT_MAX_REDIRECTS = 5;
    private static final int MAX_REDIRECTS = Integer.getInteger("jdk.httpclient.redirects.retrylimit", 5);
    private final HttpClient.Redirect policy;
    private final Executor handlerExecutor;

    public RedirectingInterceptor(HttpClient.Redirect policy, @Nullable Executor handlerExecutor) {
        this.policy = policy;
        this.handlerExecutor = Objects.requireNonNullElseGet(handlerExecutor, () -> Executors.newCachedThreadPool(runnable2 -> {
            Thread thread2 = new Thread(runnable2);
            thread2.setDaemon(true);
            return thread2;
        }));
    }

    @Override
    public <T> HttpResponse<T> intercept(HttpRequest request, Methanol.Interceptor.Chain<T> chain) throws IOException, InterruptedException {
        if (this.policy == HttpClient.Redirect.NEVER) {
            return chain.forward(request);
        }
        return Utils.block(this.doIntercept(request, chain, false));
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> interceptAsync(HttpRequest request, Methanol.Interceptor.Chain<T> chain) {
        if (this.policy == HttpClient.Redirect.NEVER) {
            return chain.forwardAsync(request);
        }
        return this.doIntercept(request, chain, true);
    }

    private <T> CompletableFuture<HttpResponse<T>> doIntercept(HttpRequest request, Methanol.Interceptor.Chain<T> chain, boolean async) {
        return ((CompletableFuture)new Redirector(request, new SendAdapter(Handlers.toPublisherChain(chain, this.handlerExecutor), async)).sendAndFollowUp().thenApply(Redirector::result)).thenCompose(response -> Handlers.handleAsync(response, chain.bodyHandler(), this.handlerExecutor));
    }

    private final class Redirector {
        private final HttpRequest request;
        private final SendAdapter sendAdapter;
        private final AtomicInteger redirectCount;
        private final @Nullable HttpResponse<Flow.Publisher<List<ByteBuffer>>> response;
        private final @Nullable HttpResponse<Flow.Publisher<List<ByteBuffer>>> previousResponse;

        Redirector(HttpRequest request, SendAdapter sendAdapter) {
            this(request, sendAdapter, new AtomicInteger(), null, null);
        }

        private Redirector(HttpRequest request, SendAdapter sendAdapter, @Nullable AtomicInteger redirectCount, @Nullable HttpResponse<Flow.Publisher<List<ByteBuffer>>> response, HttpResponse<Flow.Publisher<List<ByteBuffer>>> previousResponse) {
            this.request = request;
            this.sendAdapter = sendAdapter;
            this.redirectCount = redirectCount;
            this.response = response;
            this.previousResponse = previousResponse;
        }

        HttpResponse<Flow.Publisher<List<ByteBuffer>>> result() {
            Validate.requireState(this.response != null, "absent response");
            return Validate.castNonNull(this.response);
        }

        private Redirector withResponse(HttpResponse<Flow.Publisher<List<ByteBuffer>>> response) {
            HttpResponse<Flow.Publisher<List<ByteBuffer>>> newResponse = response;
            if (this.previousResponse != null) {
                HttpResponse<Flow.Publisher<List<ByteBuffer>>> previousResponseWithoutBody = ResponseBuilder.newBuilder(this.previousResponse).dropBody().build();
                newResponse = ResponseBuilder.newBuilder(response).previousResponse(previousResponseWithoutBody).build();
            }
            return new Redirector(this.request, this.sendAdapter, this.redirectCount, newResponse, null);
        }

        CompletableFuture<Redirector> sendAndFollowUp() {
            return ((CompletableFuture)this.sendAdapter.send(this.request).thenApply(this::withResponse)).thenCompose(Redirector::followUp);
        }

        CompletableFuture<Redirector> followUp() {
            HttpResponse<Flow.Publisher<List<ByteBuffer>>> response = this.result();
            HttpRequest redirectedRequest = this.redirectedRequest(response);
            if (redirectedRequest == null || this.redirectCount.incrementAndGet() > MAX_REDIRECTS) {
                return CompletableFuture.completedFuture(this);
            }
            Handlers.handleAsync(response, HttpResponse.BodyHandlers.discarding(), RedirectingInterceptor.this.handlerExecutor);
            return new Redirector(redirectedRequest, this.sendAdapter, this.redirectCount, null, response).sendAndFollowUp();
        }

        public @Nullable HttpRequest redirectedRequest(HttpResponse<?> response) {
            if (RedirectingInterceptor.this.policy == HttpClient.Redirect.NEVER) {
                return null;
            }
            int statusCode = response.statusCode();
            if (this.isRedirecting(statusCode) && statusCode != 304) {
                URI redirectedUri = this.redirectedUri(response.headers());
                String newMethod = this.redirectedMethod(response.statusCode());
                if (this.canRedirectTo(redirectedUri)) {
                    return this.createRedirectedRequest(redirectedUri, statusCode, newMethod);
                }
            }
            return null;
        }

        private URI redirectedUri(HttpHeaders responseHeaders) {
            return responseHeaders.firstValue("Location").map(this.request.uri()::resolve).orElseThrow(() -> new UncheckedIOException(new IOException("invalid redirection")));
        }

        private String redirectedMethod(int statusCode) {
            String originalMethod = this.request.method();
            switch (statusCode) {
                case 301: 
                case 302: {
                    return originalMethod.equals("POST") ? "GET" : originalMethod;
                }
                case 303: {
                    return "GET";
                }
            }
            return originalMethod;
        }

        private boolean canRedirectTo(URI redirectedUri) {
            String oldScheme = this.request.uri().getScheme();
            String newScheme = redirectedUri.getScheme();
            switch (RedirectingInterceptor.this.policy) {
                case ALWAYS: {
                    return true;
                }
                case NEVER: {
                    return false;
                }
                case NORMAL: {
                    return newScheme.equalsIgnoreCase(oldScheme) || newScheme.equalsIgnoreCase("https");
                }
            }
            throw new AssertionError((Object)("unexpected policy: " + RedirectingInterceptor.this.policy));
        }

        private HttpRequest createRedirectedRequest(URI redirectedUri, int statusCode, String newMethod) {
            boolean retainBody = statusCode != 303 && this.request.method().equals(newMethod);
            HttpRequest.BodyPublisher newBody = this.request.bodyPublisher().filter(__ -> retainBody).orElseGet(HttpRequest.BodyPublishers::noBody);
            return MutableRequest.copyOf(this.request).uri(redirectedUri).method(newMethod, newBody);
        }

        private boolean isRedirecting(int statusCode) {
            if (!HttpStatus.isRedirection(statusCode) || statusCode > 308) {
                return false;
            }
            switch (statusCode) {
                case 300: 
                case 304: 
                case 305: 
                case 306: {
                    return false;
                }
            }
            return true;
        }
    }

    private static final class SendAdapter {
        private final Methanol.Interceptor.Chain<Flow.Publisher<List<ByteBuffer>>> chain;
        private final boolean async;

        SendAdapter(Methanol.Interceptor.Chain<Flow.Publisher<List<ByteBuffer>>> chain, boolean async) {
            this.chain = chain;
            this.async = async;
        }

        CompletableFuture<HttpResponse<Flow.Publisher<List<ByteBuffer>>>> send(HttpRequest request) {
            return this.async ? this.chain.forwardAsync(request) : Unchecked.supplyAsync(() -> this.chain.forward(request), FlowSupport.SYNC_EXECUTOR);
        }
    }
}

