/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.cache;

import com.github.mizosoft.methanol.internal.Utils;
import com.github.mizosoft.methanol.internal.Validate;
import com.github.mizosoft.methanol.internal.cache.Store;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class MemoryStore
implements Store {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private final long maxSize;
    private final AtomicLong size = new AtomicLong();
    private final Map<String, Entry> entries = new LinkedHashMap<String, Entry>(16, 0.75f, true);

    public MemoryStore(long maxSize) {
        Validate.requireArgument(maxSize > 0L, "non-positive maxSize: %s", maxSize);
        this.maxSize = maxSize;
    }

    @Override
    public Optional<Executor> executor() {
        return Optional.empty();
    }

    @Override
    public void initialize() throws IOException {
    }

    @Override
    public CompletableFuture<Void> initializeAsync() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public long maxSize() {
        return this.maxSize;
    }

    @Override
    public long size() {
        return this.size.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Store.Viewer view(String key) {
        Objects.requireNonNull(key);
        Map<String, Entry> map = this.entries;
        synchronized (map) {
            Entry entry = this.entries.get(key);
            return entry != null ? entry.view() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Store.Editor edit(String key) {
        Objects.requireNonNull(key);
        Map<String, Entry> map = this.entries;
        synchronized (map) {
            return this.entries.computeIfAbsent(key, x$0 -> new Entry((String)x$0)).edit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Store.Viewer> iterator() {
        Map<String, Entry> map = this.entries;
        synchronized (map) {
            return new ViewerIterator(Set.copyOf(this.entries.keySet()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String key) {
        Objects.requireNonNull(key);
        Map<String, Entry> map = this.entries;
        synchronized (map) {
            Entry entry = this.entries.get(key);
            if (entry != null) {
                this.evict(entry);
                this.entries.remove(key);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<String, Entry> map = this.entries;
        synchronized (map) {
            Iterator<Entry> iter = this.entries.values().iterator();
            while (iter.hasNext()) {
                this.evict(iter.next());
                iter.remove();
            }
        }
    }

    @Override
    public void dispose() {
        this.clear();
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    private long evict(Entry entry) {
        assert (Thread.holdsLock(this.entries));
        entry.markEvicted();
        MemoryViewer viewer = entry.view();
        long evictedSize = viewer != null ? viewer.entrySize() : 0L;
        return this.size.addAndGet(-evictedSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictExcessiveEntries() {
        Map<String, Entry> map = this.entries;
        synchronized (map) {
            long currentSize = this.size.get();
            Iterator<Entry> iter = this.entries.values().iterator();
            while (currentSize > this.maxSize && iter.hasNext()) {
                currentSize = this.evict(iter.next());
                iter.remove();
            }
        }
    }

    private final class Entry {
        private static final int ANY_VERSION = -1;
        private final Lock lock = new ReentrantLock();
        final String key;
        private ByteBuffer metadata = EMPTY_BUFFER;
        private ByteBuffer data = EMPTY_BUFFER;
        private @Nullable MemoryEditor currentEditor;
        private boolean evicted;
        private int version;

        Entry(String key) {
            this.key = key;
        }

        @Nullable MemoryViewer view() {
            this.lock.lock();
            try {
                MemoryViewer memoryViewer = this.version > 0 ? new MemoryViewer(this, this.version, this.metadata.duplicate(), this.data.duplicate()) : null;
                return memoryViewer;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Nullable MemoryEditor edit() {
            return this.edit(-1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable MemoryEditor edit(int targetVersion) {
            this.lock.lock();
            try {
                if (!(this.currentEditor != null || targetVersion != -1 && targetVersion != this.version || this.evicted)) {
                    MemoryEditor editor;
                    this.currentEditor = editor = new MemoryEditor(this);
                    MemoryEditor memoryEditor = editor;
                    return memoryEditor;
                }
                MemoryEditor memoryEditor = null;
                return memoryEditor;
            }
            finally {
                this.lock.unlock();
            }
        }

        void markEvicted() {
            this.lock.lock();
            try {
                this.evicted = true;
            }
            finally {
                this.lock.unlock();
            }
        }

        boolean versionMatches(int targetVersion) {
            this.lock.lock();
            try {
                boolean bl = this.version == targetVersion;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void commitEdit(MemoryEditor editor, @Nullable ByteBuffer newMetadata, @Nullable ByteBuffer newData) {
            long newEntrySize;
            long oldEntrySize;
            boolean evictAfterDiscardedFirstEdit = false;
            this.lock.lock();
            try {
                assert (this.currentEditor == editor);
                this.currentEditor = null;
                if (newMetadata == null && newData == null || this.evicted) {
                    evictAfterDiscardedFirstEdit = this.version == 0 && !this.evicted;
                    return;
                }
                oldEntrySize = (long)this.metadata.remaining() + (long)this.data.remaining();
                if (newMetadata != null) {
                    this.metadata = newMetadata.asReadOnlyBuffer();
                }
                if (newData != null) {
                    this.data = newData.asReadOnlyBuffer();
                }
                newEntrySize = (long)this.metadata.remaining() + (long)this.data.remaining();
                ++this.version;
            }
            finally {
                this.lock.unlock();
                if (evictAfterDiscardedFirstEdit) {
                    Map<String, Entry> map = MemoryStore.this.entries;
                    synchronized (map) {
                        this.lock.lock();
                        try {
                            if (this.version == 0) {
                                MemoryStore.this.entries.remove(this.key, this);
                            }
                        }
                        finally {
                            this.lock.unlock();
                        }
                    }
                }
            }
            long netEntrySize = newEntrySize - oldEntrySize;
            if (MemoryStore.this.size.addAndGet(netEntrySize) > MemoryStore.this.maxSize) {
                MemoryStore.this.evictExcessiveEntries();
            }
        }
    }

    private final class MemoryViewer
    implements Store.Viewer {
        final Entry entry;
        private final int entryVersion;
        private final ByteBuffer data;
        private final ByteBuffer metadata;

        MemoryViewer(Entry entry, int entryVersion, ByteBuffer metadata, ByteBuffer data) {
            this.entry = entry;
            this.entryVersion = entryVersion;
            this.data = data;
            this.metadata = metadata;
        }

        @Override
        public String key() {
            return this.entry.key;
        }

        @Override
        public final ByteBuffer metadata() {
            return this.metadata.duplicate();
        }

        @Override
        public CompletableFuture<Integer> readAsync(long position, ByteBuffer dst) {
            int readCount;
            Objects.requireNonNull(dst);
            if (position < (long)this.data.limit()) {
                ByteBuffer duplicateData = this.data.duplicate();
                readCount = Utils.copyRemaining(duplicateData.position((int)position), dst);
            } else {
                readCount = -1;
            }
            return CompletableFuture.completedFuture(readCount);
        }

        @Override
        public long dataSize() {
            return this.data.remaining();
        }

        @Override
        public long entrySize() {
            return (long)this.metadata.remaining() + (long)this.data.remaining();
        }

        @Override
        public @Nullable Store.Editor edit() {
            return this.entry.edit(this.entryVersion);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeEntry() {
            Map<String, Entry> map = MemoryStore.this.entries;
            synchronized (map) {
                if (this.entry.versionMatches(this.entryVersion) && MemoryStore.this.entries.remove(this.entry.key, this.entry)) {
                    MemoryStore.this.evict(this.entry);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void close() {
        }
    }

    private static final class MemoryEditor
    implements Store.Editor {
        private final Entry entry;
        private final GrowableBuffer data = new GrowableBuffer();
        private final Lock lock = new ReentrantLock();
        private ByteBuffer metadata = EMPTY_BUFFER;
        private boolean editedMetadata;
        private boolean editedData;
        private boolean committed;

        MemoryEditor(Entry entry) {
            this.entry = entry;
        }

        @Override
        public String key() {
            return this.entry.key;
        }

        @Override
        public void metadata(ByteBuffer metadata) {
            Objects.requireNonNull(metadata);
            this.lock.lock();
            try {
                this.requireNotCommitted();
                this.metadata = Utils.copy(metadata, this.metadata);
                this.editedMetadata = true;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompletableFuture<Integer> writeAsync(long position, ByteBuffer src) {
            Objects.requireNonNull(src);
            this.lock.lock();
            try {
                this.requireNotCommitted();
                this.editedData = true;
                CompletableFuture<Integer> completableFuture = CompletableFuture.completedFuture(this.data.write(position, src));
                return completableFuture;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void commitOnClose() {
            this.lock.lock();
            try {
                this.committed = true;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void close() {
            ByteBuffer newMetadata = null;
            ByteBuffer newData = null;
            this.lock.lock();
            try {
                if (this.committed) {
                    newMetadata = this.editedMetadata ? Utils.copy(this.metadata) : null;
                    newData = this.editedData ? this.data.snapshot() : null;
                }
            }
            finally {
                this.lock.unlock();
            }
            this.entry.commitEdit(this, newMetadata, newData);
        }

        private void requireNotCommitted() {
            Validate.requireState(!this.committed, "committed");
        }
    }

    private final class ViewerIterator
    implements Iterator<Store.Viewer> {
        private final Iterator<String> keysIterator;
        private @Nullable MemoryViewer nextViewer;
        private @Nullable MemoryViewer currentViewer;

        ViewerIterator(Set<String> keysSnapshot) {
            this.keysIterator = keysSnapshot.iterator();
        }

        @Override
        @EnsuresNonNullIf(expression={"nextViewer"}, result=true)
        public boolean hasNext() {
            return this.nextViewer != null || this.findNextViewer();
        }

        @Override
        public Store.Viewer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            MemoryViewer viewer = Validate.castNonNull(this.nextViewer);
            this.nextViewer = null;
            this.currentViewer = viewer;
            return viewer;
        }

        @Override
        public void remove() {
            MemoryViewer viewer = this.currentViewer;
            Validate.requireState(viewer != null, "next() must be called before remove()");
            this.currentViewer = null;
            viewer.removeEntry();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @EnsuresNonNullIf(expression={"nextViewer"}, result=true)
        private boolean findNextViewer() {
            assert (this.nextViewer == null);
            Map<String, Entry> map = MemoryStore.this.entries;
            synchronized (map) {
                while (this.keysIterator.hasNext()) {
                    Entry entry = MemoryStore.this.entries.get(this.keysIterator.next());
                    MemoryViewer viewer = entry != null ? entry.view() : null;
                    if (viewer == null) continue;
                    this.nextViewer = viewer;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class GrowableBuffer {
        private final SeekableByteArrayOutputStream output = new SeekableByteArrayOutputStream();

        private GrowableBuffer() {
        }

        int write(long position, ByteBuffer src) {
            this.output.position(position);
            int writeCount = src.remaining();
            if (src.hasArray()) {
                this.output.write(src.array(), src.arrayOffset() + src.position(), writeCount);
                src.position(writeCount);
            } else {
                byte[] srcCopy = new byte[writeCount];
                src.get(srcCopy);
                this.output.write(srcCopy);
            }
            return writeCount;
        }

        ByteBuffer snapshot() {
            return ByteBuffer.allocate(this.output.fence()).put(this.output.array(), 0, this.output.fence()).flip();
        }

        private static final class SeekableByteArrayOutputStream
        extends ByteArrayOutputStream {
            private int fence;

            SeekableByteArrayOutputStream() {
            }

            @Override
            public void write(int b) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void write(byte[] b, int off, int len) {
                super.write(b, off, len);
                this.fence = Math.max(this.fence, this.count);
            }

            @Override
            public void write(byte[] b) {
                this.write(b, 0, b.length);
            }

            byte[] array() {
                return this.buf;
            }

            int fence() {
                return this.fence;
            }

            void position(long position) {
                Validate.requireArgument(position >= 0L && position <= (long)this.fence, "position out of range: %d", position);
                this.count = (int)position;
            }
        }
    }
}

