/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol;

import com.github.mizosoft.methanol.CacheAwareResponse;
import com.github.mizosoft.methanol.Methanol;
import com.github.mizosoft.methanol.TrackedResponse;
import com.github.mizosoft.methanol.internal.Utils;
import com.github.mizosoft.methanol.internal.Validate;
import com.github.mizosoft.methanol.internal.cache.CacheInterceptor;
import com.github.mizosoft.methanol.internal.cache.CacheReadingPublisher;
import com.github.mizosoft.methanol.internal.cache.CacheResponse;
import com.github.mizosoft.methanol.internal.cache.CacheResponseMetadata;
import com.github.mizosoft.methanol.internal.cache.CacheWritingPublisher;
import com.github.mizosoft.methanol.internal.cache.DiskStore;
import com.github.mizosoft.methanol.internal.cache.InternalCache;
import com.github.mizosoft.methanol.internal.cache.MemoryStore;
import com.github.mizosoft.methanol.internal.cache.NetworkResponse;
import com.github.mizosoft.methanol.internal.cache.Store;
import com.github.mizosoft.methanol.internal.cache.StoreCorruptionException;
import java.io.Flushable;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.nio.file.Path;
import java.time.Clock;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.LongAdder;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class HttpCache
implements AutoCloseable,
Flushable {
    private static final System.Logger logger = System.getLogger(HttpCache.class.getName());
    private static final int CACHE_VERSION = 1;
    private final Store store;
    private final Executor executor;
    private final boolean userVisibleExecutor;
    private final StatsRecorder statsRecorder;
    private final CacheListener listener;
    private final Clock clock;
    private final InternalCache internalCache = new InternalCacheView();

    private HttpCache(Builder builder) {
        Executor userExecutor = builder.executor;
        if (userExecutor != null) {
            this.executor = userExecutor;
            this.userVisibleExecutor = true;
        } else {
            this.executor = Executors.newCachedThreadPool(runnable2 -> {
                Thread thread2 = new Thread(runnable2);
                thread2.setDaemon(true);
                return thread2;
            });
            this.userVisibleExecutor = false;
        }
        StoreFactory storeFactory = builder.storeFactory;
        this.store = Objects.requireNonNullElseGet(builder.store, () -> storeFactory.create(builder.cacheDirectory, builder.maxSize, this.executor));
        this.statsRecorder = Objects.requireNonNullElseGet(builder.statsRecorder, StatsRecorder::createConcurrentRecorder);
        this.listener = new CacheListener(this.statsRecorder, builder.listener);
        this.clock = Objects.requireNonNullElseGet(builder.clock, Utils::systemMillisUtc);
    }

    Store storeForTesting() {
        return this.store;
    }

    public Optional<Path> directory() {
        return this.store instanceof DiskStore ? Optional.of(((DiskStore)this.store).directory()) : Optional.empty();
    }

    public long maxSize() {
        return this.store.maxSize();
    }

    public Optional<Executor> executor() {
        return this.userVisibleExecutor ? Optional.of(this.executor) : Optional.empty();
    }

    public Optional<Listener> listener() {
        return this.listener.userListener();
    }

    public long size() throws IOException {
        return this.store.size();
    }

    public Stats stats() {
        return this.statsRecorder.snapshot();
    }

    public Stats stats(URI uri) {
        return this.statsRecorder.snapshot(uri);
    }

    public void initialize() throws IOException {
        this.store.initialize();
    }

    public CompletableFuture<Void> initializeAsync() {
        return this.store.initializeAsync();
    }

    public Iterator<URI> uris() throws IOException {
        return new Iterator<URI>(){
            private final Iterator<Store.Viewer> storeIterator;
            private @Nullable URI nextUri;
            private boolean canRemove;
            {
                this.storeIterator = HttpCache.this.store.iterator();
            }

            @Override
            public boolean hasNext() {
                this.canRemove = false;
                return this.nextUri != null || this.findNextUri();
            }

            @Override
            public URI next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                URI uri = Validate.castNonNull(this.nextUri);
                this.nextUri = null;
                this.canRemove = true;
                return uri;
            }

            @Override
            public void remove() {
                Validate.requireState(this.canRemove, "next() must be called before remove()");
                this.canRemove = false;
                this.storeIterator.remove();
            }

            private boolean findNextUri() {
                while (this.nextUri == null && this.storeIterator.hasNext()) {
                    Store.Viewer viewer = this.storeIterator.next();
                    try {
                        CacheResponseMetadata metadata = HttpCache.tryRecoverMetadata(viewer);
                        if (metadata == null) continue;
                        this.nextUri = metadata.uri();
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        if (viewer == null) continue;
                        viewer.close();
                    }
                }
                return false;
            }
        };
    }

    public void clear() throws IOException {
        this.store.clear();
    }

    public boolean remove(URI uri) throws IOException {
        Objects.requireNonNull(uri);
        return this.store.remove(HttpCache.key(uri));
    }

    public boolean remove(HttpRequest request) throws IOException {
        Objects.requireNonNull(request);
        try (Store.Viewer viewer = this.store.view(HttpCache.key(request));){
            if (viewer != null && CacheResponseMetadata.decode(viewer.metadata()).matches(request)) {
                boolean bl = viewer.removeEntry();
                return bl;
            }
        }
        return false;
    }

    public void dispose() throws IOException {
        this.store.dispose();
    }

    @Override
    public void flush() throws IOException {
        this.store.flush();
    }

    @Override
    public void close() throws IOException {
        this.store.close();
    }

    Methanol.Interceptor interceptor(@Nullable Executor clientExecutor) {
        return new CacheInterceptor(this.internalCache, this.listener, this.executor, Objects.requireNonNullElse(clientExecutor, this.executor), this.clock);
    }

    private static String key(HttpRequest request) {
        return HttpCache.key(request.uri());
    }

    private static String key(URI uri) {
        return uri.toString();
    }

    private static @Nullable CacheResponseMetadata tryRecoverMetadata(Store.Viewer viewer) {
        try {
            return CacheResponseMetadata.decode(viewer.metadata());
        }
        catch (IOException e) {
            logger.log(System.Logger.Level.WARNING, "unrecoverable cache entry", (Throwable)e);
            return null;
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private final class InternalCacheView
    implements InternalCache {
        InternalCacheView() {
        }

        @Override
        public @Nullable CacheResponse get(HttpRequest request) throws IOException {
            Store.Viewer viewer;
            try {
                viewer = HttpCache.this.store.view(HttpCache.key(request));
            }
            catch (StoreCorruptionException e) {
                logger.log(System.Logger.Level.WARNING, "unrecoverable cache entry", (Throwable)e);
                return null;
            }
            if (viewer == null) {
                return null;
            }
            CacheResponseMetadata metadata = HttpCache.tryRecoverMetadata(viewer);
            if (metadata != null && metadata.matches(request)) {
                return new CacheResponse(metadata, viewer, HttpCache.this.executor, HttpCache.this.listener.readListener(request), request, HttpCache.this.clock.instant());
            }
            viewer.close();
            return null;
        }

        @Override
        public void update(CacheResponse cacheResponse) {
            TrackedResponse<?> response = cacheResponse.get();
            try (Store.Editor editor = cacheResponse.edit();){
                if (editor != null) {
                    editor.metadata(CacheResponseMetadata.from(response).encode());
                    editor.commitOnClose();
                }
            }
            catch (IOException e) {
                logger.log(System.Logger.Level.WARNING, "cache update failure", (Throwable)e);
            }
        }

        @Override
        public @Nullable NetworkResponse put(HttpRequest request, @Nullable CacheResponse cacheResponse, NetworkResponse networkResponse) {
            try {
                Store.Editor editor;
                Store.Editor editor2 = editor = cacheResponse != null ? cacheResponse.edit() : HttpCache.this.store.edit(HttpCache.key(request));
                if (editor != null) {
                    editor.metadata(CacheResponseMetadata.from(networkResponse.get()).encode());
                    return networkResponse.writingWith(editor, HttpCache.this.listener.writeListener(request));
                }
            }
            catch (IOException e) {
                logger.log(System.Logger.Level.WARNING, "failed to start cache edit", (Throwable)e);
            }
            return null;
        }

        @Override
        public void remove(URI uri) {
            try {
                HttpCache.this.remove(uri);
            }
            catch (IOException e) {
                logger.log(System.Logger.Level.WARNING, "entry removal failure", (Throwable)e);
            }
        }
    }

    public static final class Builder {
        long maxSize;
        @MonotonicNonNull StoreFactory storeFactory;
        @MonotonicNonNull Path cacheDirectory;
        @MonotonicNonNull Executor executor;
        @MonotonicNonNull StatsRecorder statsRecorder;
        @MonotonicNonNull Listener listener;
        @MonotonicNonNull Clock clock;
        @MonotonicNonNull Store store;

        Builder() {
        }

        public Builder cacheOnMemory(long maxSize) {
            this.checkMaxSize(maxSize);
            this.maxSize = maxSize;
            this.storeFactory = StoreFactory.MEMORY;
            return this;
        }

        public Builder cacheOnDisk(Path directory, long maxSize) {
            this.checkMaxSize(maxSize);
            this.cacheDirectory = Objects.requireNonNull(directory);
            this.maxSize = maxSize;
            this.storeFactory = StoreFactory.DISK;
            return this;
        }

        public Builder executor(Executor executor) {
            this.executor = Objects.requireNonNull(executor);
            return this;
        }

        public Builder statsRecorder(StatsRecorder statsRecorder) {
            this.statsRecorder = Objects.requireNonNull(statsRecorder);
            return this;
        }

        public Builder listener(Listener listener) {
            this.listener = Objects.requireNonNull(listener);
            return this;
        }

        Builder clockForTesting(Clock clock) {
            this.clock = Objects.requireNonNull(clock);
            return this;
        }

        Builder storeForTesting(Store store) {
            this.store = Objects.requireNonNull(store);
            return this;
        }

        public HttpCache build() {
            Validate.requireState(this.storeFactory != null || this.store != null, "caching method must be specified");
            return new HttpCache(this);
        }

        private void checkMaxSize(long maxSize) {
            Validate.requireArgument(maxSize > 0L, "non-positive maxSize");
        }
    }

    private static enum StoreFactory {
        MEMORY{

            @Override
            Store create(@Nullable Path directory, long maxSize, Executor executor) {
                return new MemoryStore(maxSize);
            }
        }
        ,
        DISK{

            @Override
            Store create(@Nullable Path directory, long maxSize, Executor executor) {
                Objects.requireNonNull(directory, "DiskStore requires a directory");
                return DiskStore.newBuilder().directory(directory).maxSize(maxSize).executor(executor).appVersion(1).build();
            }
        };


        abstract Store create(@Nullable Path var1, long var2, Executor var4);
    }

    public static interface StatsRecorder {
        public void recordRequest(URI var1);

        public void recordHit(URI var1);

        public void recordMiss(URI var1);

        public void recordNetworkUse(URI var1);

        public void recordWriteSuccess(URI var1);

        public void recordWriteFailure(URI var1);

        public Stats snapshot();

        public Stats snapshot(URI var1);

        public static StatsRecorder createConcurrentRecorder() {
            return new ConcurrentStatsRecorder();
        }

        public static StatsRecorder createConcurrentPerUriRecorder() {
            return new ConcurrentPerUriStatsRecorder();
        }

        public static StatsRecorder disabled() {
            return DisabledStatsRecorder.INSTANCE;
        }
    }

    private static final class CacheListener
    implements Listener {
        private final StatsRecorder statsRecorder;
        private final Listener userListener;

        CacheListener(StatsRecorder statsRecorder, @Nullable Listener userListener) {
            this.statsRecorder = statsRecorder;
            this.userListener = Objects.requireNonNullElse(userListener, DisabledListener.INSTANCE);
        }

        CacheReadingPublisher.Listener readListener(final HttpRequest request) {
            return new CacheReadingPublisher.Listener(){

                @Override
                public void onReadSuccess() {
                    this.onReadSuccess(request);
                }

                @Override
                public void onReadFailure(Throwable error) {
                    this.onReadFailure(request, error);
                }
            };
        }

        CacheWritingPublisher.Listener writeListener(final HttpRequest request) {
            return new CacheWritingPublisher.Listener(){

                @Override
                public void onWriteSuccess() {
                    this.onWriteSuccess(request);
                }

                @Override
                public void onWriteFailure(Throwable error) {
                    this.onWriteFailure(request, error);
                }
            };
        }

        Optional<Listener> userListener() {
            return Optional.of(this.userListener).filter(listener -> listener != DisabledListener.INSTANCE);
        }

        @Override
        public void onRequest(HttpRequest request) {
            this.statsRecorder.recordRequest(request.uri());
            this.userListener.onRequest(request);
        }

        @Override
        public void onNetworkUse(HttpRequest request, @Nullable TrackedResponse<?> cacheResponse) {
            this.statsRecorder.recordNetworkUse(request.uri());
            this.userListener.onNetworkUse(request, cacheResponse);
        }

        @Override
        public void onResponse(HttpRequest request, CacheAwareResponse<?> response) {
            switch (response.cacheStatus()) {
                case MISS: 
                case UNSATISFIABLE: {
                    this.statsRecorder.recordMiss(request.uri());
                    break;
                }
                case HIT: 
                case CONDITIONAL_HIT: {
                    this.statsRecorder.recordHit(request.uri());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unexpected status: " + response.cacheStatus()));
                }
            }
            this.userListener.onResponse(request, response);
        }

        @Override
        public void onReadSuccess(HttpRequest request) {
            this.userListener.onReadSuccess(request);
        }

        @Override
        public void onReadFailure(HttpRequest request, Throwable error) {
            this.userListener.onReadFailure(request, error);
        }

        @Override
        public void onWriteSuccess(HttpRequest request) {
            this.statsRecorder.recordWriteSuccess(request.uri());
            this.userListener.onWriteSuccess(request);
        }

        @Override
        public void onWriteFailure(HttpRequest request, Throwable error) {
            this.statsRecorder.recordWriteFailure(request.uri());
            this.userListener.onWriteFailure(request, error);
        }
    }

    public static interface Listener {
        default public void onRequest(HttpRequest request) {
        }

        default public void onNetworkUse(HttpRequest request, @Nullable TrackedResponse<?> cacheResponse) {
        }

        default public void onResponse(HttpRequest request, CacheAwareResponse<?> response) {
        }

        default public void onReadSuccess(HttpRequest request) {
        }

        default public void onReadFailure(HttpRequest request, Throwable error) {
        }

        default public void onWriteSuccess(HttpRequest request) {
        }

        default public void onWriteFailure(HttpRequest request, Throwable error) {
        }
    }

    public static interface Stats {
        public long requestCount();

        public long hitCount();

        public long missCount();

        public long networkUseCount();

        public long writeSuccessCount();

        public long writeFailureCount();

        default public double hitRate() {
            return Stats.rate(this.hitCount(), this.requestCount());
        }

        default public double missRate() {
            return Stats.rate(this.missCount(), this.requestCount());
        }

        private static double rate(long x, long y) {
            return y == 0L || x >= y ? 1.0 : (double)x / (double)y;
        }

        public static Stats empty() {
            return StatsSnapshot.EMPTY;
        }
    }

    private static final class StatsSnapshot
    implements Stats {
        static final Stats EMPTY = new StatsSnapshot(0L, 0L, 0L, 0L, 0L, 0L);
        private final long requestCount;
        private final long hitCount;
        private final long missCount;
        private final long networkUseCount;
        private final long writeSuccessCount;
        private final long writeFailureCount;

        StatsSnapshot(long requestCount, long hitCount, long missCount, long networkUseCount, long writeSuccessCount, long writeFailureCount) {
            this.requestCount = requestCount;
            this.hitCount = hitCount;
            this.missCount = missCount;
            this.networkUseCount = networkUseCount;
            this.writeSuccessCount = writeSuccessCount;
            this.writeFailureCount = writeFailureCount;
        }

        @Override
        public long requestCount() {
            return this.requestCount;
        }

        @Override
        public long hitCount() {
            return this.hitCount;
        }

        @Override
        public long missCount() {
            return this.missCount;
        }

        @Override
        public long networkUseCount() {
            return this.networkUseCount;
        }

        @Override
        public long writeSuccessCount() {
            return this.writeSuccessCount;
        }

        @Override
        public long writeFailureCount() {
            return this.writeFailureCount;
        }

        public int hashCode() {
            return Objects.hash(this.requestCount, this.hitCount, this.missCount, this.networkUseCount, this.writeSuccessCount, this.writeFailureCount);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Stats)) {
                return false;
            }
            Stats other = (Stats)obj;
            return this.requestCount == other.requestCount() && this.hitCount == other.hitCount() && this.missCount == other.missCount() && this.networkUseCount == other.networkUseCount() && this.writeSuccessCount == other.writeSuccessCount() && this.writeFailureCount == other.writeFailureCount();
        }

        public String toString() {
            return String.format("Stats[requestCount=%d, hitCount=%d, missCount=%d, networkUseCount=%d, writeSuccessCount=%d, writeFailureCount=%d]", this.requestCount, this.hitCount, this.missCount, this.networkUseCount, this.writeSuccessCount, this.writeFailureCount);
        }
    }

    private static enum DisabledStatsRecorder implements StatsRecorder
    {
        INSTANCE;


        @Override
        public void recordRequest(URI uri) {
        }

        @Override
        public void recordHit(URI uri) {
        }

        @Override
        public void recordMiss(URI uri) {
        }

        @Override
        public void recordNetworkUse(URI uri) {
        }

        @Override
        public void recordWriteSuccess(URI uri) {
        }

        @Override
        public void recordWriteFailure(URI uri) {
        }

        @Override
        public Stats snapshot() {
            return Stats.empty();
        }

        @Override
        public Stats snapshot(URI uri) {
            return Stats.empty();
        }
    }

    private static final class ConcurrentPerUriStatsRecorder
    extends ConcurrentStatsRecorder {
        private final ConcurrentMap<URI, StatsRecorder> perUriRecorders = new ConcurrentHashMap<URI, StatsRecorder>();

        ConcurrentPerUriStatsRecorder() {
        }

        @Override
        public void recordRequest(URI uri) {
            Objects.requireNonNull(uri);
            super.recordRequest(uri);
            this.perUriRecorders.computeIfAbsent(uri, __ -> new ConcurrentStatsRecorder()).recordRequest(uri);
        }

        @Override
        public void recordHit(URI uri) {
            Objects.requireNonNull(uri);
            super.recordHit(uri);
            this.perUriRecorders.computeIfAbsent(uri, __ -> new ConcurrentStatsRecorder()).recordHit(uri);
        }

        @Override
        public void recordMiss(URI uri) {
            Objects.requireNonNull(uri);
            super.recordMiss(uri);
            this.perUriRecorders.computeIfAbsent(uri, __ -> new ConcurrentStatsRecorder()).recordMiss(uri);
        }

        @Override
        public void recordNetworkUse(URI uri) {
            Objects.requireNonNull(uri);
            super.recordNetworkUse(uri);
            this.perUriRecorders.computeIfAbsent(uri, __ -> new ConcurrentStatsRecorder()).recordNetworkUse(uri);
        }

        @Override
        public void recordWriteSuccess(URI uri) {
            Objects.requireNonNull(uri);
            super.recordWriteSuccess(uri);
            this.perUriRecorders.computeIfAbsent(uri, __ -> new ConcurrentStatsRecorder()).recordWriteSuccess(uri);
        }

        @Override
        public void recordWriteFailure(URI uri) {
            Objects.requireNonNull(uri);
            super.recordWriteFailure(uri);
            this.perUriRecorders.computeIfAbsent(uri, __ -> new ConcurrentStatsRecorder()).recordWriteFailure(uri);
        }

        @Override
        public Stats snapshot(URI uri) {
            StatsRecorder recorder = (StatsRecorder)this.perUriRecorders.get(uri);
            return recorder != null ? recorder.snapshot() : Stats.empty();
        }
    }

    private static class ConcurrentStatsRecorder
    implements StatsRecorder {
        private final LongAdder requestCounter = new LongAdder();
        private final LongAdder hitCounter = new LongAdder();
        private final LongAdder missCounter = new LongAdder();
        private final LongAdder networkUseCounter = new LongAdder();
        private final LongAdder writeSuccessCounter = new LongAdder();
        private final LongAdder writeFailureCounter = new LongAdder();

        ConcurrentStatsRecorder() {
        }

        @Override
        public void recordRequest(URI uri) {
            Objects.requireNonNull(uri);
            this.requestCounter.increment();
        }

        @Override
        public void recordHit(URI uri) {
            Objects.requireNonNull(uri);
            this.hitCounter.increment();
        }

        @Override
        public void recordMiss(URI uri) {
            Objects.requireNonNull(uri);
            this.missCounter.increment();
        }

        @Override
        public void recordNetworkUse(URI uri) {
            Objects.requireNonNull(uri);
            this.networkUseCounter.increment();
        }

        @Override
        public void recordWriteSuccess(URI uri) {
            Objects.requireNonNull(uri);
            this.writeSuccessCounter.increment();
        }

        @Override
        public void recordWriteFailure(URI uri) {
            Objects.requireNonNull(uri);
            this.writeFailureCounter.increment();
        }

        @Override
        public Stats snapshot() {
            return new StatsSnapshot(this.requestCounter.sum(), this.hitCounter.sum(), this.missCounter.sum(), this.networkUseCounter.sum(), this.writeSuccessCounter.sum(), this.writeFailureCounter.sum());
        }

        @Override
        public Stats snapshot(URI uri) {
            return Stats.empty();
        }
    }

    private static enum DisabledListener implements Listener
    {
        INSTANCE;

    }
}

