/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol;

import com.github.mizosoft.methanol.internal.Utils;
import com.github.mizosoft.methanol.internal.Validate;
import com.github.mizosoft.methanol.internal.text.HeaderValueTokenizer;
import java.net.http.HttpHeaders;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CacheControl {
    private static final CacheControl EMPTY = new CacheControl(Map.of(), Map.of());
    private final Map<String, String> directives;
    private final Optional<Duration> maxAge;
    private final Optional<Duration> minFresh;
    private final Optional<Duration> sMaxAge;
    private final Optional<Duration> maxStale;
    private final Optional<Duration> staleWhileRevalidate;
    private final Optional<Duration> staleIfError;
    private final boolean hasMaxStale;
    private final boolean noCache;
    private final boolean noStore;
    private final boolean noTransform;
    private final boolean isPublic;
    private final boolean isPrivate;
    private final boolean onlyIfCached;
    private final boolean mustRevalidate;
    private final boolean proxyRevalidate;
    private final Set<String> noCacheFields;
    private final Set<String> noStoreFields;
    private final Set<String> privateFields;

    private CacheControl(Map<String, String> directives, Map<KnownDirective, ?> knownDirectives) {
        this.directives = Collections.unmodifiableMap(directives);
        this.maxAge = CacheControl.getDurationIfPresent(knownDirectives, KnownDirective.MAX_AGE);
        this.minFresh = CacheControl.getDurationIfPresent(knownDirectives, KnownDirective.MIN_FRESH);
        this.sMaxAge = CacheControl.getDurationIfPresent(knownDirectives, KnownDirective.S_MAXAGE);
        this.maxStale = CacheControl.getDurationIfPresent(knownDirectives, KnownDirective.MAX_STALE);
        this.staleWhileRevalidate = CacheControl.getDurationIfPresent(knownDirectives, KnownDirective.STALE_WHILE_REVALIDATE);
        this.staleIfError = CacheControl.getDurationIfPresent(knownDirectives, KnownDirective.STALE_IF_ERROR);
        this.hasMaxStale = knownDirectives.containsKey((Object)KnownDirective.MAX_STALE);
        this.noCache = knownDirectives.containsKey((Object)KnownDirective.NO_CACHE);
        this.noStore = knownDirectives.containsKey((Object)KnownDirective.NO_STORE);
        this.noTransform = knownDirectives.containsKey((Object)KnownDirective.NO_TRANSFORM);
        this.isPublic = knownDirectives.containsKey((Object)KnownDirective.PUBLIC);
        this.isPrivate = knownDirectives.containsKey((Object)KnownDirective.PRIVATE);
        this.onlyIfCached = knownDirectives.containsKey((Object)KnownDirective.ONLY_IF_CACHED);
        this.mustRevalidate = knownDirectives.containsKey((Object)KnownDirective.MUST_REVALIDATE);
        this.proxyRevalidate = knownDirectives.containsKey((Object)KnownDirective.PROXY_REVALIDATE);
        this.noCacheFields = CacheControl.getFieldSetIfPresent(knownDirectives, KnownDirective.NO_CACHE);
        this.noStoreFields = CacheControl.getFieldSetIfPresent(knownDirectives, KnownDirective.NO_STORE);
        this.privateFields = CacheControl.getFieldSetIfPresent(knownDirectives, KnownDirective.PRIVATE);
    }

    public Map<String, String> directives() {
        return this.directives;
    }

    public Optional<Duration> maxAge() {
        return this.maxAge;
    }

    public Optional<Duration> sMaxAge() {
        return this.sMaxAge;
    }

    public Optional<Duration> minFresh() {
        return this.minFresh;
    }

    public Optional<Duration> maxStale() {
        return this.maxStale;
    }

    public boolean anyMaxStale() {
        return this.maxStale.isEmpty() && this.hasMaxStale;
    }

    public Optional<Duration> staleWhileRevalidate() {
        return this.staleWhileRevalidate;
    }

    public Optional<Duration> staleIfError() {
        return this.staleIfError;
    }

    public boolean noCache() {
        return this.noCache;
    }

    public Set<String> noCacheFields() {
        return this.noCacheFields;
    }

    public boolean noStore() {
        return this.noStore;
    }

    public Set<String> noStoreFields() {
        return this.noStoreFields;
    }

    public boolean noTransform() {
        return this.noTransform;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public Set<String> privateFields() {
        return this.privateFields;
    }

    public boolean onlyIfCached() {
        return this.onlyIfCached;
    }

    public boolean mustRevalidate() {
        return this.mustRevalidate;
    }

    public boolean proxyRevalidate() {
        return this.proxyRevalidate;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof CacheControl && this.directives.equals(((CacheControl)obj).directives);
    }

    public int hashCode() {
        return 31 * this.directives.hashCode();
    }

    public String toString() {
        return this.directives.entrySet().stream().map(entry -> ((String)entry.getValue()).isEmpty() ? (String)entry.getKey() : (String)entry.getKey() + "=" + Utils.escapeAndQuoteValueIfNeeded((String)entry.getValue())).collect(Collectors.joining(", "));
    }

    public static CacheControl parse(String value) {
        Objects.requireNonNull(value);
        try {
            LinkedHashMap<String, String> directives = new LinkedHashMap<String, String>();
            CacheControl.parseDirectives(value, directives);
            return new CacheControl(directives, CacheControl.parseKnownDirectives(directives));
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new IllegalArgumentException(String.format("couldn't parse: '%s'", value), e);
        }
    }

    public static CacheControl parse(List<String> values2) {
        Objects.requireNonNull(values2);
        if (values2.isEmpty()) {
            return CacheControl.empty();
        }
        try {
            LinkedHashMap<String, String> directives = new LinkedHashMap<String, String>();
            values2.forEach(value -> CacheControl.parseDirectives(value, directives));
            return new CacheControl(directives, CacheControl.parseKnownDirectives(directives));
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new IllegalArgumentException(String.format("couldn't parse: '%s'", String.join((CharSequence)", ", values2)), e);
        }
    }

    public static CacheControl parse(HttpHeaders headers) {
        return CacheControl.parse(headers.allValues("Cache-Control").stream().filter(Predicate.not(String::isBlank)).collect(Collectors.toUnmodifiableList()));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static CacheControl empty() {
        return EMPTY;
    }

    private static Optional<Duration> getDurationIfPresent(Map<KnownDirective, ?> directives, KnownDirective directive) {
        return Optional.ofNullable((Duration)directives.get((Object)directive));
    }

    private static Set<String> getFieldSetIfPresent(Map<KnownDirective, ?> directives, KnownDirective directive) {
        Object value = directives.get((Object)directive);
        return value != null ? (Set)value : Set.of();
    }

    private static Set<String> parseFieldNames(String value) {
        if (value.isEmpty()) {
            return Set.of();
        }
        HeaderValueTokenizer tokenizer = new HeaderValueTokenizer(value);
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        do {
            fields.add(Utils.normalizeToken(tokenizer.nextToken()));
        } while (tokenizer.consumeDelimiter(','));
        return Collections.unmodifiableSet(fields);
    }

    private static void parseDirectives(String value, Map<String, String> directives) {
        HeaderValueTokenizer tokenizer = new HeaderValueTokenizer(value);
        do {
            String name = Utils.normalizeToken(tokenizer.nextToken());
            String argumentValue = "";
            if (tokenizer.consumeCharIfPresent('=')) {
                argumentValue = tokenizer.nextTokenOrQuotedString();
            }
            directives.put(name, argumentValue);
        } while (tokenizer.consumeDelimiter(','));
    }

    private static Map<KnownDirective, ?> parseKnownDirectives(Map<String, String> directives) {
        EnumMap<KnownDirective, Object> knownDirectives = new EnumMap<KnownDirective, Object>(KnownDirective.class);
        for (Map.Entry<String, String> entry : directives.entrySet()) {
            KnownDirective directive = KnownDirective.get(entry.getKey());
            if (directive == null) continue;
            String argumentValue = entry.getValue();
            Validate.requireArgument(!directive.requiresArgument || !argumentValue.isEmpty(), "directive %s requires an argument", directive.token);
            knownDirectives.put(directive, CacheControl.convertArgument(directive, argumentValue));
        }
        return Collections.unmodifiableMap(knownDirectives);
    }

    private static @Nullable Object convertArgument(KnownDirective directive, String argumentValue) {
        switch (directive) {
            case MAX_STALE: {
                if (argumentValue.isEmpty()) {
                    return null;
                }
            }
            case MAX_AGE: 
            case MIN_FRESH: 
            case S_MAXAGE: 
            case STALE_WHILE_REVALIDATE: 
            case STALE_IF_ERROR: {
                Duration duration = Duration.ofSeconds(Long.parseLong(argumentValue));
                Utils.requireNonNegativeDuration(duration);
                return duration;
            }
            case NO_CACHE: 
            case NO_STORE: 
            case PRIVATE: {
                return CacheControl.parseFieldNames(argumentValue);
            }
        }
        return null;
    }

    static enum KnownDirective {
        MAX_AGE("max-age", true),
        MIN_FRESH("min-fresh", true),
        S_MAXAGE("s-maxage", true),
        MAX_STALE("max-stale", false),
        STALE_WHILE_REVALIDATE("stale-while-revalidate", true),
        STALE_IF_ERROR("stale-if-error", true),
        NO_CACHE("no-cache", false),
        NO_STORE("no-store", false),
        NO_TRANSFORM("no-transform", false),
        PUBLIC("public", false),
        PRIVATE("private", false),
        ONLY_IF_CACHED("only-if-cached", false),
        MUST_REVALIDATE("must-revalidate", false),
        PROXY_REVALIDATE("proxy-revalidate", false);

        private static final KnownDirective[] DIRECTIVES;
        final String token;
        final boolean requiresArgument;

        private KnownDirective(String token, boolean requiresArgument) {
            this.token = token;
            this.requiresArgument = requiresArgument;
        }

        static @Nullable KnownDirective get(String name) {
            for (KnownDirective directive : DIRECTIVES) {
                if (!directive.token.equalsIgnoreCase(name)) continue;
                return directive;
            }
            return null;
        }

        static {
            DIRECTIVES = KnownDirective.values();
        }
    }

    public static final class Builder {
        private final Map<String, String> directives = new LinkedHashMap<String, String>();
        private final Map<KnownDirective, Object> knownDirectives = new EnumMap<KnownDirective, Object>(KnownDirective.class);

        Builder() {
        }

        public Builder directive(String directive) {
            return this.directive(directive, "");
        }

        public Builder directive(String directive, String argument) {
            Utils.validateToken(directive);
            Utils.validateHeaderValue(argument);
            this.directives.put(Utils.normalizeToken(directive), argument);
            KnownDirective known = KnownDirective.get(directive);
            if (known != null) {
                this.knownDirectives.put(known, CacheControl.convertArgument(known, argument));
            }
            return this;
        }

        public Builder maxAge(Duration maxAge) {
            return this.putDuration(KnownDirective.MAX_AGE, maxAge);
        }

        public Builder minFresh(Duration minFresh) {
            return this.putDuration(KnownDirective.MIN_FRESH, minFresh);
        }

        public Builder maxStale(Duration maxStale) {
            return this.putDuration(KnownDirective.MAX_STALE, maxStale);
        }

        public Builder anyMaxStale() {
            return this.put(KnownDirective.MAX_STALE);
        }

        public Builder staleIfError(Duration staleIfError) {
            return this.putDuration(KnownDirective.STALE_IF_ERROR, staleIfError);
        }

        public Builder noCache() {
            return this.put(KnownDirective.NO_CACHE);
        }

        public Builder noStore() {
            return this.put(KnownDirective.NO_STORE);
        }

        public Builder noTransform() {
            return this.put(KnownDirective.NO_TRANSFORM);
        }

        public Builder onlyIfCached() {
            return this.put(KnownDirective.ONLY_IF_CACHED);
        }

        private Builder putDuration(KnownDirective directive, Duration duration) {
            Objects.requireNonNull(duration);
            Duration truncated = duration.truncatedTo(ChronoUnit.SECONDS);
            Utils.requireNonNegativeDuration(truncated);
            this.knownDirectives.put(directive, truncated);
            this.directives.put(directive.token, Long.toString(truncated.toSeconds()));
            return this;
        }

        private Builder put(KnownDirective directive) {
            this.knownDirectives.put(directive, null);
            this.directives.put(directive.token, "");
            return this;
        }

        public CacheControl build() {
            return new CacheControl(new LinkedHashMap<String, String>(this.directives), this.knownDirectives);
        }
    }
}

