/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.toml;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.core.io.ContentReference;
import com.fasterxml.jackson.core.util.RequestPayload;
import com.fasterxml.jackson.dataformat.toml.Lexer;
import com.fasterxml.jackson.dataformat.toml.TomlToken;

public class TomlStreamReadException
extends StreamReadException {
    private static final long serialVersionUID = 1L;

    TomlStreamReadException(JsonParser p, String msg, JsonLocation loc) {
        super(p, msg, loc);
    }

    TomlStreamReadException(JsonParser p, String msg, JsonLocation loc, Throwable rootCause) {
        super(p, msg, loc, rootCause);
    }

    @Override
    public TomlStreamReadException withParser(JsonParser p) {
        this._processor = p;
        return this;
    }

    @Override
    public TomlStreamReadException withRequestPayload(RequestPayload p) {
        this._requestPayload = p;
        return this;
    }

    static class ErrorContext {
        final ContentReference contentReference;
        final JsonParser parser;

        ErrorContext(ContentReference contentReference, JsonParser parser) {
            this.contentReference = contentReference;
            this.parser = parser;
        }

        ErrorBuilder atPosition(Lexer lexer) {
            return new ErrorBuilder(lexer);
        }

        class ErrorBuilder {
            private final JsonLocation location;

            ErrorBuilder(Lexer lexer) {
                this.location = new JsonLocation(ErrorContext.this.contentReference, -1L, lexer.getCharPos(), lexer.getLine() + 1, lexer.getColumn() + 1);
            }

            TomlStreamReadException unexpectedToken(TomlToken actual, String expected) {
                return new TomlStreamReadException(ErrorContext.this.parser, "Unexpected token: Got " + (Object)((Object)actual) + ", expected " + expected, this.location);
            }

            TomlStreamReadException generic(String message) {
                return new TomlStreamReadException(ErrorContext.this.parser, message, this.location);
            }

            TomlStreamReadException outOfBounds(NumberFormatException cause) {
                return new TomlStreamReadException(ErrorContext.this.parser, "Number out of bounds", this.location, cause);
            }

            TomlStreamReadException invalidNumber(NumberFormatException cause, String value) {
                return new TomlStreamReadException(ErrorContext.this.parser, "Invalid number representation ('" + value + "'), problem: " + cause.getMessage(), this.location, cause);
            }
        }
    }
}

