/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.toml;

import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.toml.Lexer;
import com.fasterxml.jackson.dataformat.toml.TomlReadFeature;
import com.fasterxml.jackson.dataformat.toml.TomlStreamReadException;
import com.fasterxml.jackson.dataformat.toml.TomlToken;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.chrono.ChronoLocalDate;

class Parser {
    private static final JsonNodeFactory factory = new JsonNodeFactoryImpl();
    private final TomlStreamReadException.ErrorContext errorContext;
    private final int options;
    private final Lexer lexer;
    private TomlToken next;

    private Parser(IOContext ioContext, TomlStreamReadException.ErrorContext errorContext, int options, Reader reader) throws IOException {
        this.errorContext = errorContext;
        this.options = options;
        this.lexer = new Lexer(reader, ioContext, errorContext);
        this.lexer.prohibitInternalBufferAllocate = (options & Integer.MIN_VALUE) != 0;
        this.next = this.lexer.yylex();
    }

    public static ObjectNode parse(IOContext ioContext, int options, Reader reader) throws IOException {
        Parser parser = new Parser(ioContext, new TomlStreamReadException.ErrorContext(ioContext.contentReference(), null), options, reader);
        ObjectNode node = parser.parse();
        parser.lexer.releaseBuffers();
        return node;
    }

    private TomlToken peek() throws TomlStreamReadException {
        TomlToken here = this.next;
        if (here == null) {
            throw this.errorContext.atPosition(this.lexer).generic("Premature end of file");
        }
        return here;
    }

    private TomlToken poll(int nextState) throws IOException {
        TomlToken here = this.peek();
        this.lexer.yybegin(nextState);
        this.next = this.lexer.yylex();
        return here;
    }

    private void pollExpected(TomlToken expected, int nextState) throws IOException {
        TomlToken actual = this.poll(nextState);
        if (actual != expected) {
            throw this.errorContext.atPosition(this.lexer).unexpectedToken(actual, expected.toString());
        }
    }

    public ObjectNode parse() throws IOException {
        TomlObjectNode root;
        TomlObjectNode currentTable = root = (TomlObjectNode)factory.objectNode();
        while (this.next != null) {
            FieldRef fieldRef;
            TomlToken token = this.peek();
            if (token == TomlToken.UNQUOTED_KEY || token == TomlToken.STRING) {
                this.parseKeyVal(currentTable, 8);
                continue;
            }
            if (token == TomlToken.STD_TABLE_OPEN) {
                this.pollExpected(TomlToken.STD_TABLE_OPEN, 4);
                fieldRef = this.parseAndEnterKey(root, true);
                currentTable = this.getOrCreateObject(fieldRef.object, fieldRef.key);
                if (currentTable.defined) {
                    throw this.errorContext.atPosition(this.lexer).generic("Table redefined");
                }
                currentTable.defined = true;
                this.pollExpected(TomlToken.STD_TABLE_CLOSE, 8);
                continue;
            }
            if (token == TomlToken.ARRAY_TABLE_OPEN) {
                this.pollExpected(TomlToken.ARRAY_TABLE_OPEN, 4);
                fieldRef = this.parseAndEnterKey(root, true);
                TomlArrayNode array = this.getOrCreateArray(fieldRef.object, fieldRef.key);
                if (array.closed) {
                    throw this.errorContext.atPosition(this.lexer).generic("Array already finished");
                }
                currentTable = (TomlObjectNode)array.addObject();
                this.pollExpected(TomlToken.ARRAY_TABLE_CLOSE, 8);
                continue;
            }
            throw this.errorContext.atPosition(this.lexer).unexpectedToken(token, "key or table");
        }
        assert (this.lexer.yyatEOF());
        int eofState = this.lexer.yystate();
        if (eofState != 2 && eofState != 8) {
            throw this.errorContext.atPosition(this.lexer).generic("EOF in wrong state");
        }
        return root;
    }

    private FieldRef parseAndEnterKey(TomlObjectNode outer, boolean forTable) throws IOException {
        JsonNode existing;
        TomlObjectNode node = outer;
        while (true) {
            String part;
            TomlToken partToken;
            if (node.closed) {
                throw this.errorContext.atPosition(this.lexer).generic("Object already closed");
            }
            if (!forTable) {
                node.defined = true;
            }
            if ((partToken = this.peek()) == TomlToken.STRING) {
                part = this.lexer.textBuffer.contentsAsString();
            } else if (partToken == TomlToken.UNQUOTED_KEY) {
                part = this.lexer.yytext();
            } else {
                throw this.errorContext.atPosition(this.lexer).unexpectedToken(partToken, "quoted or unquoted key");
            }
            this.pollExpected(partToken, 4);
            if (this.peek() != TomlToken.DOT_SEP) {
                return new FieldRef(node, part);
            }
            this.pollExpected(TomlToken.DOT_SEP, 4);
            existing = node.get(part);
            if (existing == null) {
                node = (TomlObjectNode)node.putObject(part);
                continue;
            }
            if (existing.isObject()) {
                node = (TomlObjectNode)existing;
                continue;
            }
            if (!existing.isArray()) break;
            TomlArrayNode array = (TomlArrayNode)existing;
            if (array.closed) {
                throw this.errorContext.atPosition(this.lexer).generic("Array already closed");
            }
            node = (TomlObjectNode)array.get(array.size() - 1);
        }
        throw this.errorContext.atPosition(this.lexer).generic("Path into existing non-object value of type " + (Object)((Object)existing.getNodeType()));
    }

    private JsonNode parseValue(int nextState) throws IOException {
        TomlToken firstToken = this.peek();
        switch (firstToken) {
            case STRING: {
                String text = this.lexer.textBuffer.contentsAsString();
                this.pollExpected(TomlToken.STRING, nextState);
                return factory.textNode(text);
            }
            case TRUE: {
                this.pollExpected(TomlToken.TRUE, nextState);
                return factory.booleanNode(true);
            }
            case FALSE: {
                this.pollExpected(TomlToken.FALSE, nextState);
                return factory.booleanNode(false);
            }
            case OFFSET_DATE_TIME: 
            case LOCAL_DATE_TIME: 
            case LOCAL_DATE: 
            case LOCAL_TIME: {
                return this.parseDateTime(nextState);
            }
            case FLOAT: {
                return this.parseFloat(nextState);
            }
            case INTEGER: {
                return this.parseInt(nextState);
            }
            case ARRAY_OPEN: {
                return this.parseArray(nextState);
            }
            case INLINE_TABLE_OPEN: {
                return this.parseInlineTable(nextState);
            }
        }
        throw this.errorContext.atPosition(this.lexer).unexpectedToken(firstToken, "value");
    }

    private JsonNode parseDateTime(int nextState) throws IOException {
        String text = this.lexer.yytext();
        TomlToken token = this.poll(nextState);
        if ((token == TomlToken.LOCAL_DATE_TIME || token == TomlToken.OFFSET_DATE_TIME) && text.charAt(10) == ' ') {
            text = text.substring(0, 10) + 'T' + text.substring(11);
        }
        if (TomlReadFeature.PARSE_JAVA_TIME.enabledIn(this.options)) {
            Comparable<ChronoLocalDate> value;
            if (token == TomlToken.LOCAL_DATE) {
                value = LocalDate.parse(text);
            } else if (token == TomlToken.LOCAL_TIME) {
                value = LocalTime.parse(text);
            } else if (token == TomlToken.LOCAL_DATE_TIME) {
                value = LocalDateTime.parse(text);
            } else if (token == TomlToken.OFFSET_DATE_TIME) {
                value = OffsetDateTime.parse(text);
            } else {
                VersionUtil.throwInternal();
                throw new AssertionError();
            }
            return factory.pojoNode(value);
        }
        return factory.textNode(text);
    }

    private JsonNode parseInt(int nextState) throws IOException {
        boolean negative;
        char baseChar;
        char[] buffer = this.lexer.getTextBuffer();
        int start = this.lexer.getTextBufferStart();
        int length = this.lexer.getTextBufferEnd() - this.lexer.getTextBufferStart();
        for (int i = 0; i < length; ++i) {
            if (buffer[start + i] != '_') continue;
            buffer = new String(buffer, start, length).replace("_", "").toCharArray();
            start = 0;
            length = buffer.length;
            break;
        }
        this.pollExpected(TomlToken.INTEGER, nextState);
        if (length > 2 && ((baseChar = buffer[start + 1]) == 'x' || baseChar == 'o' || baseChar == 'b')) {
            String text = new String(buffer, start += 2, length -= 2);
            try {
                if (baseChar == 'x') {
                    if (length <= 7) {
                        return factory.numberNode(Integer.parseInt(text, 16));
                    }
                    if (length <= 15) {
                        return factory.numberNode(Long.parseLong(text, 16));
                    }
                    return factory.numberNode(new BigInteger(text, 16));
                }
                if (baseChar == 'o') {
                    if (length <= 10) {
                        return factory.numberNode(Integer.parseInt(text, 8));
                    }
                    if (text.length() <= 21) {
                        return factory.numberNode(Long.parseLong(text, 8));
                    }
                    return factory.numberNode(new BigInteger(text, 8));
                }
                assert (baseChar == 'b');
                if (length <= 31) {
                    return factory.numberNode(Integer.parseUnsignedInt(text, 2));
                }
                if (length <= 63) {
                    return factory.numberNode(Long.parseUnsignedLong(text, 2));
                }
                return factory.numberNode(new BigInteger(text, 2));
            }
            catch (NumberFormatException e) {
                throw this.errorContext.atPosition(this.lexer).invalidNumber(e, text);
            }
        }
        if (buffer[start] == '-') {
            ++start;
            --length;
            negative = true;
        } else if (buffer[start] == '+') {
            ++start;
            --length;
            negative = false;
        } else {
            negative = false;
        }
        if (length <= 9) {
            int v = NumberInput.parseInt(buffer, start, length);
            if (negative) {
                v = -v;
            }
            return factory.numberNode(v);
        }
        if (length <= 18 || NumberInput.inLongRange(buffer, start, length, negative)) {
            long v = NumberInput.parseLong(buffer, start, length);
            if (negative) {
                v = -v;
            }
            if ((long)((int)v) == v) {
                return factory.numberNode((int)v);
            }
            return factory.numberNode(v);
        }
        String text = new String(buffer, start, length);
        try {
            return factory.numberNode(NumberInput.parseBigInteger(text));
        }
        catch (NumberFormatException e) {
            throw this.errorContext.atPosition(this.lexer).invalidNumber(e, text);
        }
    }

    private JsonNode parseFloat(int nextState) throws IOException {
        String text = this.lexer.yytext().replace("_", "");
        this.pollExpected(TomlToken.FLOAT, nextState);
        if (text.endsWith("nan")) {
            return factory.numberNode(Double.NaN);
        }
        if (text.endsWith("inf")) {
            return factory.numberNode(text.startsWith("-") ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
        }
        try {
            BigDecimal dec = NumberInput.parseBigDecimal(text);
            return factory.numberNode(dec);
        }
        catch (NumberFormatException e) {
            throw this.errorContext.atPosition(this.lexer).invalidNumber(e, text);
        }
    }

    private ObjectNode parseInlineTable(int nextState) throws IOException {
        TomlObjectNode node;
        block3: {
            TomlToken sepToken;
            this.pollExpected(TomlToken.INLINE_TABLE_OPEN, 4);
            node = (TomlObjectNode)factory.objectNode();
            while (true) {
                TomlToken token;
                if ((token = this.peek()) == TomlToken.INLINE_TABLE_CLOSE) {
                    if (!node.isEmpty()) {
                        throw this.errorContext.atPosition(this.lexer).generic("Trailing comma not permitted for inline tables");
                    }
                    break block3;
                }
                this.parseKeyVal(node, 12);
                sepToken = this.peek();
                if (sepToken == TomlToken.INLINE_TABLE_CLOSE) break block3;
                if (sepToken != TomlToken.COMMA) break;
                this.pollExpected(TomlToken.COMMA, 4);
            }
            throw this.errorContext.atPosition(this.lexer).unexpectedToken(sepToken, "comma or table end");
        }
        this.pollExpected(TomlToken.INLINE_TABLE_CLOSE, nextState);
        node.closed = true;
        node.defined = true;
        return node;
    }

    private ArrayNode parseArray(int nextState) throws IOException {
        TomlToken token;
        this.pollExpected(TomlToken.ARRAY_OPEN, 6);
        TomlArrayNode node = (TomlArrayNode)factory.arrayNode();
        while ((token = this.peek()) != TomlToken.ARRAY_CLOSE) {
            JsonNode value = this.parseValue(10);
            node.add(value);
            TomlToken sepToken = this.peek();
            if (sepToken == TomlToken.ARRAY_CLOSE) break;
            if (sepToken == TomlToken.COMMA) {
                this.pollExpected(TomlToken.COMMA, 6);
                continue;
            }
            throw this.errorContext.atPosition(this.lexer).unexpectedToken(sepToken, "comma or array end");
        }
        this.pollExpected(TomlToken.ARRAY_CLOSE, nextState);
        node.closed = true;
        return node;
    }

    private void parseKeyVal(TomlObjectNode target, int nextState) throws IOException {
        FieldRef fieldRef = this.parseAndEnterKey(target, false);
        this.pollExpected(TomlToken.KEY_VAL_SEP, 6);
        JsonNode value = this.parseValue(nextState);
        if (fieldRef.object.has(fieldRef.key)) {
            throw this.errorContext.atPosition(this.lexer).generic("Duplicate key");
        }
        fieldRef.object.set(fieldRef.key, value);
    }

    private TomlObjectNode getOrCreateObject(ObjectNode node, String field) throws TomlStreamReadException {
        JsonNode existing = node.get(field);
        if (existing == null) {
            return (TomlObjectNode)node.putObject(field);
        }
        if (existing.isObject()) {
            return (TomlObjectNode)existing;
        }
        throw this.errorContext.atPosition(this.lexer).generic("Path into existing non-object value of type " + (Object)((Object)existing.getNodeType()));
    }

    private TomlArrayNode getOrCreateArray(ObjectNode node, String field) throws TomlStreamReadException {
        JsonNode existing = node.get(field);
        if (existing == null) {
            return (TomlArrayNode)node.putArray(field);
        }
        if (existing.isArray()) {
            return (TomlArrayNode)existing;
        }
        throw this.errorContext.atPosition(this.lexer).generic("Path into existing non-array value of type " + (Object)((Object)node.getNodeType()));
    }

    private static class JsonNodeFactoryImpl
    extends JsonNodeFactory {
        public JsonNodeFactoryImpl() {
            super(true);
        }

        @Override
        public ArrayNode arrayNode() {
            return new TomlArrayNode(this);
        }

        @Override
        public ArrayNode arrayNode(int capacity) {
            return new TomlArrayNode((JsonNodeFactory)this, capacity);
        }

        @Override
        public ObjectNode objectNode() {
            return new TomlObjectNode(this);
        }
    }

    private static class TomlArrayNode
    extends ArrayNode {
        boolean closed = false;

        TomlArrayNode(JsonNodeFactory nf) {
            super(nf);
        }

        TomlArrayNode(JsonNodeFactory nf, int capacity) {
            super(nf, capacity);
        }
    }

    private static class TomlObjectNode
    extends ObjectNode {
        boolean closed = false;
        boolean defined = false;

        TomlObjectNode(JsonNodeFactory nc) {
            super(nc);
        }
    }

    private static class FieldRef {
        final TomlObjectNode object;
        final String key;

        FieldRef(TomlObjectNode object, String key) {
            this.object = object;
            this.key = key;
        }
    }
}

