/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.util.io;

import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraftforge.srg2source.util.io.InputSupplier;

public class ZipInputSupplier
implements InputSupplier {
    private final HashMap<String, byte[]> data = new HashMap();
    private String root;

    public void readZip(File zip) throws IOException {
        ZipEntry entry;
        this.root = zip.getCanonicalPath();
        ZipInputStream zin = new ZipInputStream(new FileInputStream(zip));
        while ((entry = zin.getNextEntry()) != null) {
            this.data.put(entry.getName(), ByteStreams.toByteArray((InputStream)zin));
        }
        zin.close();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public InputStream getInput(String relPath) {
        try {
            return ByteSource.wrap((byte[])this.data.get(relPath)).openStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public List<String> gatherAll(String endFilter) {
        LinkedList<String> out = new LinkedList<String>();
        for (String key : this.data.keySet()) {
            if (!key.endsWith(endFilter)) continue;
            out.add(key);
        }
        return out;
    }

    @Override
    public String getRoot(String resource) {
        return this.root;
    }
}

