/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.util;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class Util {
    private static final Pattern SIG_REGEX = Pattern.compile("L([^;]+);");

    public static HashMap<String, List<String>> remapParameterMap(Map<String, List<String>> paramMap, Map<String, String> methodMap, Map<String, String> methodSigMap, Map<String, String> classMap, boolean keepMissing) {
        HashMap<String, List<String>> newParamMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> e : paramMap.entrySet()) {
            String newMethodSig;
            String newFullMethodName;
            String className;
            String[] split;
            if (e.getKey().contains("<init>")) {
                split = e.getKey().split(" ");
                String newClassName = className = Util.splitPackageName(split[0]);
                if (!classMap.containsKey(className)) {
                    if (!keepMissing) {
                        continue;
                    }
                } else {
                    newClassName = classMap.get(className);
                }
                newFullMethodName = newClassName + "/" + Util.splitBaseName(newClassName);
                newMethodSig = Util.remapSig(split[1], classMap);
            } else if (!methodMap.containsKey(e.getKey())) {
                if (!keepMissing) continue;
                split = e.getKey().split(" ");
                className = Util.splitPackageName(split[0]);
                newFullMethodName = className + "/" + Util.splitBaseName(split[0]);
                newMethodSig = Util.remapSig(split[1], classMap);
            } else {
                newFullMethodName = methodMap.get(e.getKey());
                newMethodSig = methodSigMap.get(e.getKey());
            }
            newParamMap.put(newFullMethodName + " " + newMethodSig, e.getValue());
        }
        return newParamMap;
    }

    public static String remapSig(String sig, Map<String, String> classMap) {
        StringBuffer buffer = new StringBuffer(sig.length());
        Matcher matcher = SIG_REGEX.matcher(sig);
        while (matcher.find()) {
            String className = matcher.group(1);
            String repl = "L" + (classMap.containsKey(className) ? classMap.get(className) : className) + ";";
            int idx = repl.lastIndexOf(36);
            if (repl.indexOf(36) != -1) {
                String ending = repl.substring(idx + 1, repl.length() - 1);
                repl = ending.matches("\\d+") ? "Ljava/lang/Object;" : repl.replace("$", "\\$");
            }
            matcher.appendReplacement(buffer, repl);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public static Map<String, String> readDescriptiveParameterNames(File mcpConfDir) {
        return Util.readCSVMap(new File(mcpConfDir, "params.csv"));
    }

    public static Map<String, String> readDescriptiveMethodNames(File mcpConfDir) {
        return Util.readCSVMap(new File(mcpConfDir, "methods.csv"));
    }

    public static Map<String, String> readClassPackageMap(File mcpConfDir) {
        return Util.readCSVMap(new File(mcpConfDir, "methods.csv"));
    }

    public static Map<String, String> readCSVMap(File file) {
        try {
            BufferedReader reader = Files.newReader((File)file, (Charset)Charset.defaultCharset());
            CSVReader csv = new CSVReader((Reader)Files.newReader((File)file, (Charset)Charset.defaultCharset()), ',', '\"', '\\', 1, false);
            HashMap<String, String> map = new HashMap<String, String>();
            for (String[] s : csv.readAll()) {
                map.put(s[0], s[1]);
            }
            ((Reader)reader).close();
            csv.close();
            return map;
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
            return null;
        }
    }

    public static String splitBaseName(String className) {
        if (className == null) {
            return null;
        }
        return className.substring(className.lastIndexOf(47) + 1);
    }

    public static String splitBaseName(String qualName, int num) {
        int c = 46;
        int index = qualName.lastIndexOf(c);
        while (index >= 0 && num > 0) {
            index = qualName.lastIndexOf(c, index - 1);
            --num;
        }
        if (index < 0) {
            return qualName;
        }
        return qualName.substring(index + 1);
    }

    public static String splitPackageName(String className) {
        if (className == null) {
            return null;
        }
        int index = className.lastIndexOf(47);
        if (index == -1) {
            return null;
        }
        return className.substring(0, index);
    }

    public static String internalName2Source(String internalName) {
        if (internalName == null) {
            return null;
        }
        return internalName.replace('/', '.');
    }

    public static int countChar(String str, char c) {
        int index = str.indexOf(c);
        int num = 0;
        while (index >= 0) {
            ++num;
            index = str.indexOf(c, index + 1);
        }
        return num;
    }

    public static String sourceName2Internal(String sourceName) {
        return Util.sourceName2Internal(sourceName, true);
    }

    public static String sourceName2Internal(String sourceName, boolean inner) {
        if (sourceName == null) {
            return null;
        }
        if (inner) {
            return sourceName.replace('.', '/').replace('$', '/');
        }
        return sourceName.replace('.', '/');
    }

    public static String getTopLevelClassForFilename(String filename) {
        return filename.replace("." + Files.getFileExtension((String)filename), "").replace('\\', '/');
    }

    public static String[] gatherFiles(String path, String filter, boolean relative) {
        ArrayList<String> names = new ArrayList<String>();
        for (File f : new File(path).listFiles()) {
            if (f.isDirectory()) {
                if (relative) {
                    names.addAll(Util.gatherFiles(f.getAbsolutePath(), path.length() + 1, filter));
                    continue;
                }
                names.addAll(Arrays.asList(Util.gatherFiles(f.getAbsolutePath(), filter, relative)));
                continue;
            }
            if (!f.getName().endsWith(filter)) continue;
            if (relative) {
                names.add(f.getAbsolutePath().substring(path.length() + 1).replace('\\', '/'));
                continue;
            }
            names.add(f.getAbsolutePath().replace('\\', '/'));
        }
        return names.toArray(new String[names.size()]);
    }

    private static List<String> gatherFiles(String path, int cut, String filter) {
        ArrayList<String> names = new ArrayList<String>();
        for (File f : new File(path).listFiles()) {
            if (f.isDirectory()) {
                names.addAll(Util.gatherFiles(f.getPath(), cut, filter));
                continue;
            }
            if (!f.getName().endsWith(filter)) continue;
            names.add(f.getAbsolutePath().substring(cut).replace('\\', '/'));
        }
        return names;
    }

    public static ASTParser createParser(String javaVersion, String srcRoot, String[] libs) {
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setKind(8);
        parser.setResolveBindings(true);
        parser.setBindingsRecovery(true);
        Hashtable options = JavaCore.getDefaultOptions();
        options.put("org.eclipse.jdt.core.compiler.source", javaVersion);
        parser.setCompilerOptions((Map)options);
        parser.setEnvironment(libs, new String[]{srcRoot}, null, true);
        return parser;
    }

    public static CompilationUnit createUnit(ASTParser parser, String name, String data) throws Exception {
        parser.setUnitName(name);
        parser.setSource(data.toCharArray());
        return (CompilationUnit)parser.createAST(null);
    }
}

