/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.rangeapplier;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraftforge.srg2source.rangeapplier.ExceptorFile;
import net.minecraftforge.srg2source.rangeapplier.LocalVarFile;
import net.minecraftforge.srg2source.rangeapplier.MethodData;
import net.minecraftforge.srg2source.rangeapplier.SrgContainer;
import net.minecraftforge.srg2source.util.Util;

class RenameMap {
    public Map<String, String> maps = new HashMap<String, String>();
    public Map<String, String> imports = new HashMap<String, String>();

    public RenameMap readSrg(SrgContainer srgs) {
        for (Map.Entry e : srgs.classMap.entrySet()) {
            String replacedKey = ((String)e.getKey()).replace('$', '/');
            this.maps.put("class " + replacedKey, ((String)e.getValue()).replace('$', '.').replace('/', '.'));
            this.imports.put("class " + replacedKey, Util.internalName2Source((String)e.getValue()));
            this.maps.put("package " + Util.splitPackageName((String)e.getKey()), Util.internalName2Source(Util.splitPackageName((String)e.getValue())));
        }
        for (Map.Entry e : srgs.fieldMap.entrySet()) {
            this.maps.put("field " + ((String)e.getKey()).replace('$', '/'), Util.splitBaseName((String)e.getValue()).replace('$', '/'));
        }
        for (Map.Entry e : srgs.methodMap.entrySet()) {
            this.maps.put("method " + ((MethodData)e.getKey()).name.replace('$', '/') + " " + ((MethodData)e.getKey()).sig, Util.splitBaseName(((MethodData)e.getValue()).name).replace('$', '.'));
        }
        return this;
    }

    public Map<String, String> getQualified() {
        TreeMap<String, String> out = new TreeMap<String, String>();
        out.putAll(this.maps);
        for (Map.Entry e : out.entrySet()) {
            if (((String)e.getKey()).startsWith("class")) {
                out.put((String)e.getKey(), this.imports.get(((String)e.getKey()).replace('$', '.')));
                continue;
            }
            if (!((String)e.getKey()).startsWith("package")) continue;
            out.put((String)e.getKey(), "");
        }
        return out;
    }

    public RenameMap readParamMap(SrgContainer srg, ExceptorFile exc) {
        BiMap classMap = srg.classMap.inverse();
        BiMap methodMap = srg.methodMap.inverse();
        HashBiMap tmpClass = HashBiMap.create((int)classMap.size());
        for (Map.Entry e : classMap.entrySet()) {
            tmpClass.put((Object)((String)e.getKey()).replace('$', '/'), (Object)((String)e.getValue()).replace('$', '/'));
        }
        HashBiMap tmpMethod = HashBiMap.create((int)methodMap.size());
        for (Map.Entry e : methodMap.entrySet()) {
            tmpMethod.put((Object)new MethodData(((MethodData)e.getKey()).name.replace('$', '/'), ((MethodData)e.getKey()).sig), (Object)new MethodData(((MethodData)e.getValue()).name.replace('$', '/'), ((MethodData)e.getValue()).sig));
        }
        methodMap = tmpMethod;
        for (ExceptorFile.ExcLine line : exc) {
            MethodData paramKey = line.getMethodData();
            if (line.methodName.equals("<init>")) {
                String newClassName = line.className;
                if (!tmpClass.containsKey((Object)line.className)) continue;
                newClassName = (String)tmpClass.get((Object)line.className);
                paramKey = new MethodData(newClassName + "/" + Util.splitBaseName(newClassName), Util.remapSig(line.methodSig, (Map<String, String>)classMap));
            } else if (methodMap.containsKey((Object)paramKey)) {
                paramKey = (MethodData)methodMap.get((Object)paramKey);
            }
            for (int i = 0; i < line.params.size(); ++i) {
                this.maps.put("param " + paramKey + " " + i, line.params.get(i));
            }
        }
        return this;
    }

    public RenameMap readLocalVariableMap(LocalVarFile localVars, SrgContainer srg) throws IOException {
        BiMap classMap = srg.classMap.inverse();
        BiMap methodMap = srg.methodMap.inverse();
        for (LocalVarFile.LocalVar var : localVars) {
            Object key;
            MethodData val;
            String className;
            String mcpClassName = Util.sourceName2Internal(var.mcpClassName);
            if (!classMap.containsKey((Object)mcpClassName)) {
                className = "net.minecraft.server." + Util.splitBaseName(mcpClassName);
                System.out.println("WARNING: readLocalVariableMap: no CB class name for MCP class name " + mcpClassName + ", using " + className);
            } else {
                className = (String)classMap.get((Object)mcpClassName);
            }
            if (var.mcpMethodName.equals("{}")) {
                val = new MethodData("{}", "");
            } else if (var.mcpMethodName.equals(Util.splitBaseName(var.mcpMethodName))) {
                val = new MethodData(className + "/" + Util.splitBaseName(className), Util.remapSig(var.mcpMethodSig, (Map<String, String>)classMap));
            } else {
                key = new MethodData(mcpClassName + "/" + var.mcpMethodName, var.mcpMethodSig);
                if (!methodMap.containsKey(key)) {
                    System.out.println("NOTICE: local variables available for " + key + " but no inverse method map; skipping");
                    continue;
                }
                val = (MethodData)methodMap.get(key);
            }
            key = "localvar " + val + " " + var.variableIndex;
            this.maps.put((String)key, var.expectedOldText);
        }
        return this;
    }
}

