/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.ast;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraftforge.srg2source.ast.SymbolRangeEmitter;
import net.minecraftforge.srg2source.ast.SymbolReferenceWalker;
import net.minecraftforge.srg2source.util.Util;
import net.minecraftforge.srg2source.util.io.ConfLogger;
import net.minecraftforge.srg2source.util.io.FolderSupplier;
import net.minecraftforge.srg2source.util.io.InputSupplier;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class RangeExtractor
extends ConfLogger<RangeExtractor> {
    public static final String JAVA_1_6 = "1.6";
    public static final String JAVA_1_7 = "1.7";
    public static final String JAVA_1_8 = "1.8";
    private PrintWriter outFile;
    private final Set<File> libs = new HashSet<File>();
    private InputSupplier src;
    private ASTParser parser = null;
    private String java_version = "1.6";
    private String src_root_cache = "";

    public RangeExtractor() {
        this(JAVA_1_6);
    }

    public RangeExtractor(String javaVersion) {
        this.java_version = javaVersion;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.out.println("Usage: RangeExtract [SourceDir] [LibDir] [OutFile]");
            System.exit(1);
        }
        File src = new File(args[0]);
        RangeExtractor extractor = new RangeExtractor();
        extractor.setSrcRoot(new File(args[0]));
        if (args[1].equals("none") || args[1].isEmpty()) {
            extractor.addLibs(src);
        } else {
            extractor.addLibs(args[1]);
        }
        boolean worked = extractor.generateRangeMap(new File(args[2]));
        System.out.println("Srg2source batch mode finished - now exiting " + (worked ? 0 : 1));
        System.exit(worked ? 0 : 1);
    }

    public boolean generateRangeMap(File out) {
        try {
            if (!out.exists()) {
                Files.createParentDirs((File)out);
                out.createNewFile();
            }
            this.outFile = new PrintWriter(new BufferedWriter(new FileWriter(out)));
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
            return false;
        }
        return this.generateRangeMap(this.outFile);
    }

    public boolean generateRangeMap(PrintWriter writer) {
        this.outFile = writer;
        this.log("Symbol range map extraction starting");
        List<String> tmp = this.src.gatherAll(".java");
        Collections.sort(tmp);
        String[] files = tmp.toArray(new String[tmp.size()]);
        this.log("Processing " + files.length + " files");
        if (files.length == 0) {
            this.cleanup();
            return true;
        }
        try {
            for (String path : files) {
                InputStream stream = this.src.getInput(path);
                SymbolRangeEmitter emitter = new SymbolRangeEmitter(path, this.outFile);
                byte[] bytes = ByteStreams.toByteArray((InputStream)stream);
                String data = new String(bytes, Charsets.UTF_8).replaceAll("\r", "");
                String md5 = Hashing.md5().hashString((CharSequence)data, Charsets.UTF_8).toString();
                this.log("startProcessing \"" + path + "\" md5: " + md5);
                CompilationUnit cu = Util.createUnit(this.getParser(this.src.getRoot(path)), path, data);
                int[] newCode = this.getNewCodeRanges(cu, data);
                SymbolReferenceWalker walker = new SymbolReferenceWalker(emitter, null, newCode);
                walker.walk((ASTNode)cu);
                this.log("endProcessing \"" + path + "\"");
                this.log("");
                stream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace(this.errorLogger);
        }
        this.cleanup();
        return true;
    }

    private void cleanup() {
        this.outFile.close();
        this.outFile = null;
    }

    @Override
    protected void log(String s) {
        this.outFile.println(s);
        this.outLogger.println(s);
    }

    private int[] getNewCodeRanges(CompilationUnit cu, String data) {
        boolean inside = false;
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (Comment cmt : cu.getCommentList()) {
            String[] lines;
            String comment = data.substring(cmt.getStartPosition(), cmt.getStartPosition() + cmt.getLength());
            if (cmt.isLineComment()) {
                String[] words = comment.split(" ");
                if (words.length < 3) continue;
                int idx = words[0].startsWith("//") && words[0].length() != 2 ? 1 : 2;
                String command = words[idx];
                if (command.equalsIgnoreCase("start")) {
                    ret.add(cmt.getStartPosition());
                    if (inside) {
                        this.log("Unmatched newcode start: " + cmt.getStartPosition() + ": " + comment);
                    }
                    inside = true;
                    continue;
                }
                if (!command.equalsIgnoreCase("end")) continue;
                ret.add(cmt.getStartPosition());
                if (!inside) {
                    this.log("Unmatched newcode end: " + cmt.getStartPosition() + ": " + comment);
                }
                inside = false;
                continue;
            }
            if (!cmt.isBlockComment()) continue;
            for (String line : lines = comment.split("\r?\n")) {
                String[] words = line.trim().split(" ");
                if (words.length < 3) continue;
                String command = words[2];
                if (command.equalsIgnoreCase("start")) {
                    ret.add(cmt.getStartPosition());
                    if (inside) {
                        this.log("Unmatched newcode start: " + cmt.getStartPosition() + ": " + comment);
                    }
                    inside = true;
                    continue;
                }
                if (!command.equalsIgnoreCase("end")) continue;
                ret.add(cmt.getStartPosition());
                if (!inside) {
                    this.log("Unmatched newcode end: " + cmt.getStartPosition() + ": " + comment);
                }
                inside = false;
            }
        }
        int[] r = new int[ret.size()];
        for (int x = 0; x < ret.size(); ++x) {
            r[x] = (Integer)ret.get(x);
        }
        return r;
    }

    public InputSupplier getSrc() {
        return this.src;
    }

    public RangeExtractor setSrcRoot(File srcRoot) {
        if (srcRoot.isDirectory()) {
            this.src = new FolderSupplier(srcRoot);
        }
        return this;
    }

    public RangeExtractor setSrc(InputSupplier supplier) {
        this.src = supplier;
        return this;
    }

    public RangeExtractor addLibs(File lib) {
        if (lib.isDirectory()) {
            for (File f : lib.listFiles()) {
                this.addLibs(f);
            }
        } else if (lib.getPath().endsWith("jar")) {
            this.libs.add(lib);
        }
        return this;
    }

    public RangeExtractor addLibs(String path) {
        if (path.contains(File.pathSeparator)) {
            for (String f : Splitter.on((char)File.pathSeparatorChar).splitToList((CharSequence)path)) {
                this.addLibs(new File(f));
            }
        } else {
            this.addLibs(new File(path));
        }
        return this;
    }

    public Set<File> getLibs() {
        return this.libs;
    }

    private ASTParser getParser(String root) {
        if (this.parser != null && this.src_root_cache.equals(root)) {
            return this.parser;
        }
        String[] libArray = new String[this.libs.size()];
        int i = 0;
        for (File f : this.libs) {
            libArray[i++] = f.getAbsolutePath();
        }
        this.src_root_cache = root;
        this.parser = Util.createParser(this.java_version, this.src_root_cache, libArray);
        return this.parser;
    }
}

