/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.ast;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.minecraftforge.srg2source.ast.ClassTree;
import net.minecraftforge.srg2source.ast.FixTypes;
import net.minecraftforge.srg2source.ast.MethodSignatureHelper;
import net.minecraftforge.srg2source.ast.SrgFile;
import net.minecraftforge.srg2source.util.Util;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class CodeFixer {
    private static String SRC = null;
    private static String[] libs = null;
    private static ClassTree TREE = new ClassTree(false);
    private static SrgFile SRG;
    private static boolean FATAL;
    private static Properties FIXES;
    private static boolean DRYRUN;
    private static ASTParser parser;
    private static Method addURL;

    private static boolean argExists(String arg, String[] args) {
        String needle = "--" + arg;
        for (int x = 0; x < args.length; ++x) {
            if (!needle.equals(args[x])) continue;
            return true;
        }
        return false;
    }

    private static String argValue(String arg, String[] args) {
        String needle = "--" + arg;
        for (int x = 0; x < args.length - 1; ++x) {
            if (!needle.equals(args[x])) continue;
            return args[x + 1];
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        File f;
        SRC = new File(args[0]).getAbsolutePath();
        SRG = new SrgFile(new File(args[2])).read();
        libs = !args[1].equalsIgnoreCase("none") && args[1].length() != 0 ? (args[1].contains(File.pathSeparator) ? args[1].split(File.pathSeparator) : Util.gatherFiles(new File(args[1]).getAbsolutePath(), ".jar", false)) : new String[0];
        addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        addURL.setAccessible(true);
        for (String s : libs) {
            addURL.invoke((Object)CodeFixer.class.getClassLoader(), new File(s).toURI().toURL());
        }
        FATAL = !CodeFixer.argExists("non-fatal", args);
        DRYRUN = CodeFixer.argExists("dry-run", args);
        String data_file = CodeFixer.argValue("fix-config", args);
        if (data_file != null && (f = new File(data_file)).exists()) {
            FIXES.load(new FileInputStream(f));
        }
        parser = Util.createParser("1.6", SRC, libs);
        String[] files = Util.gatherFiles(SRC, ".java", false);
        try {
            ArrayList<SourceKey> srcClasses = CodeFixer.createTree(files);
            CodeFixer.log("Gathering Fixes:");
            HashMap<String, ArrayList<FixTypes>> classFixes = CodeFixer.findFixes(srcClasses);
            CodeFixer.log("Applying Fixes:");
            for (String key : classFixes.keySet()) {
                ArrayList<FixTypes> fixes = classFixes.get(key);
                Collections.sort(fixes);
                CodeFixer.log("  " + key);
                SourceKey data = null;
                for (SourceKey s : srcClasses) {
                    if (!s.name.equals(key)) continue;
                    data = s;
                    break;
                }
                if (data == null) {
                    CodeFixer.log("    Could not find sourcekey for fixes: " + key);
                    System.exit(1);
                }
                int offset = 0;
                String src = data.data;
                for (FixTypes fix : fixes) {
                    CodeFixer.log("    Fix: " + fix + " " + offset);
                    String pre = src.substring(0, fix.getStart() + offset);
                    String post = src.substring(fix.getStart() + fix.getLength() + offset);
                    src = pre + fix.newText + post;
                    offset += fix.newText.length() - fix.getLength();
                }
                String outFile = SRC + "/" + key + ".java";
                try {
                    if (!DRYRUN) {
                        FileWriter out = new FileWriter(outFile);
                        out.write(src);
                        out.close();
                    }
                }
                catch (IOException e) {
                    System.out.println("Exception " + e.toString());
                }
                System.out.println("");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static ArrayList<SourceKey> createTree(String[] files) {
        ArrayList<SourceKey> ret = new ArrayList<SourceKey>();
        try {
            CodeFixer.log("Processing Source Tree:");
            for (String file : files) {
                String data = Files.toString((File)new File(file), (Charset)Charset.forName("UTF-8")).replaceAll("\r", "");
                String name = file.replace('\\', '/').substring(SRC.length() + 1);
                CodeFixer.log("    " + name);
                CompilationUnit cu = Util.createUnit(parser, name, data);
                ArrayList<TypeDeclaration> classes = new ArrayList<TypeDeclaration>();
                List types = cu.types();
                for (AbstractTypeDeclaration type : types) {
                    TREE.processClass(type);
                    if (!(type instanceof TypeDeclaration)) continue;
                    classes.add((TypeDeclaration)type);
                }
                ret.add(new SourceKey(name.substring(0, name.length() - 5), cu, data.trim(), classes));
            }
            for (String lib : libs) {
                TREE.processLibrary(new File(lib));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    private static HashMap<String, ArrayList<FixTypes>> findFixes(ArrayList<SourceKey> files) throws ClassNotFoundException {
        HashMap<String, ArrayList<FixTypes>> ret = new HashMap<String, ArrayList<FixTypes>>();
        HashSet<String> added = new HashSet<String>();
        for (SourceKey src : files) {
            CodeFixer.log("    " + src.name);
            ArrayList<IProblem> errors = new ArrayList<IProblem>();
            HashMap<String, ArrayList<IProblem>> duplicates = new HashMap<String, ArrayList<IProblem>>();
            block1: for (IProblem p : src.cu.getProblems()) {
                String name;
                int id;
                if (!p.isError() || (id = p.getID() & 0xFFFFFF) == 169) continue;
                if (id == 355) {
                    name = p.getArguments()[0];
                    if (!duplicates.containsKey(name)) {
                        duplicates.put(name, new ArrayList());
                    }
                    duplicates.get(name).add(p);
                    continue;
                }
                if (id == 101) {
                    name = p.getArguments()[1];
                    String args = p.getArguments()[2];
                    String clsName = p.getArguments()[0];
                    int start = p.getSourceStart();
                    int length = p.getSourceEnd() - p.getSourceStart() + 1;
                    String newName = name + "_CodeFix_Public";
                    if (name.endsWith("_")) {
                        newName = name + "CodeFix_Public";
                    }
                    if (!CodeFixer.gatherMethod(ret, CodeFixer.getClass(clsName, files), name, args, newName)) {
                        CodeFixer.log("      Could not find class: " + clsName);
                        CodeFixer.log("      " + p.toString());
                        if (!FATAL) continue;
                        System.exit(1);
                        continue;
                    }
                    String key = "PUBLIC_" + clsName.replace('.', '/') + "/" + name + "(" + args + ")";
                    if (added.contains(key)) continue;
                    if (!ret.containsKey(src.name)) {
                        ret.put(src.name, new ArrayList());
                    }
                    ret.get(src.name).add(new FixTypes.PublicMethod(start, length, newName));
                    added.add(key);
                    continue;
                }
                if (id == 71) {
                    String find = p.getArguments()[0];
                    TypeDeclaration cls = CodeFixer.getClass(p.getArguments()[1], files);
                    if (cls == null) {
                        CodeFixer.log("      Could not find class for field " + p.toString());
                        if (!FATAL) continue;
                        System.exit(1);
                    }
                    boolean exit = false;
                    for (FieldDeclaration field : cls.getFields()) {
                        for (VariableDeclarationFragment frag : field.fragments()) {
                            String name2 = frag.resolveBinding().getName();
                            if (!find.equals(name2)) continue;
                            String clsName = cls.resolveBinding().getQualifiedName().replace('.', '/');
                            String key = "PUBLIC_" + clsName.replace('.', '/') + "/" + name2;
                            if (!added.contains(key)) {
                                if (!ret.containsKey(clsName)) {
                                    ret.put(clsName, new ArrayList());
                                }
                                ret.get(clsName).add(new FixTypes.PublicField(field));
                                added.add(key);
                            }
                            exit = true;
                            break;
                        }
                        if (exit) continue block1;
                    }
                    continue;
                }
                if (id == 400) {
                    SrgFile.Class icls;
                    name = p.getArguments()[0];
                    String tmp = p.getArguments()[1];
                    String owner = p.getArguments()[2];
                    String impl = p.getArguments()[3];
                    String[] args = tmp.length() == 0 ? new String[]{} : tmp.split(", ");
                    Class<?> cls = Class.forName(owner, false, CodeFixer.class.getClassLoader());
                    String signature = null;
                    Class<?> returnType = null;
                    for (Method m : cls.getMethods()) {
                        Class<?>[] types;
                        if (m.getName().equals(name) && (types = m.getParameterTypes()).length == args.length) {
                            boolean same = true;
                            for (int x = 0; x < args.length; ++x) {
                                if (args[x].equals(types[x].getName().toString())) continue;
                                same = false;
                                break;
                            }
                            if (same) {
                                signature = MethodSignatureHelper.getSignature(m);
                                returnType = m.getReturnType();
                            }
                        }
                        if (signature != null) break;
                    }
                    if ((icls = SRG.getClass2(impl.replace('.', '/'))) == null) {
                        CodeFixer.log("      Could not find class in SRG " + impl);
                        if (!FATAL) continue;
                        System.exit(1);
                    }
                    SrgFile.Node mtd = icls.methods1.get(name + signature);
                    ClassTree.Class treeNode = TREE.getClass(impl);
                    if ((treeNode = treeNode.getParent()) == null) {
                        CodeFixer.log("    Could not find missing method, and parent was null: " + impl + "." + name + signature);
                        if (!FATAL) continue;
                        System.exit(1);
                    }
                    while (mtd == null && treeNode != null) {
                        icls = SRG.getClass2(treeNode.name);
                        treeNode = treeNode.getParent();
                        if (icls == null) continue;
                        mtd = icls.methods1.get(name + signature);
                    }
                    String rename = null;
                    String key = "BOUNCE_" + impl.replace('.', '/') + '/' + name + signature;
                    if (mtd == null) {
                        if (!FIXES.containsKey(key)) {
                            CodeFixer.log("      Could not find bounce rename " + key);
                            if (!FATAL) continue;
                            System.exit(1);
                        } else {
                            rename = FIXES.getProperty(key, null);
                            if (name != null) {
                                CodeFixer.log("      Loaded bounce rename " + key + " -> " + rename);
                            }
                        }
                    } else {
                        rename = mtd.rename;
                    }
                    if (rename == null || added.contains(key)) continue;
                    String clsName = impl.replace('.', '/');
                    if (!ret.containsKey(clsName)) {
                        ret.put(clsName, new ArrayList());
                    }
                    ret.get(clsName).add(new FixTypes.BounceMethod(CodeFixer.getClass(impl, files), name, rename, args, returnType));
                    added.add(key);
                    continue;
                }
                if (id == 17) {
                    String clsName = new String(p.getOriginatingFileName()).replace(".java", "");
                    if (!ret.containsKey(clsName)) {
                        ret.put(clsName, new ArrayList());
                    }
                    ret.get(clsName).add(new FixTypes.Cast(p.getSourceStart(), 0, "(" + p.getArguments()[1] + ")"));
                    continue;
                }
                errors.add(p);
            }
            CodeFixer.gatherDuplicateFixes(duplicates, ret, src);
            if (errors.size() <= 0) continue;
            CodeFixer.log("      " + src.name);
            for (IProblem p : errors) {
                CodeFixer.log("        " + p);
            }
        }
        return ret;
    }

    private static TypeDeclaration getClass(String name, ArrayList<SourceKey> keys) {
        for (SourceKey src : keys) {
            for (TypeDeclaration t : src.classes) {
                if (!t.resolveBinding().getBinaryName().equals(name)) continue;
                return t;
            }
        }
        return null;
    }

    private static void gatherDuplicateFixes(HashMap<String, ArrayList<IProblem>> duplicates, HashMap<String, ArrayList<FixTypes>> ret, SourceKey src) {
        for (Map.Entry<String, ArrayList<IProblem>> ent : duplicates.entrySet()) {
            IProblem p = ent.getValue().get(0);
            TypeDeclaration cls = null;
            for (TypeDeclaration t : src.classes) {
                if (t.getStartPosition() > p.getSourceStart() || t.getStartPosition() + t.getLength() < p.getSourceEnd()) continue;
                cls = t;
                break;
            }
            if (cls == null) {
                System.out.println("WTF! COULD NOT FIND DUPLICATE CLASS");
                System.exit(1);
            }
            for (MethodDeclaration mtd : cls.getMethods()) {
                if (!mtd.getName().toString().equals(ent.getKey()) || mtd.resolveBinding() != null) continue;
                String clsName = cls.resolveBinding().getQualifiedName().replace('.', '/');
                if (!ret.containsKey(clsName)) {
                    ret.put(clsName, new ArrayList());
                }
                ret.get(clsName).add(new FixTypes.RemoveMethod(mtd));
            }
        }
    }

    private static boolean gatherMethod(HashMap<String, ArrayList<FixTypes>> ret, TypeDeclaration cls, String name, String args, String newName) {
        if (cls == null) {
            return false;
        }
        for (MethodDeclaration mtd : cls.getMethods()) {
            if (!mtd.getName().toString().equals(name)) continue;
            String[] pts = args.length() > 0 ? args.split(", ") : new String[]{};
            List pars = mtd.parameters();
            if (pars.size() != pts.length) continue;
            boolean same = true;
            for (int x = 0; x < pts.length; ++x) {
                String clean = ClassTree.cleanType(((SingleVariableDeclaration)pars.get(x)).getType()).replace('/', '.');
                if (clean.equals(pts[x])) continue;
                same = false;
                break;
            }
            if (!same) continue;
            Type retType = mtd.getReturnType2();
            String clsName = cls.resolveBinding().getQualifiedName().replace('.', '/');
            if (!ret.containsKey(clsName)) {
                ret.put(clsName, new ArrayList());
            }
            ret.get(clsName).add(new FixTypes.BounceMethod(cls, newName, name, pts, retType.toString()));
            return true;
        }
        return false;
    }

    public static void log(String s) {
        System.out.println(s);
    }

    static {
        FATAL = true;
        FIXES = new Properties();
        DRYRUN = false;
        parser = null;
    }

    private static class SourceKey {
        String name;
        CompilationUnit cu;
        String data;
        ArrayList<TypeDeclaration> classes;

        SourceKey(String name, CompilationUnit cu, String data, ArrayList<TypeDeclaration> classes) {
            this.name = name;
            this.cu = cu;
            this.data = data;
            this.classes = classes;
        }
    }
}

