/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.rangeapplier;

import com.google.common.base.Throwables;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import joptsimple.internal.Strings;
import net.minecraftforge.srg2source.rangeapplier.MethodData;

public class SrgContainer {
    public final BiMap<String, String> classMap = HashBiMap.create();
    public final BiMap<String, String> fieldMap = HashBiMap.create();
    public final BiMap<MethodData, MethodData> methodMap = HashBiMap.create();

    public SrgContainer readSrg(File srg) {
        try {
            for (String line : Files.readLines((File)srg, (Charset)Charset.defaultCharset())) {
                if (Strings.isNullOrEmpty((String)line) || line.startsWith("#")) continue;
                String type = line.substring(0, 2);
                line = line.substring(4);
                String[] args = line.split(" ");
                if (type.equals("PK")) continue;
                if (type.equals("CL")) {
                    this.classMap.put((Object)args[0], (Object)args[1]);
                    continue;
                }
                if (type.equals("FD")) {
                    this.fieldMap.put((Object)args[0], (Object)args[1]);
                    continue;
                }
                if (type.equals("MD")) {
                    this.methodMap.put((Object)new MethodData(args[0], args[1]), (Object)new MethodData(args[2], args[3]));
                    continue;
                }
                throw new RuntimeException("Invalid SRG file: " + srg);
            }
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        return this;
    }

    public SrgContainer readSrgs(Iterable<File> srgs) {
        for (File file : srgs) {
            this.readSrg(file);
        }
        return this;
    }
}

