/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.ast;

import java.util.HashMap;
import java.util.List;
import net.minecraftforge.srg2source.ast.SymbolRangeEmitter;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class SymbolReferenceWalker
extends ASTVisitor {
    private static final String FS = "|";
    private SymbolRangeEmitter emitter;
    private String className;
    private SymbolReferenceWalker parent = null;
    private int[] newCodeRanges = new int[0];
    private HashMap<IVariableBinding, Integer> localVars = new HashMap();
    private int nextIndex = 0;
    private int nextIndexNew = 100;
    private HashMap<String, Integer> paramIndices = new HashMap();
    private int anonCount = 1;

    public SymbolReferenceWalker(SymbolRangeEmitter emitter, String className, int[] newCode) {
        this.emitter = emitter;
        this.className = className;
        this.newCodeRanges = newCode;
    }

    private SymbolReferenceWalker(String className, SymbolReferenceWalker parent) {
        this(parent.emitter, className, parent.newCodeRanges);
        this.parent = parent;
    }

    public boolean walk(ASTNode startElement) {
        if (startElement == null) {
            return true;
        }
        try {
            startElement.accept((ASTVisitor)this);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean walk(List<ASTNode> elements) {
        if (elements == null) {
            return true;
        }
        boolean ret = true;
        for (ASTNode node : elements) {
            try {
                node.accept((ASTVisitor)this);
            }
            catch (Exception e) {
                e.printStackTrace();
                ret = false;
            }
        }
        return ret;
    }

    public void setParams(HashMap<String, Integer> indices) {
        this.paramIndices.putAll(indices);
    }

    private boolean withinNewCode(int index) {
        for (int x = 0; x < this.newCodeRanges.length; x += 2) {
            int start = this.newCodeRanges[x];
            int end = this.newCodeRanges[x + 1];
            if (index < start || index > end) continue;
            return true;
        }
        return false;
    }

    private int assignLocalVariableIndex(SimpleName name, IVariableBinding binding) {
        boolean added = this.withinNewCode(name.getStartPosition());
        int index = added ? this.nextIndexNew : this.nextIndex;
        this.localVars.put(binding, index);
        if (added) {
            ++this.nextIndexNew;
        } else {
            ++this.nextIndex;
        }
        return index;
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        this.emitter.log("Annotation Start: " + ((ITypeBinding)node.getName().resolveBinding()).getQualifiedName());
        this.emitter.tab();
        return true;
    }

    public void endVisit(AnnotationTypeDeclaration node) {
        this.emitter.log("Annotation End  : " + ((ITypeBinding)node.getName().resolveBinding()).getQualifiedName());
        this.emitter.untab();
    }

    public boolean visit(AnonymousClassDeclaration node) {
        String name = this.className + "$" + this.anonCount++;
        this.emitter.log("Anon Class Start: " + name);
        this.emitter.tab();
        SymbolReferenceWalker walker = new SymbolReferenceWalker(name, this);
        for (BodyDeclaration body : node.bodyDeclarations()) {
            if (body instanceof FieldDeclaration) {
                FieldDeclaration field = (FieldDeclaration)body;
                this.emitter.emitTypeRange(field.getType());
                for (VariableDeclarationFragment frag : field.fragments()) {
                    this.emitter.emitFieldRange(frag, name);
                    SymbolReferenceWalker init = new SymbolReferenceWalker(name, walker);
                    init.anonCount = walker.anonCount;
                    init.walk((ASTNode)frag.getInitializer());
                    walker.anonCount = init.anonCount;
                }
                continue;
            }
            walker.walk((ASTNode)body);
        }
        this.emitter.untab();
        this.emitter.log("Anon Class End: " + name);
        return false;
    }

    public boolean visit(AnnotationTypeMemberDeclaration node) {
        return true;
    }

    public boolean visit(ArrayAccess node) {
        return true;
    }

    public boolean visit(ArrayCreation node) {
        return true;
    }

    public boolean visit(ArrayInitializer node) {
        return true;
    }

    public boolean visit(ArrayType node) {
        return true;
    }

    public boolean visit(AssertStatement node) {
        return true;
    }

    public boolean visit(Assignment node) {
        return true;
    }

    public boolean visit(CastExpression node) {
        return true;
    }

    public boolean visit(CatchClause node) {
        return true;
    }

    public boolean visit(ClassInstanceCreation node) {
        return true;
    }

    public boolean visit(CompilationUnit node) {
        return true;
    }

    public boolean visit(ConstructorInvocation node) {
        return true;
    }

    public boolean visit(EnumConstantDeclaration node) {
        return true;
    }

    public boolean visit(ExpressionStatement node) {
        return true;
    }

    public boolean visit(FieldAccess node) {
        return true;
    }

    public boolean visit(ForStatement node) {
        return true;
    }

    public boolean visit(IfStatement node) {
        return true;
    }

    public boolean visit(LabeledStatement node) {
        return true;
    }

    public boolean visit(TypeLiteral node) {
        return true;
    }

    public boolean visit(TypeParameter node) {
        return true;
    }

    public boolean visit(MethodInvocation node) {
        return true;
    }

    public boolean visit(ParameterizedType node) {
        return true;
    }

    public boolean visit(QualifiedName node) {
        return true;
    }

    public boolean visit(QualifiedType node) {
        return true;
    }

    public boolean visit(FieldDeclaration node) {
        this.emitter.emitTypeRange(node.getType());
        for (VariableDeclarationFragment frag : node.fragments()) {
            this.emitter.emitFieldRange(frag, this.className);
            SymbolReferenceWalker walker = new SymbolReferenceWalker(this.className, this);
            walker.anonCount = this.anonCount;
            walker.walk((ASTNode)frag.getInitializer());
            this.anonCount = walker.anonCount;
        }
        return false;
    }

    public boolean visit(EnumDeclaration node) {
        String name = ((ITypeBinding)node.getName().resolveBinding()).getQualifiedName();
        this.emitter.log("Enum Start: " + name);
        this.emitter.tab();
        SymbolReferenceWalker walker = new SymbolReferenceWalker(name, this);
        walker.walk((ASTNode)node.getJavadoc());
        walker.walk(node.modifiers());
        walker.walk((ASTNode)node.getName());
        walker.walk(node.superInterfaceTypes());
        walker.walk(node.enumConstants());
        for (BodyDeclaration body : node.bodyDeclarations()) {
            if (body instanceof FieldDeclaration) {
                FieldDeclaration field = (FieldDeclaration)body;
                this.emitter.emitTypeRange(field.getType());
                for (VariableDeclarationFragment frag : field.fragments()) {
                    this.emitter.emitFieldRange(frag, name);
                    SymbolReferenceWalker init = new SymbolReferenceWalker(name, walker);
                    init.anonCount = walker.anonCount;
                    init.walk((ASTNode)frag.getInitializer());
                    walker.anonCount = init.anonCount;
                }
                continue;
            }
            walker.walk((ASTNode)body);
        }
        this.emitter.untab();
        this.emitter.log("Enum End  : " + name);
        return false;
    }

    public boolean visit(MethodDeclaration node) {
        String signature = this.emitter.getMethodSignature(node, false);
        String name = node.getName().toString();
        this.emitter.log("Method Start: " + name + signature);
        this.emitter.tab();
        this.emitter.emitMethodRange(node, this.className, true);
        this.emitter.emitTypeRange(node.getReturnType2());
        for (Name exc : node.thrownExceptions()) {
            this.emitter.emitThrowRange(exc, (ITypeBinding)exc.resolveBinding());
        }
        List params = node.parameters();
        HashMap<String, Integer> paramIds = new HashMap<String, Integer>();
        for (int x = 0; x < params.size(); ++x) {
            SingleVariableDeclaration param = (SingleVariableDeclaration)params.get(x);
            this.emitter.emitTypeRange(param.getType());
            this.emitter.emitParameterRange(node, signature, param, x, this.className);
            paramIds.put(param.getName().getIdentifier(), x);
        }
        SymbolReferenceWalker walker = new SymbolReferenceWalker(this.className, this);
        walker.anonCount = this.anonCount;
        walker.setParams(paramIds);
        walker.walk((ASTNode)node.getBody());
        this.anonCount = walker.anonCount;
        this.emitter.untab();
        this.emitter.log("Method End: " + name + signature);
        return false;
    }

    public boolean visit(SimpleName node) {
        IBinding bind = node.resolveBinding();
        if (bind instanceof IMethodBinding) {
            this.emitter.emitReferencedMethod((Name)node, (IMethodBinding)bind);
        } else if (bind instanceof ITypeBinding) {
            this.emitter.emitReferencedClass((Name)node, (ITypeBinding)bind);
        } else if (bind instanceof IVariableBinding) {
            IVariableBinding var = (IVariableBinding)bind;
            if (var.isParameter()) {
                String id = node.getIdentifier();
                String owner = this.className;
                SymbolReferenceWalker walker = this;
                Integer i = this.paramIndices.containsKey(id) ? this.paramIndices.get(id) : -1;
                while (i == -1 && walker.parent != null) {
                    walker = walker.parent;
                    owner = walker.className;
                    i = walker.paramIndices.containsKey(id) ? walker.paramIndices.get(id) : -1;
                }
                this.emitter.emitReferencedMethodParameter((Name)node, var, i, owner);
            } else if (var.isField()) {
                this.emitter.emitReferencedField((Name)node, var.getVariableDeclaration(), this.className);
            }
        } else if (!(bind instanceof IPackageBinding)) {
            this.emitter.log("ERROR SimpleName: " + node + " " + node.resolveBinding());
        }
        return true;
    }

    public boolean visit(SimpleType node) {
        ITypeBinding bind = node.resolveBinding();
        if (bind instanceof ITypeBinding) {
            this.emitter.emitReferencedClass(node.getName(), bind);
        } else {
            this.emitter.log("ERROR SimpleType: " + node + " " + (bind != null ? bind.getClass() : "null"));
        }
        return false;
    }

    public boolean visit(SingleVariableDeclaration node) {
        int index = this.assignLocalVariableIndex(node.getName(), node.resolveBinding());
        node.getType().accept((ASTVisitor)this);
        if (node.getInitializer() != null) {
            node.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        String name = ((ITypeBinding)node.getName().resolveBinding()).getQualifiedName();
        this.emitter.log("Class Start: " + name);
        this.emitter.tab();
        SymbolReferenceWalker walker = new SymbolReferenceWalker(name, this);
        for (BodyDeclaration body : node.bodyDeclarations()) {
            if (body instanceof FieldDeclaration) {
                FieldDeclaration field = (FieldDeclaration)body;
                this.emitter.emitTypeRange(field.getType());
                for (VariableDeclarationFragment frag : field.fragments()) {
                    this.emitter.emitFieldRange(frag, name);
                    SymbolReferenceWalker init = new SymbolReferenceWalker(name, walker);
                    init.anonCount = walker.anonCount;
                    init.walk((ASTNode)frag.getInitializer());
                    walker.anonCount = init.anonCount;
                }
                continue;
            }
            walker.walk((ASTNode)body);
        }
        this.emitter.untab();
        this.emitter.log("Class End  : " + name);
        return false;
    }

    public boolean visit(VariableDeclarationFragment node) {
        int index = this.assignLocalVariableIndex(node.getName(), node.resolveBinding());
        if (node.getInitializer() != null) {
            node.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }
}

