/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.ast;

import java.io.PrintWriter;
import net.minecraftforge.srg2source.ast.MethodSignatureHelper;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.WildcardType;

public class SymbolRangeEmitter {
    private String sourceFilePath;
    private PrintWriter logFile;
    private final String FS = "|";
    private String tab = "";

    public SymbolRangeEmitter(String sourceFilePath, PrintWriter logFile) {
        this.sourceFilePath = sourceFilePath;
        this.logFile = logFile;
    }

    public void emitPackageRange(PackageDeclaration pkg) {
        String name = pkg.getName().getFullyQualifiedName();
        this.log(this.commonFields(name, (ASTNode)pkg.getName()) + "package" + "|" + name + "|" + "(file)");
    }

    public String getSourcePath() {
        return this.sourceFilePath;
    }

    public void emitImportRange(ImportDeclaration imp) {
    }

    public String emitClassRange(TypeDeclaration clazz) {
        SimpleName name = clazz.getName();
        String className = name.getIdentifier();
        String qualified = ((ITypeBinding)name.resolveBinding()).getQualifiedName();
        this.log(this.commonFields(className, (ASTNode)clazz.getName()) + "class" + "|" + qualified);
        return qualified;
    }

    public void emitTypeRange(Type type) {
        if (type == null) {
            return;
        }
        if (type.isArrayType()) {
            type = ((ArrayType)type).getElementType();
        }
        if (type.isPrimitiveType()) {
            return;
        }
        if (type.isParameterizedType()) {
            ParameterizedType p = (ParameterizedType)type;
            for (Type t : p.typeArguments()) {
                this.emitTypeRange(t);
            }
            type = p.getType();
        }
        if (type.isWildcardType()) {
            this.emitTypeRange(((WildcardType)type).getBound());
            return;
        }
        if (type.isSimpleType()) {
            SimpleType stype = (SimpleType)type;
            ITypeBinding bind = stype.getName().resolveTypeBinding();
            if (bind.isTypeVariable()) {
                return;
            }
            this.log(this.commonFields(stype.getName().toString(), (ASTNode)stype.getName()) + "class" + "|" + bind.getErasure().getQualifiedName());
        } else {
            System.out.println("ERROR Unknown Type: " + type + type.getClass() + " " + type.getStartPosition() + "|" + type.getStartPosition() + type.getLength());
        }
    }

    public void emitFieldRange(VariableDeclarationFragment field, String parent) {
        IVariableBinding var = field.resolveBinding();
        String name = var.getName();
        String cls = var.getDeclaringClass().getQualifiedName();
        String init = "";
        if (cls.isEmpty()) {
            cls = parent;
        }
        if (name.equals("__OBFID")) {
            init = ((StringLiteral)field.getInitializer()).getLiteralValue();
        }
        this.log(this.commonFields(name, (ASTNode)field.getName()) + "field" + "|" + cls + "|" + name + "|" + init);
    }

    private IMethodBinding resolveOverrides(IMethodBinding bind) {
        if (bind == null) {
            return null;
        }
        ITypeBinding clazz = bind.getDeclaringClass();
        if (clazz == null) {
            return bind;
        }
        if (bind.getName().equals("clone") || bind.getName().equals("equals")) {
            return bind;
        }
        IMethodBinding tmp = this.resolveOverrides(bind, clazz.getSuperclass());
        if (tmp != null) {
            bind = tmp;
        }
        for (ITypeBinding intf : clazz.getInterfaces()) {
            tmp = this.resolveOverrides(bind, intf);
            if (tmp == null) continue;
            bind = tmp;
        }
        return bind;
    }

    private IMethodBinding resolveOverrides(IMethodBinding bind, ITypeBinding type) {
        if (type == null || bind.isConstructor()) {
            return bind;
        }
        for (IMethodBinding sup : type.getDeclaredMethods()) {
            if (!bind.overrides(sup)) continue;
            return this.resolveOverrides(sup);
        }
        IMethodBinding tmp = this.resolveOverrides(bind, type.getSuperclass());
        if (tmp == bind) {
            for (ITypeBinding intf : type.getInterfaces()) {
                tmp = this.resolveOverrides(bind, intf);
                if (tmp == null || tmp == bind) continue;
                return tmp;
            }
            return bind;
        }
        return tmp;
    }

    public String emitMethodRange(MethodDeclaration method, String className, boolean resolve) {
        IMethodBinding bind = method.resolveBinding();
        if (resolve) {
            bind = this.resolveOverrides(bind);
        }
        if (bind == null) {
            this.log("Null method binding! " + method);
            throw new RuntimeException("Null method binding! " + method);
        }
        String signature = MethodSignatureHelper.getSignature(bind);
        String name = method.getName().toString();
        String owner = bind.getDeclaringClass().getQualifiedName();
        if (owner.isEmpty()) {
            owner = className;
        }
        this.log(this.commonFields(name, (ASTNode)method.getName()) + "method" + "|" + owner + "|" + name + "|" + signature);
        return signature;
    }

    public String getMethodSignature(MethodDeclaration method, boolean resolve) {
        IMethodBinding bind = method.resolveBinding();
        if (resolve) {
            bind = this.resolveOverrides(bind);
        }
        if (bind == null) {
            this.log("Null method binding! " + method);
            throw new RuntimeException("Null method binding! " + method);
        }
        return MethodSignatureHelper.getSignature(bind);
    }

    public void emitParameterRange(MethodDeclaration method, String signature, SingleVariableDeclaration param, int index, String className) {
        if (param == null || param.getName() == null) {
            return;
        }
        String name = param.getName().getIdentifier();
        IMethodBinding bind = method.resolveBinding();
        IMethodBinding top = this.resolveOverrides(bind);
        if (top.getDeclaringClass().getQualifiedName().equals("net.minecraft.server.BlockSapling.TreeGenerator") && top.getName().toString().equals("generate")) {
            bind = top;
        }
        String owner = bind.getDeclaringClass().getQualifiedName();
        String mName = bind.getName();
        if (owner.isEmpty()) {
            owner = className;
        }
        this.log(this.commonFields(name, (ASTNode)param.getName()) + "param" + "|" + owner + "|" + mName + "|" + signature + "|" + name + "|" + index);
    }

    public void emitReferencedClass(Name name, ITypeBinding clazz) {
        this.log(this.commonFields(name.toString(), (ASTNode)name) + "class" + "|" + clazz.getErasure().getQualifiedName());
    }

    public void emitReferencedMethod(Name name, IMethodBinding method) {
        method = this.resolveOverrides(method);
        this.log(this.commonFields(name.toString(), (ASTNode)name) + "method" + "|" + method.getDeclaringClass().getErasure().getQualifiedName() + "|" + method.getName() + "|" + MethodSignatureHelper.getSignature(method));
    }

    public void emitReferencedMethodParameter(Name name, IVariableBinding var, int index, String className) {
        String owner;
        IMethodBinding method = var.getDeclaringMethod();
        IMethodBinding top = this.resolveOverrides(method);
        if (top.getDeclaringClass().getQualifiedName().equals("net.minecraft.server.BlockSapling.TreeGenerator") && top.getName().toString().equals("generate")) {
            method = top;
        }
        if ((owner = method.getDeclaringClass().getQualifiedName()).isEmpty()) {
            owner = className;
        }
        this.log(this.commonFields(name.toString(), (ASTNode)name) + "param" + "|" + owner + "|" + method.getName() + "|" + MethodSignatureHelper.getSignature(method) + "|" + name + "|" + index);
    }

    public void emitLocalVariableRange(Name name, String className, String methodName, String methodSignature, int index) {
        this.log(this.commonFields(name.toString(), (ASTNode)name) + "localvar" + "|" + className + "|" + methodName + "|" + methodSignature + "|" + name + "|" + index);
    }

    public void emitReferencedField(Name name, IVariableBinding field, String className) {
        ITypeBinding type = field.getDeclaringClass();
        if (type == null && name.toString().equals("length")) {
            this.log("Field: Array Length, skipping");
            return;
        }
        String owner = field.getDeclaringClass().getQualifiedName();
        if (owner.isEmpty()) {
            owner = className;
        }
        this.log(this.commonFields(name.toString(), (ASTNode)name) + "field" + "|" + owner + "|" + field.getName());
    }

    public String commonFields(String oldText, ASTNode textRange) {
        return "@|" + this.sourceFilePath + "|" + textRange.getStartPosition() + "|" + (textRange.getStartPosition() + textRange.getLength()) + "|" + oldText + "|";
    }

    public void tab() {
        this.tab = this.tab + "   ";
    }

    public void untab() {
        this.tab = this.tab.substring(0, this.tab.length() - 3);
    }

    public void log(String s) {
        if (this.logFile != null) {
            this.logFile.println(this.tab + s);
        }
    }

    public void emitThrowRange(Name exc, ITypeBinding type) {
        this.log(this.commonFields(exc.getFullyQualifiedName(), (ASTNode)exc) + "class" + "|" + type.getQualifiedName());
    }
}

