/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.ast;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraftforge.srg2source.ast.MethodSignatureHelper;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassTree {
    private HashMap<String, Class> classes = new HashMap();
    private boolean includeInterfaces = true;

    public ClassTree() {
    }

    public ClassTree(boolean includeInterfaces) {
        this.includeInterfaces = includeInterfaces;
    }

    public Class getClass(String name) {
        Class ret = this.classes.get(name = name.replace('.', '/'));
        if (ret == null) {
            ret = new Class(name);
            ret.setInclueInterfaces(this.includeInterfaces);
            this.classes.put(name, ret);
        }
        return ret;
    }

    public void processLibrary(File file) {
        try {
            ZipInputStream input = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
            ZipEntry entry = null;
            while ((entry = input.getNextEntry()) != null) {
                int len;
                String name = entry.getName();
                if (entry.isDirectory() || !name.endsWith(".class") || name.startsWith(".")) continue;
                byte[] data = new byte[4096];
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                while ((len = input.read(data)) != -1) {
                    buf.write(data, 0, len);
                }
                this.processClass(buf.toByteArray());
            }
            input.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void processClass(byte[] data) {
        ClassReader reader = new ClassReader(data);
        ClassNode classNode = new ClassNode();
        reader.accept((ClassVisitor)classNode, 0);
        Class cls = this.getClass(classNode.name);
        if (cls.hasProcessed) {
            return;
        }
        cls.access = classNode.access;
        cls.setParent(this.getClass(classNode.superName));
        for (String inter : classNode.interfaces) {
            cls.addInterface(this.getClass(inter));
        }
        for (FieldNode field : classNode.fields) {
            cls.addField(new Node(cls, field.name, field.access, field.desc, false));
        }
        for (MethodNode method : classNode.methods) {
            cls.addMethod(new Node(cls, method.name, method.access, method.desc, true));
        }
        cls.hasProcessed = true;
    }

    public boolean processClass(AbstractTypeDeclaration type) {
        if (!(type instanceof AnnotationTypeDeclaration) && !(type instanceof EnumDeclaration) && type instanceof TypeDeclaration) {
            this.processClass((TypeDeclaration)type);
        }
        return true;
    }

    public void processClass(TypeDeclaration type) {
        FieldDeclaration[] fields;
        String className = ((ITypeBinding)type.getName().resolveBinding()).getQualifiedName();
        Class cls = this.getClass(className);
        if (cls.hasProcessed) {
            return;
        }
        cls.access = type.getModifiers();
        if (type.getSuperclassType() != null) {
            cls.setParent(this.getClass(ClassTree.cleanType(type.getSuperclassType())));
        }
        for (Type i : type.superInterfaceTypes()) {
            cls.addInterface(this.getClass(ClassTree.cleanType(i)));
        }
        for (FieldDeclaration fieldDeclaration : fields = type.getFields()) {
            String desc = MethodSignatureHelper.getTypeSignature(fieldDeclaration.getType().resolveBinding());
            int access = fieldDeclaration.getModifiers();
            for (VariableDeclarationFragment frag : fieldDeclaration.fragments()) {
                cls.addField(new Node(cls, frag.resolveBinding().getName(), access, desc, false));
            }
        }
        for (FieldDeclaration fieldDeclaration : type.getMethods()) {
            IMethodBinding bind = fieldDeclaration.resolveBinding();
            if (bind == null) continue;
            String desc = MethodSignatureHelper.getSignature(bind);
            cls.addMethod(new Node(cls, fieldDeclaration.getName().toString(), fieldDeclaration.getModifiers(), desc, true));
        }
        cls.hasProcessed = true;
        for (BodyDeclaration body : type.bodyDeclarations()) {
            if (!(body instanceof AbstractTypeDeclaration)) continue;
            this.processClass((AbstractTypeDeclaration)body);
        }
    }

    public static String cleanType(Type type) {
        if (type == null) {
            return null;
        }
        if (type.isArrayType()) {
            type = ((ArrayType)type).getElementType();
        }
        if (type.isPrimitiveType()) {
            return type.toString().replace('.', '/');
        }
        if (type.isParameterizedType()) {
            type = ((ParameterizedType)type).getType();
        }
        if (type.isWildcardType()) {
            return "WILDCARD!?!?!?";
        }
        if (type.isSimpleType()) {
            SimpleType stype = (SimpleType)type;
            ITypeBinding bind = stype.getName().resolveTypeBinding().getErasure();
            return bind.getQualifiedName().replace('.', '/');
        }
        System.out.println("ERROR Unknown Type: " + type + type.getClass() + " " + type.getStartPosition() + '|' + type.getStartPosition() + type.getLength());
        return type.toString();
    }

    public static void log(String s) {
        System.out.println(s);
    }

    public static class Class
    extends Node {
        protected boolean hasProcessed = false;
        private boolean includeInterfaces = true;
        private Class parent = null;
        private ArrayList<Class> interfaces = new ArrayList();
        private ArrayList<Class> children = new ArrayList();
        private ArrayList<Node> fields = new ArrayList();
        private ArrayList<Node> methods = new ArrayList();

        public Class(String name) {
            super(name, 0, "", false);
        }

        public void setInclueInterfaces(boolean value) {
            this.includeInterfaces = value;
        }

        public Class setParent(Class cls) {
            this.parent = cls;
            this.parent.addChild(this);
            return this;
        }

        public Class getParent() {
            return this.parent;
        }

        private void addNode(ArrayList lst, Node fld) {
            if (lst.contains(fld)) {
                lst.remove(fld);
            }
            lst.add(fld);
        }

        public void addInterface(Class cls) {
            this.addNode(this.interfaces, cls);
            cls.addChild(this);
        }

        public void addField(Node fld) {
            this.addNode(this.fields, fld);
        }

        public void addChild(Class cls) {
            this.addNode(this.children, cls);
        }

        public void addMethod(Node mtd) {
            if (!mtd.name.equals("<clinit>")) {
                this.addNode(this.methods, mtd);
            }
        }

        private <T> ArrayList<T> sort(ArrayList lst) {
            Collections.sort(lst);
            return lst;
        }

        public ArrayList<Class> getChildren() {
            return this.sort((ArrayList)this.children.clone());
        }

        public ArrayList<Class> getInterfaces() {
            return this.sort((ArrayList)this.interfaces.clone());
        }

        public ArrayList<Node> getFields() {
            return this.sort((ArrayList)this.fields.clone());
        }

        public ArrayList<Node> getMethods() {
            return this.sort((ArrayList)this.methods.clone());
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }

        public boolean hasInterfaces() {
            return this.interfaces.size() > 0;
        }

        public boolean hasFields() {
            return this.fields.size() > 0;
        }

        public boolean hasMethods() {
            return this.methods.size() > 0;
        }

        public Node getField(String name) {
            Node search = new Node(name, 0, "", false);
            return this.fields.contains(search) ? this.fields.get(this.fields.indexOf(search)) : null;
        }

        public Node getMethod(String name, String desc) {
            Node search = new Node(name, 0, desc, true);
            return this.methods.contains(search) ? this.methods.get(this.methods.indexOf(search)) : null;
        }

        public Node[] getMethods(String name) {
            ArrayList<Node> ret = new ArrayList<Node>();
            for (Node n : this.methods) {
                if (!n.name.equals(name)) continue;
                ret.add(n);
            }
            return ret.toArray(new Node[ret.size()]);
        }

        public Node getTopField(String name) {
            return this.getTop(name, null, true);
        }

        public Node getTopMethod(String name, String desc) {
            if (name.equals("<init>")) {
                return this.getMethod(name, desc);
            }
            return this.getTop(name, desc, true);
        }

        private Node getTop(String name, String desc, boolean isBottom) {
            Node f;
            Node ret = null;
            if (this.parent != null && (ret = this.parent.getTop(name, desc, false)) != null) {
                return ret;
            }
            if (this.includeInterfaces) {
                for (Class cls : this.interfaces) {
                    ret = cls.getTop(name, desc, false);
                    if (ret == null) continue;
                    return ret;
                }
            }
            Node node = f = desc == null ? this.getField(name) : this.getMethod(name, desc);
            if (f != null && (!Modifier.isPrivate(f.access) || isBottom)) {
                return f;
            }
            return null;
        }

        public boolean isChild(Class child) {
            return this.getChildren().contains(this) || this.getParent().isChild(child);
        }
    }

    public static class Node
    implements Comparable<Node> {
        public Class owner;
        public final String name;
        public int access;
        public final String desc;
        private boolean strict = false;

        public Node(Class owner, String name, int access, String desc, boolean strict) {
            this(name, access, desc, strict);
            this.owner = owner;
        }

        private Node(String name, int access, String desc, boolean strict) {
            this.name = name;
            this.access = access;
            this.desc = desc;
            this.strict = strict;
            if (this instanceof Class) {
                this.owner = (Class)this;
            }
        }

        public String toString() {
            return String.format("%s %s", this.name, this.desc);
        }

        public String getFullDesc() {
            return String.format("%s/%s %s", this.owner.name, this.name, this.desc);
        }

        public boolean equals(Object o) {
            if (o instanceof Node) {
                Node t = (Node)o;
                if (this.strict) {
                    return t.strict && t.name.equals(this.name) && t.desc.equals(this.desc);
                }
                return !t.strict && t.name.equals(this.name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ (this.strict ? this.desc.hashCode() : 0);
        }

        @Override
        public int compareTo(Node o) {
            return this.name.compareTo(o.name);
        }
    }
}

