/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.remapper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.srg2source.util.io.InputSupplier;
import net.minecraftforge.srg2source.util.io.OutputSupplier;

public class SourcesSupplier
implements InputSupplier,
OutputSupplier {
    List<File> roots;
    final Map<String, String> files = Maps.newHashMap();

    public SourcesSupplier(List<File> roots) {
        this.roots = roots;
        for (File src : roots) {
            String root = src.getAbsolutePath();
            for (File f : Files.fileTreeTraverser().preOrderTraversal((Object)src)) {
                if (f.isDirectory()) continue;
                String relative = f.getAbsolutePath().substring(root.length() + 1);
                this.files.put(relative, root);
            }
        }
    }

    public void close() throws IOException {
    }

    public OutputStream getOutput(String relPath) {
        File out = null;
        for (File root : this.roots) {
            File file = new File(root, relPath);
            if (!file.exists()) continue;
            out = file;
            break;
        }
        if (out == null) {
            out = new File(this.roots.get(0), relPath);
        }
        try {
            if (!out.exists()) {
                out.getParentFile().mkdirs();
                out.createNewFile();
            }
            return Files.asByteSink((File)out, (FileWriteMode[])new FileWriteMode[0]).openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getRoot(String resource) {
        for (File root : this.roots) {
            File file = new File(root, resource);
            if (!file.exists()) continue;
            return root.getAbsolutePath();
        }
        return this.roots.get(0).getAbsolutePath();
    }

    public InputStream getInput(String relPath) {
        for (File root : this.roots) {
            File f = new File(root, relPath);
            if (!f.exists()) continue;
            try {
                return new FileInputStream(f);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
        }
        return null;
    }

    public List<String> gatherAll(String endFilter) {
        ArrayList ret = Lists.newArrayList();
        for (String path : this.files.keySet()) {
            if (!path.endsWith(endFilter)) continue;
            ret.add(path);
        }
        return ret;
    }
}

