/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.remapper;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import joptsimple.internal.Strings;
import net.minecraftforge.remapper.MappingDownloader;
import net.minecraftforge.remapper.SourcesSupplier;
import net.minecraftforge.srg2source.ast.RangeExtractor;
import net.minecraftforge.srg2source.rangeapplier.ExceptorFile;
import net.minecraftforge.srg2source.rangeapplier.MethodData;
import net.minecraftforge.srg2source.rangeapplier.RangeApplier;
import net.minecraftforge.srg2source.rangeapplier.SrgContainer;
import net.minecraftforge.srg2source.util.io.InputSupplier;
import net.minecraftforge.srg2source.util.io.OutputSupplier;

public class RemapperTask {
    static Splitter COMMA = Splitter.on((String)",");

    public static void runRemapMod(final List<File> deps, final List<File> srcs, final String mcVersion, final String oldMapping, final String newMapping, final File cacheDir, final IProgressListener listener) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                RemapperTask.runRemapMod_Thread(deps, srcs, mcVersion, oldMapping, newMapping, cacheDir, listener);
            }
        }).start();
    }

    public static void runRemapMod_Thread(List<File> deps, List<File> srcs, String mcVersion, String oldMapping, String newMapping, File cacheDir, IProgressListener listener) {
        if (RemapperTask.extractRange(deps, srcs, listener)) {
            final HashMap excs = Maps.newHashMap();
            SrgContainer srg = RemapperTask.createSrg(mcVersion, oldMapping, newMapping, cacheDir, excs, listener);
            if (listener != null) {
                listener.writeLine("Loading EXC file");
            }
            try {
                for (String line : Files.readLines((File)MappingDownloader.getMcp(mcVersion, cacheDir, "joined.exc"), (Charset)Charsets.UTF_8)) {
                    if (line.indexOf(61) == -1) continue;
                    String[] pts = line.split("=");
                    excs.put(pts[0], pts[1]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ExceptorFile exc = new ExceptorFile(){
                {
                    for (Map.Entry e : excs.entrySet()) {
                        ExceptorFile.ExcLine line = super.parseLine((String)e.getKey() + "=" + (String)e.getValue());
                        if (line == null) continue;
                        this.add(line);
                    }
                }
            };
            RemapperTask.applyRemap(srg, exc, deps, srcs, listener);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean extractRange(List<File> deps, List<File> srcs, final IProgressListener listener) {
        void var5_9;
        RangeExtractor extractor = new RangeExtractor();
        for (File file : deps) {
            extractor.addLibs(file);
        }
        HashMap files = Maps.newHashMap();
        for (File src : srcs) {
            String root = src.getAbsolutePath();
            for (File f : Files.fileTreeTraverser().preOrderTraversal((Object)src)) {
                if (f.isDirectory()) continue;
                String relative = f.getAbsolutePath().substring(root.length() + 1);
                files.put(relative, root);
            }
        }
        extractor.setSrc((InputSupplier)new SourcesSupplier(srcs));
        Object var5_7 = null;
        PrintWriter map = null;
        try {
            PrintStream printStream = new PrintStream("./ExtractRange.log"){
                private int total;
                private int current;
                {
                    super(x0);
                    this.total = 1;
                    this.current = 0;
                }

                @Override
                public void println(String x) {
                    if (listener != null) {
                        if (x.startsWith("Processing ") && x.endsWith(" files")) {
                            listener.writeLine(x);
                            this.total = Integer.parseInt(x.split(" ")[1]);
                        } else if (x.startsWith("startProcessing \"")) {
                            String file = x.substring(17, x.indexOf(34, 18));
                            listener.writeLine("Extracting " + ++this.current + "/" + this.total + ": " + file);
                        }
                    }
                    super.println(x);
                }
            };
            map = new PrintWriter(new BufferedWriter(new FileWriter("./ExtractRange.txt")));
            extractor.setOutLogger(printStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        boolean worked = extractor.generateRangeMap(map);
        if (var5_9 != null) {
            var5_9.close();
        }
        if (map != null) {
            map.close();
        }
        if (listener != null) {
            listener.writeLine("Extracting Range Complete!");
        }
        return worked;
    }

    private static SrgContainer createSrg(String mcVersion, String oldMapping, String newMapping, File cache, Map<String, String> excs, IProgressListener listener) {
        HashMap mold = Maps.newHashMap();
        HashMap mnew = Maps.newHashMap();
        if (listener != null) {
            listener.writeLine("Loading Old Mapping");
        }
        for (File f : MappingDownloader.getCsvs(oldMapping, cache)) {
            RemapperTask.loadCSV(f, mold);
        }
        if (listener != null) {
            listener.writeLine("Loading New Mapping");
        }
        for (File f : MappingDownloader.getCsvs(newMapping, cache)) {
            RemapperTask.loadCSV(f, mnew);
        }
        SrgContainer ret = new SrgContainer();
        try {
            if (listener != null) {
                listener.writeLine("Loading Statics File");
            }
            HashSet statics = Sets.newHashSet();
            statics.addAll(Files.readLines((File)MappingDownloader.getMcp(mcVersion, cache, "static_methods.txt"), (Charset)Charsets.UTF_8));
            Joiner COMMA = Joiner.on((char)',');
            if (listener != null) {
                listener.writeLine("Loading SRG File");
            }
            for (String line : Files.readLines((File)MappingDownloader.getMcp(mcVersion, cache, "joined.srg"), (Charset)Charsets.UTF_8)) {
                String n;
                String o;
                String cls;
                if (Strings.isNullOrEmpty((String)line) || line.startsWith("#")) continue;
                String[] pts = line.split(" ");
                if ("PK:".equals(pts[0])) {
                    ret.packageMap.put((Object)pts[1], (Object)pts[2]);
                    continue;
                }
                if ("CL:".equals(pts[0])) {
                    ret.classMap.put((Object)pts[1], (Object)pts[2]);
                    continue;
                }
                if ("FD:".equals(pts[0])) {
                    cls = pts[2].substring(0, pts[2].lastIndexOf(47) + 1);
                    String fd = pts[2].substring(cls.length());
                    o = (String)mold.get(fd);
                    n = (String)mnew.get(fd);
                    if (o == null) {
                        o = fd;
                    }
                    if (n == null) {
                        n = fd;
                    }
                    ret.fieldMap.put((Object)(cls + o), (Object)(cls + n));
                    continue;
                }
                if (!"MD:".equals(pts[0])) continue;
                cls = pts[3].substring(0, pts[3].lastIndexOf(47) + 1);
                String md = pts[3].substring(cls.length());
                o = (String)mold.get(md);
                n = (String)mnew.get(md);
                if (o == null) {
                    o = md;
                }
                if (n == null) {
                    n = md;
                }
                ret.methodMap.put((Object)new MethodData(cls + o, pts[4]), (Object)new MethodData(cls + n, pts[4]));
                if (!md.startsWith("func_") || pts[4].startsWith("()")) continue;
                int idx = 0;
                if (statics.contains(md)) {
                    ++idx;
                }
                ArrayList params = Lists.newArrayList();
                String id = md.split("_")[1];
                int pos = 1;
                int end = pts[3].lastIndexOf(41);
                block9: while (pos < end) {
                    params.add("p_" + id + "_" + idx++ + "_");
                    char i = pts[3].charAt(pos);
                    switch (i) {
                        case 'L': {
                            pos = pts[3].indexOf(59, pos) + 1;
                            continue block9;
                        }
                        case 'D': 
                        case 'J': {
                            ++idx;
                            ++pos;
                            continue block9;
                        }
                    }
                    ++pos;
                }
                excs.put(cls + o, "|" + COMMA.join((Iterable)params));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private static void loadCSV(File file, Map<String, String> map) {
        try {
            boolean header = true;
            for (String line : Files.readLines((File)file, (Charset)Charsets.UTF_8)) {
                if (header) {
                    header = false;
                    continue;
                }
                List pts = COMMA.splitToList((CharSequence)line);
                map.put((String)pts.get(0), (String)pts.get(1));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean applyRemap(SrgContainer srg, ExceptorFile exc, List<File> deps, List<File> srcs, final IProgressListener listener) {
        RangeApplier applier = new RangeApplier();
        applier.setKeepImports(true);
        applier.readSrg(srg);
        if (exc != null && exc.size() > 0) {
            applier.readParamMap(exc);
        }
        PrintStream log = null;
        try {
            log = new PrintStream("./ApplyRange.log"){
                private int total;
                private int current;
                {
                    super(x0);
                    this.total = 1;
                    this.current = 0;
                }

                @Override
                public void println(String x) {
                    if (listener != null) {
                        if (x.startsWith("Processing ") && x.endsWith(" files")) {
                            listener.writeLine(x);
                            this.total = Integer.parseInt(x.split(" ")[1]);
                        } else if (x.startsWith("Start Processing: ")) {
                            String file = x.substring(17);
                            listener.writeLine("Remapping " + ++this.current + "/" + this.total + ": " + file);
                        }
                    }
                    super.println(x);
                }
            };
            applier.setOutLogger(log);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        SourcesSupplier sup = new SourcesSupplier(srcs);
        try {
            applier.remapSources((InputSupplier)sup, (OutputSupplier)sup, new File("./ExtractRange.txt"), false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (log != null) {
            log.close();
        }
        if (listener != null) {
            listener.writeLine("Remapping finished!");
        }
        return true;
    }

    public static interface IProgressListener {
        public void writeLine(String var1);
    }
}

