/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.remapper;

import com.google.common.collect.Lists;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.minecraftforge.remapper.GatherModInfo;
import net.minecraftforge.remapper.MappingDownloader;
import net.minecraftforge.remapper.RemapperTask;

public class RemapperGUI {
    private static final int MARGIN = 15;
    static boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase().contains("windows");
    private JFrame mainFrame;
    private JLabel status;
    private JButton btnGetModInfo;
    File targetDir = new File(".");
    ListModel<File> deps = new ListModel();
    ListModel<File> srcs = new ListModel();
    public boolean buildFailed;
    File cacheDir = new File(".");
    private JComboBox<String> jmcVersion;
    private JComboBox<String> joldMapping;
    private JComboBox<String> jnewMapping;
    private JButton jDownloadOld;
    private JButton jDownloadNew;
    String mcVersion = "UNLOADED";
    String oldMapping = "UNLOADED";
    private String newMapping = "UNLOADED";
    private JButton btnRemapMod;
    private List<Runnable> changeListeners = Lists.newArrayList();

    public RemapperGUI() {
        this.mainFrame = new JFrame("Java Source Remapper");
        this.mainFrame.setSize(500, 500);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JComponent folderAndLoadInfo = this.createFolderAndLoadInfoComponent();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        constraints.gridwidth = 2;
        constraints.gridheight = 2;
        constraints.weighty = 0.0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(15, 15, 0, 15);
        mainPanel.add((Component)folderAndLoadInfo, constraints);
        JComponent dependencies = this.createDependenciesComponent();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.fill = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 3;
        constraints.weighty = 1.0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(5, 15, 5, 5);
        mainPanel.add((Component)dependencies, constraints);
        JComponent sources = this.createSourcesComponent();
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.fill = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 3;
        constraints.weighty = 1.0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(5, 5, 5, 15);
        mainPanel.add((Component)sources, constraints);
        JComponent mappingsSelectionLeft = this.createMappingsSelectionLeft();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 2;
        constraints.weighty = 0.0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(5, 15, 20, 5);
        mainPanel.add((Component)mappingsSelectionLeft, constraints);
        JComponent mappingsSelectionRight = this.createMappingsSelectionRight();
        constraints.gridx = 1;
        constraints.gridy = 5;
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 2;
        constraints.weighty = 0.0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(5, 5, 20, 15);
        mainPanel.add((Component)mappingsSelectionRight, constraints);
        this.mainFrame.getContentPane().add((Component)mainPanel, "Center");
        this.mainFrame.setDefaultCloseOperation(3);
        this.mainFrame.setLocationRelativeTo(null);
        this.mainFrame.setMinimumSize(new Dimension(440, 320));
        this.mainFrame.setVisible(true);
        MappingDownloader.downloadMappingList(new Runnable(){

            @Override
            public void run() {
                RemapperGUI.this.updateGuiState();
            }
        });
    }

    private JComponent createFolderAndLoadInfoComponent() {
        Box box = Box.createVerticalBox();
        JPanel folderSelect = this.createFolderSelectionComponent();
        this.status = new JLabelMax("Select Folder!", 0);
        this.status.setOpaque(true);
        JPanel buttonList = new JPanel();
        this.btnGetModInfo = new JButton("Load Info");
        this.btnGetModInfo.setEnabled(false);
        this.btnGetModInfo.setToolTipText("Load information from a build.gradle");
        this.btnGetModInfo.addActionListener(new GatherModInfo(this));
        buttonList.add(this.btnGetModInfo);
        box.add(folderSelect);
        box.add(this.status);
        box.add(buttonList);
        return box;
    }

    private JPanel createFolderSelectionComponent() {
        JPanel folderSelect = new JPanel();
        folderSelect.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        folderSelect.add((Component)new JLabel("Project Folder:"), constraints);
        constraints.gridx = 1;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        folderSelect.add((Component)this.createBrowseBox(25, new IBrowseListener(){

            @Override
            public File getValue() {
                return RemapperGUI.this.targetDir;
            }

            @Override
            public void setValue(File value) {
                RemapperGUI.this.targetDir = value;
            }
        }), constraints);
        return folderSelect;
    }

    private JComponent createDependenciesComponent() {
        Box depBox = Box.createVerticalBox();
        depBox.add(new JLabelMax("Dependencies:", 10));
        JList<File> depList = new JList<File>(this.deps);
        depList.setCellRenderer(new FileListRenderer());
        depBox.add(new JScrollPane(depList));
        depBox.setMinimumSize(new Dimension(225, 200));
        return depBox;
    }

    private JComponent createSourcesComponent() {
        Box srcBox = Box.createVerticalBox();
        srcBox.add(new JLabelMax("Sources:", 10));
        JList<File> srcList = new JList<File>(this.srcs);
        srcList.setCellRenderer(new FileListRenderer());
        srcBox.add(new JScrollPane(srcList));
        srcBox.setMinimumSize(new Dimension(225, 200));
        return srcBox;
    }

    private JComponent createMappingsSelectionLeft() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel minecraftVersionLabel = this.makeLabel("Minecraft: ");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weighty = 0.0;
        constraints.weightx = 0.0;
        panel.add((Component)minecraftVersionLabel, constraints);
        JComponent selectMinecraftVersion = this.createSelectMcVersionComponent();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.fill = 2;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.weighty = 0.0;
        constraints.weightx = 1.0;
        panel.add((Component)selectMinecraftVersion, constraints);
        JLabel oldMappingsLabel = this.makeLabel("Old: ");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.fill = 2;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weighty = 0.0;
        constraints.weightx = 0.0;
        panel.add((Component)oldMappingsLabel, constraints);
        JComponent oldMappingsSelection = this.createOldMappingsSelection();
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.fill = 2;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.weighty = 0.0;
        constraints.weightx = 1.0;
        panel.add((Component)oldMappingsSelection, constraints);
        JComponent downloadOldButton = this.createDownloadOldButton();
        constraints.gridx = 2;
        constraints.gridy = 2;
        constraints.fill = 2;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.weighty = 0.0;
        constraints.weightx = 0.0;
        panel.add((Component)downloadOldButton, constraints);
        return panel;
    }

    private JComponent createSelectMcVersionComponent() {
        this.jmcVersion = new JComboBox();
        this.jmcVersion.setEnabled(false);
        this.jmcVersion.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1 || !RemapperGUI.this.jmcVersion.isEnabled()) {
                    return;
                }
                RemapperGUI.this.mcVersion = (String)RemapperGUI.this.jmcVersion.getSelectedItem();
                RemapperGUI.this.updateGuiState();
            }
        });
        return this.jmcVersion;
    }

    private JComponent createOldMappingsSelection() {
        this.joldMapping = new JComboBox();
        this.joldMapping.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1 || !RemapperGUI.this.joldMapping.isEnabled()) {
                    return;
                }
                RemapperGUI.this.oldMapping = (String)RemapperGUI.this.joldMapping.getSelectedItem();
                RemapperGUI.this.updateGuiState();
            }
        });
        this.joldMapping.setEnabled(false);
        return this.joldMapping;
    }

    private JComponent createDownloadOldButton() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.jDownloadOld = new JButton("Download");
        this.jDownloadOld.setEnabled(false);
        this.jDownloadOld.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MappingDownloader.needsDownload(RemapperGUI.this.mcVersion, RemapperGUI.this.oldMapping, RemapperGUI.this.cacheDir)) {
                    RemapperGUI.this.setStatus("Downloading " + RemapperGUI.this.oldMapping + " for " + RemapperGUI.this.mcVersion, Color.BLACK).run();
                    MappingDownloader.download(RemapperGUI.this.mcVersion, RemapperGUI.this.oldMapping, RemapperGUI.this.cacheDir, new Runnable(){

                        @Override
                        public void run() {
                            RemapperGUI.this.setStatus("Download Complete!", Color.BLACK).run();
                            RemapperGUI.this.updateGuiState();
                        }
                    });
                }
                RemapperGUI.this.jDownloadOld.setEnabled(false);
            }
        });
        panel.add((Component)this.jDownloadOld, "East");
        return panel;
    }

    private JComponent createMappingsSelectionRight() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel cacheDirLabel = this.makeLabel("Cache Dir: ");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weighty = 0.0;
        constraints.weightx = 0.0;
        panel.add((Component)cacheDirLabel, constraints);
        JComponent cacheDirBrowse = this.createBrowseBox(15, new IBrowseListener(){

            @Override
            public File getValue() {
                return RemapperGUI.this.cacheDir;
            }

            @Override
            public void setValue(File value) {
                RemapperGUI.this.cacheDir = value;
            }
        });
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.fill = 2;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.weighty = 0.0;
        constraints.weightx = 1.0;
        panel.add((Component)cacheDirBrowse, constraints);
        JLabel newMappingsLabel = this.makeLabel("New:");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.fill = 2;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weighty = 0.0;
        constraints.weightx = 0.0;
        panel.add((Component)newMappingsLabel, constraints);
        JComponent newMappingSelection = this.createNewMappingsSelection();
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.fill = 2;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.weighty = 0.0;
        constraints.weightx = 1.0;
        panel.add((Component)newMappingSelection, constraints);
        JComponent downloadButton = this.createDownloadButton();
        constraints.gridx = 2;
        constraints.gridy = 2;
        constraints.fill = 2;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.weighty = 0.0;
        constraints.weightx = 0.0;
        panel.add((Component)downloadButton, constraints);
        JComponent startRemapButton = this.createRemapButton();
        constraints.gridx = 2;
        constraints.gridy = 3;
        constraints.fill = 2;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.weighty = 0.0;
        constraints.weightx = 0.0;
        panel.add((Component)startRemapButton, constraints);
        return panel;
    }

    private JComponent createNewMappingsSelection() {
        this.jnewMapping = new JComboBox();
        this.jnewMapping.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1 || !RemapperGUI.this.jnewMapping.isEnabled()) {
                    return;
                }
                RemapperGUI.this.newMapping = (String)RemapperGUI.this.jnewMapping.getSelectedItem();
                RemapperGUI.this.updateGuiState();
            }
        });
        this.jnewMapping.setEnabled(false);
        return this.jnewMapping;
    }

    private JComponent createDownloadButton() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.jDownloadNew = new JButton("Download");
        this.jDownloadNew.setEnabled(false);
        this.jDownloadNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MappingDownloader.needsDownload(RemapperGUI.this.mcVersion, RemapperGUI.this.newMapping, RemapperGUI.this.cacheDir)) {
                    RemapperGUI.this.setStatus("Downloading " + RemapperGUI.this.newMapping + " for " + RemapperGUI.this.mcVersion, Color.BLACK).run();
                    MappingDownloader.download(RemapperGUI.this.mcVersion, RemapperGUI.this.newMapping, RemapperGUI.this.cacheDir, new Runnable(){

                        @Override
                        public void run() {
                            RemapperGUI.this.setStatus("Download Complete!", Color.BLACK).run();
                            RemapperGUI.this.updateGuiState();
                        }
                    });
                }
                RemapperGUI.this.jDownloadNew.setEnabled(false);
            }
        });
        panel.add((Component)this.jDownloadNew, "East");
        return panel;
    }

    private JComponent createRemapButton() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.btnRemapMod = new JButton("Start Remap");
        this.btnRemapMod.setEnabled(false);
        this.btnRemapMod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemapperTask.runRemapMod(RemapperGUI.this.deps, RemapperGUI.this.srcs, RemapperGUI.this.mcVersion, RemapperGUI.this.oldMapping, RemapperGUI.this.newMapping, RemapperGUI.this.cacheDir, new RemapperTask.IProgressListener(){

                    @Override
                    public void writeLine(String line) {
                        RemapperGUI.this.setStatus(line, Color.BLACK).run();
                    }
                });
            }
        });
        panel.add((Component)this.btnRemapMod, "East");
        return panel;
    }

    private void updateMCVersionList() {
        if (MappingDownloader.mappings.size() <= 0) {
            return;
        }
        this.jmcVersion.setEnabled(false);
        this.jmcVersion.removeAllItems();
        for (String version : MappingDownloader.mappings.keySet()) {
            this.jmcVersion.addItem(version);
        }
        if (((DefaultComboBoxModel)this.jmcVersion.getModel()).getIndexOf(this.mcVersion) == -1) {
            this.jmcVersion.addItem(this.mcVersion);
        }
        this.jmcVersion.setSelectedItem(this.mcVersion);
        this.jmcVersion.setEnabled(true);
    }

    private void updateOldMappings() {
        this.joldMapping.setEnabled(false);
        this.joldMapping.removeAllItems();
        this.joldMapping.addItem("SRG");
        if (MappingDownloader.mappings.containsKey(this.mcVersion)) {
            for (String mapping : MappingDownloader.mappings.get(this.mcVersion)) {
                this.joldMapping.addItem(mapping);
            }
        }
        if (((DefaultComboBoxModel)this.joldMapping.getModel()).getIndexOf(this.oldMapping) == -1) {
            this.joldMapping.addItem(this.oldMapping);
        }
        this.joldMapping.setSelectedItem(this.oldMapping);
        this.joldMapping.setEnabled(true);
    }

    private void updateNewMappings() {
        this.jnewMapping.setEnabled(false);
        this.jnewMapping.removeAllItems();
        this.jnewMapping.addItem("SRG");
        if (MappingDownloader.mappings.containsKey(this.mcVersion)) {
            for (String mapping : MappingDownloader.mappings.get(this.mcVersion)) {
                if (this.newMapping.equals("UNLOADED")) {
                    this.newMapping = mapping;
                }
                this.jnewMapping.addItem(mapping);
            }
        }
        if (((DefaultComboBoxModel)this.jnewMapping.getModel()).getIndexOf(this.newMapping) == -1) {
            this.jnewMapping.addItem(this.newMapping);
        }
        this.jnewMapping.setSelectedItem(this.newMapping);
        this.jnewMapping.setEnabled(true);
    }

    void updateGuiState() {
        for (Runnable r : this.changeListeners) {
            r.run();
        }
        if (!new File(this.targetDir, "build.gradle").exists()) {
            this.status.setText("build.gradle missing in taget dir!");
            this.status.setForeground(Color.RED);
            this.btnGetModInfo.setEnabled(false);
        } else if (this.buildFailed) {
            this.status.setText("gradle task failed!");
            this.status.setForeground(Color.RED);
            this.btnGetModInfo.setEnabled(false);
        } else {
            this.status.setText("build.gradle found:");
            this.status.setForeground(Color.YELLOW);
            this.btnGetModInfo.setEnabled(true);
        }
        this.updateMCVersionList();
        this.updateOldMappings();
        this.updateNewMappings();
        this.jDownloadOld.setEnabled(MappingDownloader.needsDownload(this.mcVersion, this.oldMapping, this.cacheDir));
        this.jDownloadNew.setEnabled(MappingDownloader.needsDownload(this.mcVersion, this.newMapping, this.cacheDir));
        this.btnRemapMod.setEnabled(!this.jDownloadOld.isEnabled() && !this.jDownloadNew.isEnabled() && this.deps.size() > 0 && this.srcs.size() > 0);
    }

    Runnable setStatus(final String line, final Color color) {
        return new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RemapperGUI.this.status.setText(line);
                        RemapperGUI.this.status.setForeground(color);
                    }
                });
            }
        };
    }

    private JLabel makeLabel(String text) {
        JLabel ret = new JLabel(text);
        ret.setAlignmentX(0.0f);
        return ret;
    }

    private JComponent createBrowseBox(int columns, final IBrowseListener listener) {
        final JTextField text = new JTextField();
        text.getDocument().addDocumentListener(new DocChangeListener(text){

            @Override
            protected void update() {
                File f;
                File file = f = text.getText() == null ? new File(".") : new File(text.getText());
                if (f.exists() && !listener.getValue().equals(f)) {
                    listener.setValue(f);
                    RemapperGUI.this.updateGuiState();
                }
            }
        });
        JButton browse = new JButton("...");
        browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(1);
                chooser.setFileHidingEnabled(false);
                chooser.ensureFileIsVisible(RemapperGUI.this.targetDir);
                chooser.setSelectedFile(RemapperGUI.this.targetDir);
                int response = chooser.showOpenDialog(RemapperGUI.this.mainFrame);
                switch (response) {
                    case 0: {
                        File t = chooser.getSelectedFile();
                        if (listener.getValue().equals(t)) break;
                        listener.setValue(t);
                        RemapperGUI.this.updateGuiState();
                        break;
                    }
                }
            }
        });
        this.changeListeners.add(new Runnable(){

            @Override
            public void run() {
                if (!listener.getValue().toString().equals(text.getText())) {
                    text.setText(listener.getValue().toString());
                }
            }
        });
        Box ret = Box.createHorizontalBox();
        ret.add(text);
        ret.add(browse);
        return ret;
    }

    private static interface IBrowseListener {
        public File getValue();

        public void setValue(File var1);
    }

    private static abstract class DocChangeListener
    implements DocumentListener {
        private JTextField field;

        public DocChangeListener(JTextField field) {
            this.field = field;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        protected abstract void update();
    }

    private static class FileListRenderer
    implements ListCellRenderer<File> {
        private JLabel label = new JLabelMax("", 2);

        private FileListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends File> list, File value, int index, boolean isSelected, boolean cellHasFocus) {
            this.label.setText(value.getName());
            return this.label;
        }
    }

    static class ListModel<T>
    extends AbstractListModel<T>
    implements List<T> {
        private static final long serialVersionUID = -8633567737555564475L;
        private List<T> list = Lists.newArrayList();

        ListModel() {
        }

        @Override
        public int getSize() {
            return this.list.size();
        }

        @Override
        public T getElementAt(int index) {
            return this.list.get(index);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        @Override
        public Iterator<T> iterator() {
            return this.list.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.list.toArray();
        }

        @Override
        public <R> R[] toArray(R[] a) {
            return this.list.toArray(a);
        }

        @Override
        public boolean add(T e) {
            boolean ret = this.list.add(e);
            this.changed();
            return ret;
        }

        @Override
        public boolean remove(Object o) {
            boolean ret = this.list.remove(o);
            this.changed();
            return ret;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.list.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            boolean ret = this.list.addAll(c);
            this.changed();
            return ret;
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            boolean ret = this.list.addAll(index, c);
            this.changed();
            return ret;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean ret = this.list.removeAll(c);
            this.changed();
            return ret;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            boolean ret = this.list.retainAll(c);
            this.changed();
            return ret;
        }

        @Override
        public void clear() {
            this.list.clear();
            this.changed();
        }

        @Override
        public T get(int index) {
            return this.list.get(index);
        }

        @Override
        public T set(int index, T element) {
            T ret = this.list.set(index, element);
            this.changed();
            return ret;
        }

        @Override
        public void add(int index, T element) {
            this.list.add(index, element);
        }

        @Override
        public T remove(int index) {
            T ret = this.list.remove(index);
            this.changed();
            return ret;
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        @Override
        public ListIterator<T> listIterator() {
            return this.list.listIterator();
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            return this.list.listIterator(index);
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            return this.list.subList(fromIndex, toIndex);
        }

        private void changed() {
            this.fireContentsChanged(this, 0, this.list.size());
        }
    }

    private static class JLabelMax
    extends JLabel {
        private static final long serialVersionUID = 1L;

        public JLabelMax(String text, int horizontalAlignment) {
            super(text, horizontalAlignment);
            this.setAlignmentX(0.5f);
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension ret = super.getMaximumSize();
            ret.width = Integer.MAX_VALUE;
            return ret;
        }
    }
}

