/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.remapper;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class MappingDownloader
implements Runnable {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static Map<String, List<String>> mappings = Maps.newLinkedHashMap();
    private Runnable callback;

    public static void downloadMappingList(Runnable callback) {
        new Thread(new MappingDownloader(callback)).run();
    }

    private MappingDownloader(Runnable callback) {
        this.callback = callback;
    }

    private void loadCache() {
        File cache = new File("./mappings.json");
        if (!cache.exists()) {
            return;
        }
        try {
            this.loadJson(Files.toString((File)cache, (Charset)Charsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void download() {
        File cache = new File("./mappings.json");
        try {
            URLConnection con = new URL("http://export.mcpbot.bspk.rs/versions.json").openConnection();
            String data = CharStreams.toString((Readable)new InputStreamReader(con.getInputStream()));
            JsonObject obj = new JsonParser().parse(data).getAsJsonObject();
            Files.write((CharSequence)GSON.toJson((JsonElement)obj), (File)cache, (Charset)Charsets.UTF_8);
            this.loadJson(data);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadJson(String data) {
        try {
            Map json = (Map)GSON.fromJson(data, new TypeToken<Map<String, Map<String, int[]>>>(){}.getType());
            mappings.clear();
            for (String mcver : json.keySet()) {
                Map values = (Map)json.get(mcver);
                ArrayList tmp = Lists.newArrayList();
                mappings.put(mcver, tmp);
                for (String channel : values.keySet()) {
                    for (int id : (int[])values.get(channel)) {
                        tmp.add(channel + "_" + id);
                    }
                }
            }
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        this.loadCache();
        this.download();
        this.callback.run();
    }

    public static boolean needsDownload(String mcVersion, String mapping, File cacheDir) {
        if ("UNLOADED".equals(mapping)) {
            return false;
        }
        if (!(MappingDownloader.getMcp(mcVersion, cacheDir, "joined.srg").exists() && MappingDownloader.getMcp(mcVersion, cacheDir, "joined.exc").exists() && MappingDownloader.getMcp(mcVersion, cacheDir, "static_methods.txt").exists())) {
            return true;
        }
        for (File f : MappingDownloader.getCsvs(mapping, cacheDir)) {
            if (f.exists()) continue;
            return true;
        }
        return false;
    }

    public static URL getMaven(String org, String artifact, String version) {
        return MappingDownloader.getMaven(org, artifact, version, null, "jar");
    }

    public static URL getMaven(String org, String artifact, String version, String classifier, String ext) {
        try {
            return new URL("http://files.minecraftforge.net/maven/" + org.replace('.', '/') + "/" + artifact + "/" + version + "/" + artifact + "-" + version + (classifier == null ? "" : "-" + classifier) + "." + ext);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File getMcp(String mcVersion, File cacheDir, String file) {
        return new File(cacheDir, "de/oceanlabs/mcp/mcp/" + mcVersion + "/" + file);
    }

    public static File[] getCsvs(String mapping, File cacheDir) {
        if ("SRG".equals(mapping)) {
            return new File[0];
        }
        String channel = mapping = mapping.replace("_nodoc", "");
        String version = mapping;
        if (mapping.indexOf(95) != -1) {
            channel = mapping.substring(0, mapping.lastIndexOf(95));
            version = mapping.substring(mapping.lastIndexOf(95) + 1);
        }
        File base = new File(cacheDir, "de/oceanlabs/mcp/mcp_" + channel + "_nodoc/" + version);
        return new File[]{new File(base, "fields.csv"), new File(base, "methods.csv"), new File(base, "params.csv")};
    }

    public static void download(final String mcVersion, final String mapping, final File cacheDir, final Runnable callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (!(MappingDownloader.getMcp(mcVersion, cacheDir, "joined.srg").exists() && MappingDownloader.getMcp(mcVersion, cacheDir, "joined.exc").exists() && MappingDownloader.getMcp(mcVersion, cacheDir, "static_methods.txt").exists())) {
                    URL maven = MappingDownloader.getMaven("de.oceanlabs.mcp", "mcp", mcVersion, "srg", "zip");
                    File base = MappingDownloader.getMcp(mcVersion, cacheDir, "");
                    MappingDownloader.downloadZip(base, maven);
                }
                String tmp = mapping.replace("_nodoc", "");
                String channel = tmp.substring(0, tmp.lastIndexOf(95));
                String version = tmp.substring(tmp.lastIndexOf(95) + 1);
                for (File f : MappingDownloader.getCsvs(mapping, cacheDir)) {
                    if (f.exists()) continue;
                    String mavenVer = mcVersion;
                    for (String key : mappings.keySet()) {
                        if (!mappings.get(key).contains(channel + "_" + version)) continue;
                        mavenVer = key;
                        break;
                    }
                    URL maven = MappingDownloader.getMaven("de.oceanlabs.mcp", "mcp_" + channel + "_nodoc", version + "-" + mavenVer, null, "zip");
                    MappingDownloader.downloadZip(f.getParentFile(), maven);
                    break;
                }
                if (callback != null) {
                    callback.run();
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadZip(File cacheDir, URL url) {
        InputStream is = null;
        FileOutputStream fos = null;
        System.out.println("Downloading: " + url);
        System.out.println("To:          " + cacheDir.getAbsolutePath());
        try {
            is = url.openStream();
            ZipInputStream zis = new ZipInputStream(is);
            ZipEntry entry = null;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                File cache = new File(cacheDir, entry.getName());
                if (!cache.getParentFile().exists()) {
                    cache.getParentFile().mkdirs();
                }
                fos = new FileOutputStream(cache);
                ByteStreams.copy((InputStream)zis, (OutputStream)fos);
                fos.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

