/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.remapper;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.List;
import javax.swing.JOptionPane;
import net.minecraftforge.remapper.RemapperGUI;

class GatherModInfo
implements ActionListener,
Runnable {
    private final RemapperGUI remapperGUI;

    GatherModInfo(RemapperGUI remapperGUI) {
        this.remapperGUI = remapperGUI;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new Thread(this).start();
    }

    @Override
    public void run() {
        File dir = this.remapperGUI.targetDir;
        if (dir == null || !new File(dir, "build.gradle").exists()) {
            JOptionPane.showMessageDialog(null, "You must first select a directory that contains a build.gradle file", "ERROR", 0);
            return;
        }
        try {
            String[] lines;
            File gradlew = this.getGradleWrapper(dir);
            if (gradlew == null) {
                JOptionPane.showMessageDialog(null, "This setup must contain the gradle wrapper (gradlew.bat on windows, gradlew or gradlew.sh otherwise)! So we can run a build and gather information.", "ERROR", 0);
                return;
            }
            this.println("Executing gradle build this may take some time!");
            File temp_build = new File(dir, "REMAP_MOD_TEMP.gradle");
            FileOutputStream fos = new FileOutputStream(temp_build);
            Files.copy((File)new File(dir, "build.gradle"), (OutputStream)fos);
            for (String line : lines = new String[]{"task remapGetInfo << {", "   for (File f : sourceSets.main.compileClasspath)", "       println 'DEP: ' + f.getPath()", "   println 'DEP: ' + jar.archivePath", "   println 'MAPPING: ' + minecraft.mappings", "   println 'MINECRAFT: ' + minecraft.version", "   for (File f : sourceSets.main.java.srcDirs)", "       println 'SOURCE: ' + f.getPath()", "   println 'CACHE: ' + new File(project.getGradle().getGradleUserHomeDir(), '/caches/minecraft/').getAbsolutePath()", "}", "remapGetInfo.dependsOn('setupDevWorkspace', 'build')"}) {
                fos.write(line.getBytes());
                fos.write(10);
            }
            fos.close();
            this.remapperGUI.buildFailed = false;
            this.remapperGUI.deps.clear();
            this.remapperGUI.srcs.clear();
            Splitter SPLITTER = Splitter.on((String)": ").limit(2);
            ProcessBuilder pb = new ProcessBuilder(gradlew.getPath(), "--build-file", "REMAP_MOD_TEMP.gradle", "remapGetInfo");
            pb.directory(dir);
            Process p = pb.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            String line = null;
            while ((line = br.readLine()) != null) {
                List pts = SPLITTER.splitToList((CharSequence)line);
                if (pts.size() < 2) continue;
                if (((String)pts.get(0)).equals("DEP")) {
                    this.println("DEPENDANCY: " + (String)pts.get(1));
                    this.remapperGUI.deps.add(new File((String)pts.get(1)));
                    continue;
                }
                if (((String)pts.get(0)).equals("SOURCE")) {
                    this.println(line);
                    this.remapperGUI.srcs.add(new File((String)pts.get(1)));
                    continue;
                }
                if (((String)pts.get(0)).equals("MINECRAFT")) {
                    this.println(line);
                    this.remapperGUI.mcVersion = (String)pts.get(1);
                    this.remapperGUI.updateGuiState();
                    continue;
                }
                if (((String)pts.get(0)).equals("MAPPING")) {
                    this.println(line);
                    this.remapperGUI.oldMapping = (String)pts.get(1);
                    this.remapperGUI.updateGuiState();
                    continue;
                }
                if (!((String)pts.get(0)).equals("CACHE")) continue;
                this.println(line);
                this.remapperGUI.cacheDir = new File((String)pts.get(1));
                this.remapperGUI.updateGuiState();
            }
            while ((line = err.readLine()) != null) {
                if (!line.startsWith("BUILD FAILED") && !line.startsWith("FAILURE")) continue;
                this.remapperGUI.buildFailed = true;
                this.remapperGUI.updateGuiState();
                break;
            }
            if (temp_build.exists()) {
                temp_build.delete();
            }
            if (!this.remapperGUI.buildFailed) {
                this.println("Gradle Build finished");
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private File getGradleWrapper(File dir) {
        for (String filename : this.getPossibleGradleWrapperFiles()) {
            if (!new File(dir, filename).exists()) continue;
            return new File(dir, filename);
        }
        return null;
    }

    private List<String> getPossibleGradleWrapperFiles() {
        if (RemapperGUI.IS_WINDOWS) {
            return Lists.newArrayList((Object[])new String[]{"gradlew.bat"});
        }
        return Lists.newArrayList((Object[])new String[]{"gradlew", "gradlew.sh"});
    }

    private void println(String line) {
        System.out.println(line);
        this.remapperGUI.setStatus(line, Color.BLACK).run();
    }
}

