/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mergetool;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.ValueConverter;
import net.minecraftforge.mergetool.AnnotationVersion;
import net.minecraftforge.mergetool.Merger;
import net.minecraftforge.mergetool.Stripper;

public class ConsoleMerger {
    private static final ValueConverter<AnnotationVersion> AnnotationReader = new ValueConverter<AnnotationVersion>(){

        @Override
        public AnnotationVersion convert(String value) {
            try {
                return AnnotationVersion.valueOf(value.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                return AnnotationVersion.fromVersion(value);
            }
        }

        @Override
        public Class<? extends AnnotationVersion> valueType() {
            return AnnotationVersion.class;
        }

        @Override
        public String valuePattern() {
            return null;
        }
    };

    public static void main(String[] args) {
        ArrayList<String> extra = new ArrayList<String>();
        Tasks task = null;
        for (int x = 0; x < args.length; ++x) {
            if ("--strip".equals(args[x])) {
                if (task != null) {
                    throw new IllegalArgumentException("Only one task supported at a time: " + (Object)((Object)task));
                }
                task = Tasks.STRIP;
                continue;
            }
            if ("--merge".equals(args[x])) {
                if (task != null) {
                    throw new IllegalArgumentException("Only one task supported at a time: " + (Object)((Object)task));
                }
                task = Tasks.MERGE;
                continue;
            }
            extra.add(args[x]);
        }
        if (task == Tasks.MERGE || task == null) {
            ConsoleMerger.merge(extra.toArray(new String[extra.size()]));
        } else if (task == Tasks.STRIP) {
            ConsoleMerger.strip(extra.toArray(new String[extra.size()]));
        }
    }

    private static void merge(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<File> client = parser.accepts("client").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec<File> server = parser.accepts("server").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec<File> merged = parser.accepts("output").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec<Boolean> inject = parser.accepts("inject").withOptionalArg().ofType(Boolean.class).defaultsTo(true, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<AnnotationVersion> anno = parser.accepts("ann").withOptionalArg().ofType(AnnotationVersion.class).withValuesConvertedBy(AnnotationReader).defaultsTo(AnnotationVersion.API, (AnnotationVersion[])new AnnotationVersion[0]);
        try {
            OptionSet options = parser.parse(args);
            File client_jar = options.valueOf(client);
            File server_jar = options.valueOf(server);
            File merged_jar = options.valueOf(merged);
            Merger merge = new Merger(client_jar, server_jar, merged_jar);
            if (merged_jar.exists() && !merged_jar.delete()) {
                System.out.println("Could not delete output file: " + merged_jar);
            }
            if (options.has(anno)) {
                merge.annotate(options.valueOf(anno), !options.has(inject) || options.valueOf(inject) != false);
            }
            try {
                merge.process();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (OptionException e) {
            System.out.println("Usage: ConsoleMerger --merge --client <ClientJar> --server <ServerJar> --output <MergedJar> [--ann CPW|NMF|API]");
            e.printStackTrace();
        }
    }

    private static void strip(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<File> input = parser.accepts("input").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec<File> output = parser.accepts("output").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec<File> data = parser.accepts("data").withRequiredArg().ofType(File.class).required();
        try {
            OptionSet options = parser.parse(args);
            File input_jar = options.valueOf(input).getAbsoluteFile();
            File output_jar = options.valueOf(output).getAbsoluteFile();
            try {
                System.out.println("Input:  " + input_jar);
                System.out.println("Output: " + output_jar);
                Stripper strip = new Stripper();
                for (File dataF : options.valuesOf(data)) {
                    System.out.println("Data:   " + dataF.getAbsoluteFile());
                    strip.loadData(dataF);
                }
                if (output_jar.exists() && !output_jar.delete()) {
                    System.out.println("Could not delete output file: " + output_jar);
                }
                strip.process(input_jar, output_jar);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (OptionException e) {
            System.out.println("Usage: ConsoleMerger --strip --input <InputJar> --output <OutputJar> --data <DataText>...");
            e.printStackTrace();
        }
    }

    private static enum Tasks {
        MERGE,
        STRIP;

    }
}

