/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mergetool;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.ValueConverter;
import net.minecraftforge.mergetool.AnnotationVersion;
import net.minecraftforge.mergetool.Merger;

public class ConsoleMerger {
    public static void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<File> client = parser.accepts("client").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec<File> server = parser.accepts("server").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec<File> merged = parser.accepts("output").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec<AnnotationVersion> anno = parser.accepts("ann").withOptionalArg().ofType(AnnotationVersion.class).withValuesConvertedBy(new ValueConverter<AnnotationVersion>(){

            @Override
            public AnnotationVersion convert(String value) {
                try {
                    return AnnotationVersion.valueOf(value.toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException e) {
                    return AnnotationVersion.fromVersion(value);
                }
            }

            @Override
            public Class<? extends AnnotationVersion> valueType() {
                return AnnotationVersion.class;
            }

            @Override
            public String valuePattern() {
                return null;
            }
        }).defaultsTo(AnnotationVersion.API, (AnnotationVersion[])new AnnotationVersion[0]);
        try {
            OptionSet options = parser.parse(args);
            File client_jar = options.valueOf(client);
            File server_jar = options.valueOf(server);
            File merged_jar = options.valueOf(merged);
            Merger merge = new Merger(client_jar, server_jar, merged_jar);
            if (merged_jar.exists() && !merged_jar.delete()) {
                System.out.println("Could not delete output file: " + merged_jar);
            }
            if (options.has(anno)) {
                merge.annotate(options.valueOf(anno));
            }
            try {
                merge.process();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (OptionException e) {
            System.out.println("Usage: ConsoleMerger --client <ClientJar> --server <ServerJar> --output <MergedJar> [--ann CPW|NMF|API]");
            e.printStackTrace();
        }
    }
}

