/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mergetool;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.mergetool.AnnotationVersion;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;

public class Merger {
    private static final boolean DEBUG = false;
    private final File client;
    private final File server;
    private final File merged;
    private AnnotationVersion annotation = null;
    private boolean annotationInject = true;
    private FieldName FIELD = new FieldName();
    private MethodDesc METHOD = new MethodDesc();
    private HashSet<String> whitelist = new HashSet();
    private boolean copyData = false;
    private boolean keepMeta = false;

    public Merger(File client, File server, File merged) {
        this.client = client;
        this.server = server;
        this.merged = merged;
    }

    public Merger annotate(AnnotationVersion ano, boolean inject) {
        this.annotation = ano;
        this.annotationInject = inject;
        return this;
    }

    public Merger whitelist(String file) {
        this.whitelist.add(file);
        return this;
    }

    public Merger keepData() {
        this.copyData = true;
        return this;
    }

    public Merger skipData() {
        this.copyData = false;
        return this;
    }

    public Merger keepMeta() {
        this.keepMeta = true;
        return this;
    }

    public Merger skipMeta() {
        this.keepMeta = false;
        return this;
    }

    public void process() throws IOException {
        try (ZipFile cInJar = new ZipFile(this.client);
             ZipFile sInJar = new ZipFile(this.server);
             ZipOutputStream outJar = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.merged)));){
            HashSet<String> added = new HashSet<String>();
            Map<String, ZipEntry> cClasses = this.getClassEntries(cInJar, outJar, added);
            Map<String, ZipEntry> sClasses = this.getClassEntries(sInJar, outJar, null);
            for (Map.Entry<String, ZipEntry> entry : cClasses.entrySet()) {
                String name = entry.getKey();
                if (!this.whitelist.isEmpty() && !this.whitelist.contains(name)) continue;
                ZipEntry cEntry = entry.getValue();
                ZipEntry sEntry = sClasses.get(name);
                if (sEntry == null) {
                    this.copyClass(cInJar, cEntry, outJar, true);
                    continue;
                }
                sClasses.remove(name);
                byte[] cData = this.readEntry(cInJar, entry.getValue());
                byte[] sData = this.readEntry(sInJar, sEntry);
                byte[] data = this.processClass(cData, sData);
                outJar.putNextEntry(this.getNewEntry(cEntry.getName()));
                outJar.write(data);
            }
            for (Map.Entry<String, ZipEntry> entry : sClasses.entrySet()) {
                if (!this.whitelist.isEmpty() && !this.whitelist.contains(entry.getKey())) continue;
                this.copyClass(sInJar, entry.getValue(), outJar, false);
            }
            if (this.annotation != null && this.annotationInject) {
                for (String cls : this.annotation.getClasses()) {
                    byte[] data = this.getResourceBytes(cls + ".class");
                    outJar.putNextEntry(this.getNewEntry(cls + ".class"));
                    outJar.write(data);
                }
            }
        }
    }

    private ZipEntry getNewEntry(String name) {
        ZipEntry ret = new ZipEntry(name);
        ret.setTime(630662400000L);
        return ret;
    }

    private void copyClass(ZipFile inJar, ZipEntry entry, ZipOutputStream outJar, boolean isClientOnly) throws IOException {
        ClassReader reader = new ClassReader(this.readEntry(inJar, entry));
        ClassNode classNode = new ClassNode();
        reader.accept(classNode, 0);
        if (this.annotation != null) {
            this.annotation.add(classNode, isClientOnly);
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept(writer);
        byte[] data = writer.toByteArray();
        outJar.putNextEntry(this.getNewEntry(entry.getName()));
        outJar.write(data);
    }

    private Map<String, ZipEntry> getClassEntries(ZipFile inFile, ZipOutputStream output, Set<String> added) throws IOException {
        Hashtable<String, ZipEntry> ret = new Hashtable<String, ZipEntry>();
        for (ZipEntry zipEntry : Collections.list(inFile.entries())) {
            String entryName = zipEntry.getName();
            if (!zipEntry.isDirectory() && entryName.endsWith(".class") && !entryName.startsWith(".")) {
                ret.put(entryName.replace(".class", ""), zipEntry);
                continue;
            }
            if (!this.copyData || added == null || added.contains(entryName) || !this.keepMeta && entryName.startsWith("META-INF")) continue;
            if (zipEntry.isDirectory()) {
                added.add(entryName);
                continue;
            }
            output.putNextEntry(this.getNewEntry(entryName));
            output.write(this.readEntry(inFile, zipEntry));
            added.add(entryName);
        }
        return ret;
    }

    private byte[] readEntry(ZipFile inFile, ZipEntry entry) throws IOException {
        return this.readFully(inFile.getInputStream(entry));
    }

    private byte[] readFully(InputStream stream) throws IOException {
        int len;
        byte[] data = new byte[4096];
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        do {
            if ((len = stream.read(data)) <= 0) continue;
            buf.write(data, 0, len);
        } while (len != -1);
        return buf.toByteArray();
    }

    private byte[] processClass(byte[] cIn, byte[] sIn) {
        ClassNode cClassNode = this.getClassNode(cIn);
        ClassNode sClassNode = this.getClassNode(sIn);
        this.processFields(cClassNode, sClassNode);
        this.processMethods(cClassNode, sClassNode);
        this.processInners(cClassNode, sClassNode);
        ClassWriter writer = new ClassWriter(1);
        cClassNode.accept(writer);
        return writer.toByteArray();
    }

    private boolean innerMatches(InnerClassNode o, InnerClassNode o2) {
        return this.equals(o.innerName, o2.innerName) && this.equals(o.name, o2.name) && this.equals(o.outerName, o2.outerName);
    }

    private boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : (o2 == null ? false : o1.equals(o2));
    }

    private void processInners(ClassNode cClass, ClassNode sClass) {
        List<InnerClassNode> cIners = cClass.innerClasses;
        List<InnerClassNode> sIners = sClass.innerClasses;
        for (InnerClassNode n : cIners) {
            if (sIners.stream().anyMatch(e -> this.innerMatches((InnerClassNode)e, n))) continue;
            sIners.add(n);
        }
        for (InnerClassNode n : sIners) {
            if (cIners.stream().anyMatch(e -> this.innerMatches((InnerClassNode)e, n))) continue;
            cIners.add(n);
        }
    }

    private ClassNode getClassNode(byte[] data) {
        ClassReader reader = new ClassReader(data);
        ClassNode classNode = new ClassNode();
        reader.accept(classNode, 0);
        return classNode;
    }

    private void processFields(ClassNode cClass, ClassNode sClass) {
        List<FieldNode> cFields = cClass.fields;
        List<FieldNode> sFields = sClass.fields;
        String cFieldsStr = cFields.stream().map(e -> e.name).collect(Collectors.joining(", "));
        String sFieldsStr = sFields.stream().map(e -> e.name).collect(Collectors.joining(", "));
        int serverFieldIdx = 0;
        for (int clientFieldIdx = 0; clientFieldIdx < cFields.size(); ++clientFieldIdx) {
            FieldNode clientField = cFields.get(clientFieldIdx);
            if (serverFieldIdx < sFields.size()) {
                FieldNode serverField = sFields.get(serverFieldIdx);
                if (!clientField.name.equals(serverField.name)) {
                    boolean foundServerField = false;
                    for (int serverFieldSearchIdx = serverFieldIdx + 1; serverFieldSearchIdx < sFields.size(); ++serverFieldSearchIdx) {
                        if (!clientField.name.equals(sFields.get((int)serverFieldSearchIdx).name)) continue;
                        foundServerField = true;
                        break;
                    }
                    if (foundServerField) {
                        boolean foundClientField = false;
                        for (int clientFieldSearchIdx = clientFieldIdx + 1; clientFieldSearchIdx < cFields.size(); ++clientFieldSearchIdx) {
                            if (!serverField.name.equals(cFields.get((int)clientFieldSearchIdx).name)) continue;
                            foundClientField = true;
                            break;
                        }
                        if (!foundClientField) {
                            this.FIELD.process(serverField, false);
                            cFields.add(clientFieldIdx, serverField);
                        }
                    } else {
                        this.FIELD.process(clientField, true);
                        sFields.add(serverFieldIdx, clientField);
                    }
                }
            } else {
                this.FIELD.process(clientField, true);
                sFields.add(serverFieldIdx, clientField);
            }
            ++serverFieldIdx;
        }
        if (sFields.size() != cFields.size()) {
            for (int x = cFields.size(); x < sFields.size(); ++x) {
                FieldNode sF = sFields.get(x);
                this.FIELD.process(sF, true);
                cFields.add(x++, sF);
            }
        }
    }

    private void processMethods(ClassNode cClass, ClassNode sClass) {
        String clientName;
        List<MethodNode> cMethods = cClass.methods;
        List<MethodNode> sMethods = sClass.methods;
        LinkedHashSet<MethodWrapper> allMethods = new LinkedHashSet<MethodWrapper>();
        int cPos = 0;
        int sPos = 0;
        int cLen = cMethods.size();
        int sLen = sMethods.size();
        String lastName = clientName = "";
        String serverName = "";
        block0: while (cPos < cLen || sPos < sLen) {
            MethodWrapper mw;
            while (sPos < sLen) {
                MethodNode sM = sMethods.get(sPos);
                serverName = sM.name;
                if (!serverName.equals(lastName) && cPos != cLen) break;
                mw = new MethodWrapper(sM);
                mw.server = true;
                allMethods.add(mw);
                if (++sPos < sLen) continue;
            }
            while (cPos < cLen) {
                MethodNode cM = cMethods.get(cPos);
                clientName = cM.name;
                lastName = clientName;
                if (!clientName.equals(lastName) && sPos != sLen) continue block0;
                mw = new MethodWrapper(cM);
                mw.client = true;
                allMethods.add(mw);
                if (++cPos < cLen) continue;
                continue block0;
            }
        }
        cMethods.clear();
        sMethods.clear();
        for (MethodWrapper mw : allMethods) {
            cMethods.add(mw.node);
            sMethods.add(mw.node);
            if (mw.server && mw.client) continue;
            this.METHOD.process(mw.node, mw.client);
        }
    }

    private byte[] getResourceBytes(String path) throws IOException {
        try (InputStream stream = Merger.class.getResourceAsStream("/" + path);){
            byte[] byArray = this.readFully(stream);
            return byArray;
        }
    }

    private class MethodWrapper {
        private MethodNode node;
        public boolean client;
        public boolean server;

        public MethodWrapper(MethodNode node) {
            this.node = node;
        }

        public boolean equals(Object obj) {
            boolean eq;
            if (obj == null || !(obj instanceof MethodWrapper)) {
                return false;
            }
            MethodWrapper mw = (MethodWrapper)obj;
            boolean bl = eq = Objects.equals(this.node.name, mw.node.name) && Objects.equals(this.node.desc, mw.node.desc);
            if (eq) {
                mw.client = this.client | mw.client;
                mw.server = this.server | mw.server;
                this.client |= mw.client;
                this.server |= mw.server;
            }
            return eq;
        }

        public int hashCode() {
            int ret = 1;
            ret = 31 * ret + (this.node.name == null ? 0 : this.node.name.hashCode());
            ret = 31 * ret + (this.node.desc == null ? 0 : this.node.desc.hashCode());
            return ret;
        }

        public String toString() {
            return "MethodWrapper[name=" + this.node.name + ",desc=" + this.node.desc + ",server=" + this.server + ",client=" + this.client + "]";
        }
    }

    private class MethodDesc
    implements Function<MethodNode, String>,
    MemberAnnotator<MethodNode>,
    Comparator<MethodNode> {
        private MethodDesc() {
        }

        @Override
        public String apply(MethodNode node) {
            return node == null ? "null" : node.name + node.desc;
        }

        @Override
        public MethodNode process(MethodNode node, boolean isClient) {
            if (Merger.this.annotation != null) {
                Merger.this.annotation.add(node, isClient);
            }
            return node;
        }

        private int findLine(MethodNode member) {
            for (int x = 0; x < member.instructions.size(); ++x) {
                AbstractInsnNode insn = member.instructions.get(x);
                if (!(insn instanceof LineNumberNode)) continue;
                return ((LineNumberNode)insn).line;
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public int compare(MethodNode a, MethodNode b) {
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return 1;
            }
            if (b == null) {
                return -1;
            }
            return this.findLine(a) - this.findLine(b);
        }
    }

    private class FieldName
    implements Function<FieldNode, String>,
    MemberAnnotator<FieldNode>,
    Comparator<FieldNode> {
        private FieldName() {
        }

        @Override
        public String apply(FieldNode in) {
            return in == null ? "null" : in.name;
        }

        @Override
        public FieldNode process(FieldNode field, boolean isClient) {
            if (Merger.this.annotation != null) {
                Merger.this.annotation.add(field, isClient);
            }
            return field;
        }

        @Override
        public int compare(FieldNode a, FieldNode b) {
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return 1;
            }
            if (b == null) {
                return -1;
            }
            return a.name.compareTo(b.name);
        }
    }

    private static interface MemberAnnotator<T> {
        public T process(T var1, boolean var2);
    }
}

