/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mappingverifier;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.mappingverifier.InheratanceMap;
import net.minecraftforge.mappingverifier.Main;
import net.minecraftforge.mappingverifier.MappingVerifier;
import net.minecraftforge.mappingverifier.SimpleVerifier;
import net.minecraftforge.srgutils.IMappingFile;

public class OverrideNames
extends SimpleVerifier {
    protected OverrideNames(MappingVerifier verifier) {
        super(verifier);
    }

    @Override
    public boolean process() {
        IMappingFile reverse;
        IMappingFile map;
        InheratanceMap inh = this.verifier.getInheratance();
        return this.checkNormal(inh, map = this.verifier.getMappings(), reverse = map.reverse()) && this.checkInterfaces(inh, map);
    }

    private boolean checkNormal(InheratanceMap inh, IMappingFile map, IMappingFile reverse) {
        return inh.getRead().sorted((o1, o2) -> o1.name.compareTo(o2.name)).map(cls -> {
            boolean success = true;
            Main.LOG.info("  Processing: " + map.remapClass(cls.name));
            IMappingFile.IClass info = map.getClass(cls.name);
            success &= ((Stream)cls.fields.values().stream().sequential()).sorted((o1, o2) -> o1.name.compareTo(o2.name)).filter(field -> (field.access & 8) == 0).map(entry -> {
                String newName = info.remapField(entry.name);
                return cls.getStack().stream().map(parent -> {
                    IMappingFile.IClass pinfo = reverse.getClass(map.remapClass(parent.name));
                    InheratanceMap.Node f = parent.fields.get(pinfo == null ? newName : pinfo.remapField(newName));
                    if (f != null && !InheratanceMap.Access.isPrivate(f.access)) {
                        this.error("    Shade: %s/%s %s/%s %s", cls.name, entry.name, pinfo.getOriginal(), f.name, newName);
                        return false;
                    }
                    return true;
                }).reduce(true, (a, b) -> a != false && b != false);
            }).reduce(true, (a, b) -> a != false && b != false).booleanValue();
            return success &= ((Stream)cls.methods.values().stream().sequential()).sorted((o1, o2) -> o1.name.equals(o2.name) ? o1.desc.compareTo(o2.desc) : o1.name.compareTo(o2.name)).filter(mt -> (mt.access & 8) == 0 && !mt.name.startsWith("<")).map(mt -> {
                IMappingFile.IClass clsI = map.getClass(cls.name);
                String newName = clsI.remapMethod(mt.name, mt.desc);
                String newSignature = map.remapDescriptor(mt.desc);
                return cls.getStack().stream().map(parent -> {
                    String mapped;
                    IMappingFile.IClass pinfo = map.getClass(parent.name);
                    IMappingFile.IClass rinfo = pinfo == null ? null : reverse.getClass(pinfo.getMapped());
                    String unmapped = rinfo == null ? newName : rinfo.remapMethod(newName, newSignature);
                    InheratanceMap.Node m = parent.methods.get(unmapped + mt.desc);
                    if (m != null) {
                        if (InheratanceMap.Access.isPrivate(m.access)) {
                            if (newName.startsWith("func_")) {
                                this.error("    BadOverride: %s/%s %s -> %s/%s %s -- %s", cls.name, mt.name, mt.desc, parent.name, unmapped, mt.desc, newName);
                                return false;
                            }
                        } else if (!mt.name.equals(unmapped)) {
                            this.error("    Shade: %s/%s %s/%s %s %s", cls.name, mt.name, parent.name, unmapped, mt.desc, newName);
                            return false;
                        }
                    }
                    if ((m = (InheratanceMap.Node)parent.methods.get(mt.name + mt.desc)) != null && !InheratanceMap.Access.isPrivate(m.access) && !newName.equals(mapped = pinfo.remapMethod(mt.name, mt.desc))) {
                        this.error("    Override: %s/%s %s -- %s -> %s", cls.name, mt.name, mt.desc, newName, mapped);
                        return false;
                    }
                    return true;
                }).reduce(true, (a, b) -> a != false && b != false);
            }).reduce(true, (a, b) -> a != false && b != false).booleanValue();
        }).reduce(true, (a, b) -> a != false && b != false);
    }

    private boolean checkInterfaces(InheratanceMap inh, IMappingFile map) {
        Map<String, Set> interfaces = inh.getRead().filter(e -> (e.getAccess() & 0x200) != 0).collect(Collectors.toMap(e -> e.name, e -> new HashSet()));
        inh.getRead().forEach(e -> e.interfaces.stream().map(i -> i.name).filter(i -> interfaces.containsKey(i)).forEach(i -> ((Set)interfaces.get(i)).add(e.name)));
        return interfaces.entrySet().stream().map(e -> {
            Main.LOG.info("  Processing Interface: " + map.remapClass((String)e.getKey()));
            HashSet fullStack = new HashSet((Collection)e.getValue());
            ((Set)e.getValue()).stream().map(inh::getClass).forEach(child -> child.getStack().stream().map(parent -> parent.name).forEach(fullStack::add));
            List stack = fullStack.stream().map(inh::getClass).collect(Collectors.toList());
            InheratanceMap.Class cls = inh.getClass((String)e.getKey());
            return ((Stream)cls.methods.values().stream().sequential()).sorted((o1, o2) -> o1.name.equals(o2.name) ? o1.desc.compareTo(o2.desc) : o1.name.compareTo(o2.name)).filter(mt -> (mt.access & 8) == 0 && !mt.name.startsWith("<")).map(mt -> {
                String newName = map.getClass(cls.name).remapMethod(mt.name, mt.desc);
                return stack.stream().map(parent -> {
                    String mapped;
                    IMappingFile.IClass pinfo = map.getClass(parent.name);
                    InheratanceMap.Method m = parent.getMethod(mt.name, mt.desc);
                    if (m != null && !InheratanceMap.Access.isPrivate(m.access) && !newName.equals(mapped = pinfo.remapMethod(mt.name, mt.desc))) {
                        this.error("    Override: %s/%s %s -- %s -> %s", parent.name, mt.name, mt.desc, mapped, newName);
                        return false;
                    }
                    return true;
                }).reduce(true, (a, b) -> a != false && b != false);
            }).reduce(true, (a, b) -> a != false && b != false);
        }).reduce(true, (a, b) -> a != false && b != false);
    }
}

