/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mappingverifier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.mappingverifier.InheratanceMap;
import net.minecraftforge.mappingverifier.MappingVerifier;
import net.minecraftforge.mappingverifier.SimpleVerifier;
import net.minecraftforge.srgutils.IMappingFile;

public class UniqueIDs
extends SimpleVerifier {
    protected UniqueIDs(MappingVerifier verifier) {
        super(verifier);
    }

    @Override
    public boolean process() {
        InheratanceMap inh = this.verifier.getInheratance();
        IMappingFile map = this.verifier.getMappings();
        HashMap claimed = new HashMap();
        HashMap signatures = new HashMap();
        Consumer<String[]> gather = entry -> {
            String idstr = entry[0].split("_")[1];
            if (idstr.matches("\\d+")) {
                claimed.computeIfAbsent(Integer.parseInt(idstr), k -> new HashSet()).add(entry[0]);
                signatures.computeIfAbsent(entry[0], k -> new HashSet()).add(Arrays.asList(Arrays.copyOfRange(entry, 1, ((String[])entry).length)));
            }
        };
        inh.getRead().forEach(cls -> {
            IMappingFile.IClass info = map.getClass(cls.name);
            cls.fields.values().stream().map(field -> new String[]{info.remapField(field.name), cls.name, field.name}).filter(entry -> entry[0].startsWith("field_") || entry[0].startsWith("f_")).forEach(gather);
            cls.methods.values().stream().map(method -> new String[]{info.remapMethod(method.name, method.desc), cls.name, method.name, method.desc}).filter(entry -> entry[0].startsWith("func_") || entry[0].startsWith("m_")).forEach(gather);
        });
        return claimed.entrySet().stream().filter(e -> ((Set)e.getValue()).size() > 1 || this.different((String)((Set)e.getValue()).iterator().next(), (Set)signatures.get(((Set)e.getValue()).iterator().next()), inh)).sorted((e1, e2) -> ((Integer)e1.getKey()).compareTo((Integer)e2.getKey())).map(entry -> {
            this.error("Duplicate ID: %s (%s)", ((Integer)entry.getKey()).toString(), ((Set)entry.getValue()).stream().sorted().collect(Collectors.joining(", ")));
            ((Set)entry.getValue()).stream().sorted().forEach(name -> {
                Set sigs = (Set)signatures.get(name);
                ArrayList fields = new ArrayList();
                HashMap methods = new HashMap();
                if (sigs != null) {
                    sigs.stream().forEach(pts -> {
                        if (pts.size() == 2) {
                            fields.add((String)pts.get(0) + '/' + (String)pts.get(1));
                        } else if (pts.size() == 1) {
                            int idx = ((String)pts.get(0)).indexOf(40);
                            String cls = ((String)pts.get(0)).substring(0, idx);
                            String desc = ((String)pts.get(0)).substring(idx);
                            String key = cls + "/<init>" + desc;
                            methods.put(key, methods.computeIfAbsent(key, k -> 0) + 1);
                        } else {
                            InheratanceMap.Class cls = inh.getClass((String)pts.get(0));
                            InheratanceMap.Method mtd = cls.getMethod((String)pts.get(1), (String)pts.get(2));
                            mtd.getRoots().forEach(root -> methods.put(root.getKey(), methods.computeIfAbsent(root.getKey(), k -> 0) + 1));
                        }
                    });
                }
                this.error("    %s (%s)", (String)name, Stream.concat(fields.stream(), methods.entrySet().stream().map(e -> (String)e.getKey() + '[' + e.getValue() + ']')).sorted().collect(Collectors.joining(", ")));
            });
            return false;
        }).reduce(true, (a, b) -> a != false && b != false);
    }

    private void merge(Set<String> methods, InheratanceMap inh) {
        HashMap chain = new HashMap();
        HashSet roots = new HashSet();
        inh.getRead().forEach(cls -> cls.methods.values().stream().filter(mtd -> mtd.getRoots().size() > 1).forEach(mtd -> {
            List overrides = mtd.getRoots().stream().map(InheratanceMap.Node::getKey).distinct().collect(Collectors.toList());
            String root = null;
            for (String o : overrides) {
                if (!roots.contains(o)) continue;
                overrides.remove(o);
                root = o;
                break;
            }
            if (root == null) {
                root = (String)overrides.remove(0);
            }
            roots.add(root);
            for (String o : overrides) {
                chain.put(o, root);
            }
        }));
        HashSet<String> ret = new HashSet<String>();
        for (String mtd : methods) {
            while (chain.containsKey(mtd)) {
                mtd = (String)chain.get(mtd);
            }
            ret.add(mtd);
        }
        methods.clear();
        methods.addAll(ret);
    }

    private boolean different(String id, Set<List<String>> entries, InheratanceMap inh) {
        if (entries == null || entries.stream().map(e -> e.stream().skip(1L).collect(Collectors.joining(" "))).distinct().count() == 1L) {
            return false;
        }
        if (entries.stream().mapToInt(List::size).distinct().count() != 1L) {
            return true;
        }
        if (entries.iterator().next().size() == 2) {
            return true;
        }
        HashSet<String> roots = new HashSet<String>();
        for (List<String> pts : entries) {
            InheratanceMap.Class cls = inh.getClass(pts.get(0));
            InheratanceMap.Method mtd = cls.getMethod(pts.get(1), pts.get(2));
            mtd.getRoots().forEach(root -> roots.add(root.getKey()));
        }
        if (roots.size() > 1) {
            this.merge(roots, inh);
        }
        return roots.size() > 1;
    }
}

