/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mappingverifier;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.mappingverifier.AccessLevels;
import net.minecraftforge.mappingverifier.IVerifier;
import net.minecraftforge.mappingverifier.InheratanceMap;
import net.minecraftforge.mappingverifier.Main;
import net.minecraftforge.mappingverifier.OverrideNames;
import net.minecraftforge.mappingverifier.UniqueIDs;
import net.minecraftforge.srgutils.IMappingFile;

public class MappingVerifier {
    private static Map<String, Function<MappingVerifier, IVerifier>> VERIFIERS = new HashMap<String, Function<MappingVerifier, IVerifier>>(){
        {
            this.put("accesslevels", AccessLevels::new);
            this.put("overridenames", OverrideNames::new);
            this.put("uniqueids", UniqueIDs::new);
        }
    };
    private IMappingFile map = null;
    private InheratanceMap inh = new InheratanceMap();
    private List<IVerifier> tasks = new ArrayList<IVerifier>();

    public void addDefaultTasks() {
        VERIFIERS.values().forEach(v -> this.tasks.add((IVerifier)v.apply(this)));
    }

    public void addTask(String name) {
        Function<MappingVerifier, IVerifier> sup = VERIFIERS.get(name.toLowerCase(Locale.ENGLISH));
        if (sup == null) {
            throw new IllegalArgumentException("Unknown task \"" + name + "\" Known: " + VERIFIERS.keySet().stream().collect(Collectors.joining(", ")));
        }
        this.tasks.add(sup.apply(this));
    }

    public void addTask(IVerifier task) {
        this.tasks.add(task);
    }

    public boolean verify() {
        this.inh.resolve();
        boolean valid = true;
        for (IVerifier v : this.tasks) {
            valid &= v.process();
        }
        return valid;
    }

    public List<IVerifier> getTasks() {
        return this.tasks;
    }

    public IMappingFile getMappings() {
        return this.map;
    }

    public InheratanceMap getInheratance() {
        return this.inh;
    }

    public void loadMap(File mapFile) throws IOException {
        this.map = IMappingFile.load((File)mapFile);
    }

    public void loadMap(InputStream mapStream) throws IOException {
        this.map = IMappingFile.load((InputStream)mapStream);
    }

    public void setMap(IMappingFile map) {
        this.map = map;
    }

    public void loadJar(File input) throws IOException {
        try (ZipFile zip = new ZipFile(input);){
            zip.stream().filter(e -> !e.isDirectory() && e.getName().endsWith(".class") && !e.getName().startsWith("META-INF/")).forEach(e -> {
                try {
                    Main.LOG.info("Loading: " + e.getName());
                    this.inh.processClass(zip.getInputStream((ZipEntry)e));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            });
        }
    }
}

