/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mappingverifier;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class InheratanceMap {
    private static final Handle LAMBDA_METAFACTORY = new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false);
    private static final Handle LAMBDA_ALTMETAFACTORY = new Handle(6, "java/lang/invoke/LambdaMetafactory", "altMetafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;", false);
    private Map<String, Class> classes = new HashMap<String, Class>();
    private Map<String, ClassNode> nodes = new HashMap<String, ClassNode>();

    public void processClass(InputStream data) throws IOException {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(data);
        reader.accept((ClassVisitor)node, 0);
        Class cls = this.getClass(node.name);
        cls.parent = this.getClass(node.superName);
        cls.wasRead = true;
        cls.access = node.access;
        for (String intf : node.interfaces) {
            cls.interfaces.add(this.getClass(intf));
        }
        for (FieldNode n : node.fields) {
            cls.fields.put(n.name, new Field(cls, n));
        }
        HashSet<String> lambdas = new HashSet<String>();
        for (MethodNode mtd : node.methods) {
            for (AbstractInsnNode asn : () -> mtd.instructions.iterator()) {
                Handle target;
                if (!(asn instanceof InvokeDynamicInsnNode) || (target = this.getLambdaTarget((InvokeDynamicInsnNode)asn)) == null) continue;
                lambdas.add(target.getOwner() + '/' + target.getName() + target.getDesc());
            }
        }
        for (MethodNode n : node.methods) {
            cls.methods.put(n.name + n.desc, new Method(cls, n, lambdas.contains(node.name + '/' + n.name + n.desc)));
        }
        for (Method m : cls.methods.values()) {
            Method target;
            if (!m.isBouncer() || (target = cls.getMethod(m.bounce.name, m.bounce.desc)) == null) continue;
            target.bouncers.add(m);
        }
        this.nodes.put(node.name, node);
    }

    private Handle getLambdaTarget(InvokeDynamicInsnNode idn) {
        if (LAMBDA_METAFACTORY.equals((Object)idn.bsm) && idn.bsmArgs != null && idn.bsmArgs.length == 3 && idn.bsmArgs[1] instanceof Handle) {
            return (Handle)idn.bsmArgs[1];
        }
        if (LAMBDA_ALTMETAFACTORY.equals((Object)idn.bsm) && idn.bsmArgs != null && idn.bsmArgs.length == 5 && idn.bsmArgs[1] instanceof Handle) {
            return (Handle)idn.bsmArgs[1];
        }
        return null;
    }

    public Class getClass(String name) {
        return this.classes.computeIfAbsent(name, k -> new Class(name));
    }

    public ClassNode getNode(String name) {
        return this.nodes.get(name);
    }

    public Stream<Class> getRead() {
        return this.classes.values().stream().filter(e -> ((Class)e).wasRead);
    }

    public void resolve() {
        this.classes.values().stream().forEach(this::resolve);
    }

    private void resolve(Class cls) {
        if (cls == null || cls.resolved) {
            return;
        }
        this.resolve(cls.getParent());
        cls.interfaces.forEach(this::resolve);
        Predicate<Method> canBeOverriden = mtd -> mtd.name.charAt(0) != '<' && (mtd.access & 0x1A) == 0;
        Predicate<Method> canOverride = mtd -> mtd.name.charAt(0) != '<' && (mtd.access & 0xA) == 0;
        block0: for (Method mtd2 : cls.methods.values()) {
            if (!canOverride.test(mtd2)) continue;
            for (Class parent : cls.getStack()) {
                Method pmtd = parent.getMethod(mtd2.name, mtd2.desc);
                if (pmtd == null || !canBeOverriden.test(pmtd)) continue;
                mtd2.overrides.addAll(pmtd.getRoots(false));
                continue block0;
            }
        }
        for (Method mtd2 : cls.methods.values()) {
            if (!mtd2.overrides.isEmpty() || mtd2.bouncers.isEmpty() || !canOverride.test(mtd2)) continue;
            for (Method bounce : mtd2.bouncers) {
                if (bounce.overrides.isEmpty()) continue;
                mtd2.overrides.addAll(bounce.overrides);
            }
        }
        if (!cls.isAbstract()) {
            HashMap abs = new HashMap();
            ArrayList<Class> stack = new ArrayList<Class>(cls.getStack());
            stack.add(0, cls);
            stack.stream().flatMap(c -> c.methods.values().stream()).filter(Node::isAbstract).filter(mtd -> ((Method)mtd).overrides.isEmpty()).forEach(mtd -> abs.put(mtd.name + mtd.desc, mtd));
            for (Class parent : stack) {
                for (Method mtd3 : parent.methods.values()) {
                    Method target;
                    if (mtd3.isAbstract() || (target = (Method)abs.remove(mtd3.name + mtd3.desc)) == null) continue;
                    mtd3.overrides.add(target);
                }
            }
        }
        cls.resolved = true;
    }

    public static enum Access {
        PRIVATE,
        DEFAULT,
        PROTECTED,
        PUBLIC;


        public static Access get(int acc) {
            if ((acc & 2) == 2) {
                return PRIVATE;
            }
            if ((acc & 4) == 4) {
                return PROTECTED;
            }
            if ((acc & 1) == 1) {
                return PUBLIC;
            }
            return DEFAULT;
        }

        public static boolean isPrivate(int acc) {
            return Access.get(acc) == PRIVATE;
        }
    }

    public class Method
    extends Node {
        private final Bounce bounce;
        private final Set<Method> bouncers;
        private Set<Method> overrides;
        private Collection<Method> roots;

        Method(Class owner, MethodNode node, boolean lambda) {
            super(owner, node.name, node.desc, node.access);
            this.bouncers = new HashSet<Method>();
            this.overrides = new HashSet<Method>();
            Bounce bounce = null;
            if (!lambda && (node.access & 0x1040) != 0 && (node.access & 8) == 0) {
                AbstractInsnNode start = node.instructions.getFirst();
                if (start instanceof LabelNode && start.getNext() instanceof LineNumberNode) {
                    start = start.getNext().getNext();
                }
                if (start instanceof VarInsnNode) {
                    VarInsnNode n = (VarInsnNode)start;
                    if (n.var == 0 && n.getOpcode() == 25) {
                        AbstractInsnNode end = node.instructions.getLast();
                        if (end instanceof LabelNode) {
                            end = end.getPrevious();
                        }
                        if (end.getOpcode() >= 172 && end.getOpcode() <= 177) {
                            end = end.getPrevious();
                        }
                        if (end instanceof MethodInsnNode) {
                            Type[] args = Type.getArgumentTypes((String)node.desc);
                            int var = 1;
                            int index = 0;
                            for (start = start.getNext(); start != end; start = start.getNext()) {
                                if (start instanceof VarInsnNode) {
                                    if (((VarInsnNode)start).var != var || index + 1 > args.length) {
                                        end = null;
                                        break;
                                    }
                                    var += args[index++].getSize();
                                    continue;
                                }
                                if (start.getOpcode() == 193 || start.getOpcode() == 192) continue;
                                end = null;
                                break;
                            }
                            MethodInsnNode mtd = (MethodInsnNode)end;
                            if (end != null && mtd.owner.equals(owner.name) && Type.getArgumentsAndReturnSizes((String)node.desc) == Type.getArgumentsAndReturnSizes((String)mtd.desc)) {
                                bounce = new Bounce(mtd.owner, mtd.name, mtd.desc);
                            }
                        }
                    }
                }
            }
            this.bounce = bounce;
        }

        public boolean isBouncer() {
            return this.bounce != null;
        }

        public Set<Method> getBouncers() {
            return this.bouncers;
        }

        public Collection<Method> getRoots() {
            return this.getRoots(true);
        }

        private Collection<Method> getRoots(boolean resolveNested) {
            if (this.roots == null) {
                Collection<Method> roots;
                if (this.overrides.isEmpty()) {
                    roots = Arrays.asList(this);
                } else {
                    roots = this.overrides;
                    while (resolveNested && roots.stream().anyMatch(mtd -> !mtd.overrides.isEmpty())) {
                        roots = roots.stream().map(Method::getRoots).flatMap(Collection::stream).collect(Collectors.toSet());
                    }
                }
                if (resolveNested) {
                    this.roots = roots;
                } else {
                    return roots;
                }
            }
            return this.roots;
        }

        private class Bounce {
            private final String owner;
            private final String name;
            private final String desc;

            private Bounce(String owner, String name, String desc) {
                this.owner = owner;
                this.name = name;
                this.desc = desc;
            }
        }
    }

    public static class Field
    extends Node {
        Field(Class owner, FieldNode n) {
            super(owner, n.name, n.desc, n.access);
        }
    }

    public static class Node {
        public final Class owner;
        public final String name;
        public final String desc;
        public final int access;
        private final int hash;

        Node(Class owner, String name, String desc, int access) {
            this.owner = owner;
            this.name = name;
            this.desc = desc;
            this.access = access;
            this.hash = (name + desc).hashCode();
        }

        public int getAccess() {
            return this.access;
        }

        public boolean isAbstract() {
            return (this.getAccess() & 0x400) != 0;
        }

        public String getKey() {
            return this.owner.name + "/" + this.name + this.desc;
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return Access.get(this.access).name() + " " + this.owner.name + "/" + this.name + this.desc;
        }
    }

    public static class Class {
        private boolean resolved = false;
        private boolean wasRead = false;
        private int access = 0;
        private Class parent;
        public final String name;
        public final Map<String, Field> fields = new HashMap<String, Field>();
        public final Map<String, Method> methods = new HashMap<String, Method>();
        public final List<Class> interfaces = new ArrayList<Class>();
        private List<Class> stack = null;

        public Class(String name) {
            this.name = name;
        }

        public boolean wasRead() {
            return this.wasRead;
        }

        public int getAccess() {
            return this.access;
        }

        public boolean isAbstract() {
            return (this.getAccess() & 0x400) != 0;
        }

        public Class getParent() {
            return this.parent;
        }

        public String toString() {
            return this.name + " [" + this.fields.size() + ", " + this.methods.size() + "]";
        }

        public Field getField(String name) {
            return this.fields.get(name);
        }

        public Method getMethod(String name, String desc) {
            return this.methods.get(name + desc);
        }

        public List<Class> getStack() {
            if (this.stack == null) {
                HashSet<String> visited = new HashSet<String>();
                this.stack = new ArrayList<Class>();
                ArrayDeque<Class> q = new ArrayDeque<Class>();
                if (this.parent != null) {
                    q.add(this.parent);
                }
                this.interfaces.forEach(q::add);
                while (!q.isEmpty()) {
                    Class cls = (Class)q.poll();
                    if (visited.contains(cls.name)) continue;
                    this.stack.add(cls);
                    visited.add(cls.name);
                    if (cls.parent != null && !visited.contains(cls.parent.name)) {
                        q.add(cls.parent);
                    }
                    cls.interfaces.stream().filter(i -> !visited.contains(i.name)).forEach(q::add);
                }
            }
            return this.stack;
        }
    }
}

