/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mappingverifier;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraftforge.mappingverifier.InheratanceMap;
import net.minecraftforge.mappingverifier.Main;
import net.minecraftforge.mappingverifier.MappingVerifier;
import net.minecraftforge.mappingverifier.SimpleVerifier;
import net.minecraftforge.srgutils.IMappingFile;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class AccessLevels
extends SimpleVerifier {
    protected AccessLevels(MappingVerifier verifier) {
        super(verifier);
    }

    @Override
    public boolean process() {
        InheratanceMap inh = this.verifier.getInheratance();
        IMappingFile map = this.verifier.getMappings();
        return inh.getRead().sorted((o1, o2) -> o1.name.compareTo(o2.name)).map(cls -> {
            Main.LOG.fine("  Processing: " + map.remapClass(cls.name));
            ClassNode node = inh.getNode(cls.name);
            if (node == null) {
                this.error("  Missing node: " + cls.name, new String[0]);
                return false;
            }
            HashSet warned = new HashSet();
            String newCls = map.remapClass(cls.name);
            String pkg = this.packageName(newCls);
            boolean success = ((Stream)node.methods.stream().sequential()).sorted((o1, o2) -> o1.name.equals(o2.name) ? o1.desc.compareTo(o2.desc) : o1.name.compareTo(o2.name)).map(mt -> {
                boolean inner_success = true;
                for (AbstractInsnNode isn : mt.instructions.toArray()) {
                    String obfed;
                    InheratanceMap.Node target;
                    InheratanceMap.Class owner;
                    boolean isSelf;
                    if (isn instanceof FieldInsnNode) {
                        FieldInsnNode field = (FieldInsnNode)isn;
                        isSelf = field.owner.equals(node.name);
                        if (isSelf || !(owner = inh.getClass(field.owner)).wasRead() || (target = this.findNode(owner, c -> c.getField(field.name))) == null) continue;
                        String newOwner = map.remapClass(target.owner.name);
                        String newField = map.getClass(target.owner.name).remapField(field.name);
                        boolean isPackage = pkg.equals(this.packageName(newOwner));
                        boolean isSubclass = cls.getStack().contains(target.owner);
                        inner_success &= this.canAccess(newCls, newOwner + "/" + newField, target.access, isPackage, isSubclass, isSelf, warned);
                        continue;
                    }
                    if (isn instanceof MethodInsnNode) {
                        MethodInsnNode method = (MethodInsnNode)isn;
                        isSelf = method.owner.equals(node.name);
                        if (isSelf || !(owner = inh.getClass(method.owner)).wasRead()) continue;
                        target = this.findNode(owner, c -> c.getMethod(method.name, method.desc));
                        String newDesc = map.remapDescriptor(method.desc);
                        if (target == null) continue;
                        String newOwner = map.remapClass(target.owner.name);
                        String newMethod = map.getClass(target.owner.name).remapMethod(method.name, method.desc);
                        boolean isPackage = pkg.equals(this.packageName(newOwner));
                        boolean isSubclass = cls.getStack().contains(target.owner);
                        inner_success &= this.canAccess(newCls, newOwner + "/" + newMethod + newDesc, target.access, isPackage, isSubclass, isSelf, warned);
                        continue;
                    }
                    if (!(isn instanceof TypeInsnNode) || (isSelf = (obfed = ((TypeInsnNode)isn).desc).equals(node.name)) || !(owner = inh.getClass(obfed)).wasRead()) continue;
                    String newOwner = map.remapClass(obfed);
                    boolean isPackage = pkg.equals(this.packageName(newOwner));
                    boolean isSubclass = cls.getStack().contains(inh.getClass(obfed));
                    inner_success &= this.canAccess(newCls, newOwner, owner.getAccess(), isPackage, isSubclass, isSelf, warned);
                }
                return inner_success;
            }).reduce(true, (a, b) -> a != false && b != false);
            return success;
        }).reduce(true, (a, b) -> a != false && b != false);
    }

    private String packageName(String clsName) {
        int idx = clsName.lastIndexOf(47);
        return idx == -1 ? "" : clsName.substring(0, idx);
    }

    private boolean canAccess(String source, String target, int access, boolean isPackage, boolean isSubclass, boolean isSelf, Set<String> warned) {
        String key = source + " -> " + target;
        if (warned.contains(key)) {
            return false;
        }
        if ((access & 1) != 0) {
            return true;
        }
        if ((access & 4) != 0) {
            if (!isPackage && !isSubclass) {
                warned.add(key);
                this.error("    Invalid Access: %s -> %s PROTECTED", source, target);
                return false;
            }
        } else if ((access & 2) != 0) {
            if (!isSelf) {
                warned.add(key);
                this.error("    Invalid Access: %s -> %s PRIVATE", source, target);
                return false;
            }
        } else if (!isSelf && !isPackage) {
            warned.add(key);
            this.error("    Invalid Access: %s -> %s DEFAULT", source, target);
            return false;
        }
        return true;
    }

    private InheratanceMap.Node findNode(InheratanceMap.Class start, Function<InheratanceMap.Class, InheratanceMap.Node> func) {
        ArrayDeque<InheratanceMap.Class> q = new ArrayDeque<InheratanceMap.Class>();
        q.add(start);
        q.addAll(start.getStack());
        InheratanceMap.Node target = null;
        while (!q.isEmpty() && target == null) {
            target = func.apply((InheratanceMap.Class)q.pop());
        }
        return target;
    }
}

