/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mappingverifier;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraftforge.mappingverifier.InheratanceMap;
import net.minecraftforge.mappingverifier.Mappings;
import net.minecraftforge.mappingverifier.SimpleVerifier;
import org.objectweb.asm.Type;

public class UniqueIDs
extends SimpleVerifier {
    @Override
    public boolean process(InheratanceMap inh, Mappings map) {
        HashMap claimed = new HashMap();
        HashMap signatures = new HashMap();
        inh.getRead().forEach(cls -> {
            Mappings.ClsInfo info = map.getClass(cls.name);
            Consumer<String[]> gather = entry -> {
                String idstr = entry[0].split("_")[1];
                if (idstr.matches("\\d+")) {
                    claimed.computeIfAbsent(Integer.parseInt(idstr), k -> new HashSet()).add(entry[0]);
                    signatures.computeIfAbsent(entry[0], k -> new HashSet()).add(Arrays.asList(Arrays.copyOfRange(entry, 1, ((String[])entry).length)));
                }
            };
            cls.fields.values().stream().map(field -> new String[]{info.map(field.name), field.name}).filter(entry -> entry[0].startsWith("field_")).forEach(gather);
            cls.methods.values().stream().map(method -> new String[]{info.map(method.name, method.desc), method.name, method.desc}).filter(entry -> entry[0].startsWith("func_")).forEach(gather);
        });
        return claimed.entrySet().stream().filter(e -> ((Set)e.getValue()).size() > 1 || this.different((Set)signatures.get(((Set)e.getValue()).iterator().next()))).sorted((e1, e2) -> ((Integer)e1.getKey()).compareTo((Integer)e2.getKey())).map(entry -> {
            this.error("Duplicate ID: %s (%s)", ((Integer)entry.getKey()).toString(), String.join((CharSequence)", ", (Iterable)entry.getValue()));
            ((Set)entry.getValue()).forEach(name -> this.error("    %s (%s)", (String)name, ((Set)signatures.get(name)).stream().map(e -> String.join((CharSequence)" ", e)).collect(Collectors.joining(", "))));
            return false;
        }).reduce(true, (a, b) -> a != false && b != false);
    }

    private boolean different(Set<List<String>> entries) {
        if (entries.size() == 1) {
            return false;
        }
        boolean field = false;
        boolean method = false;
        String name = null;
        int size = -1;
        Type ret = null;
        Type[] args = null;
        for (List<String> pts : entries) {
            if (name == null) {
                name = pts.get(0);
            }
            if (pts.size() == 1) {
                if (field) {
                    return true;
                }
                field = true;
                continue;
            }
            if (pts.size() != 2) continue;
            method = true;
            String desc = pts.get(1);
            if (size == -1) {
                size = Type.getArgumentsAndReturnSizes(desc);
                ret = Type.getReturnType(desc);
                args = Type.getArgumentTypes(desc);
                continue;
            }
            if (size != Type.getArgumentsAndReturnSizes(desc) || !this.sameType(ret, Type.getReturnType(desc))) {
                return true;
            }
            Type[] _args = Type.getArgumentTypes(desc);
            if (_args.length != args.length) {
                return true;
            }
            for (int x = 0; x < args.length; ++x) {
                if (this.sameType(args[x], _args[x])) continue;
                return true;
            }
        }
        return field && method;
    }

    private boolean sameType(Type a, Type b) {
        if (a.getSort() != 10 && a.getSort() != 9) {
            return a.getSort() == b.getSort();
        }
        if (a.getSort() == 9) {
            return b.getSort() == 9 && a.getDimensions() == b.getDimensions() && this.sameType(a.getElementType(), b.getElementType());
        }
        return a.getSort() == 10 && b.getSort() == 10;
    }
}

