/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mappingverifier;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.mappingverifier.AccessLevels;
import net.minecraftforge.mappingverifier.IVerifier;
import net.minecraftforge.mappingverifier.InheratanceMap;
import net.minecraftforge.mappingverifier.Main;
import net.minecraftforge.mappingverifier.Mappings;
import net.minecraftforge.mappingverifier.OverrideNames;

public class MappingVerifier {
    private static Map<String, Supplier<IVerifier>> VERIFIERS = new HashMap<String, Supplier<IVerifier>>(){
        {
            this.put("accesslevels", AccessLevels::new);
            this.put("overridenames", OverrideNames::new);
        }
    };
    private Mappings map = new Mappings();
    private InheratanceMap inh = new InheratanceMap();
    private List<IVerifier> tasks = new ArrayList<IVerifier>();

    public void addDefaultTasks() {
        VERIFIERS.values().forEach(v -> this.tasks.add((IVerifier)v.get()));
    }

    public void addTask(String name) {
        Supplier<IVerifier> sup = VERIFIERS.get(name.toLowerCase(Locale.ENGLISH));
        if (sup == null) {
            throw new IllegalArgumentException("Unknown task \"" + name + "\" Known: " + VERIFIERS.keySet().stream().collect(Collectors.joining(", ")));
        }
        this.tasks.add(sup.get());
    }

    public void addTask(IVerifier task) {
        this.tasks.add(task);
    }

    public boolean verify() {
        boolean valid = true;
        for (IVerifier v : this.tasks) {
            valid &= v.process(this.inh, this.map);
        }
        return valid;
    }

    public List<IVerifier> getTasks() {
        return this.tasks;
    }

    public void loadMap(File mapFile) throws IOException {
        try (Stream<String> stream = Files.lines(Paths.get(mapFile.toURI()));){
            BiFunction<String, Character, String[]> rsplit = (i, c) -> {
                String[] stringArray;
                int idx = i.lastIndexOf(c.charValue());
                if (idx == -1) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = i;
                } else {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = i.substring(0, idx);
                    stringArray = stringArray3;
                    stringArray3[1] = i.substring(idx + 1);
                }
                return stringArray;
            };
            List lines = stream.map(l -> l.split("#")[0].replaceAll("\\s+$", "")).filter(l -> !l.isEmpty()).collect(Collectors.toList());
            if (!lines.isEmpty()) {
                String first = (String)lines.get(0);
                if (first.contains("PK:") || first.contains("CL:") || first.contains("FD:") || first.contains("MD:")) {
                    lines.stream().map(l -> l.split(" ")).forEachOrdered(l -> {
                        if (l[0].equals("PK:")) {
                            this.map.addPackage(l[1], l[2]);
                        } else if (l[0].equals("CL:")) {
                            this.map.addMapping(l[1], l[2]);
                        } else if (l[0].equals("FD:")) {
                            String[] ptsO = (String[])rsplit.apply(l[1], Character.valueOf('/'));
                            String[] ptsM = (String[])rsplit.apply(l[2], Character.valueOf('/'));
                            this.map.getClass(ptsO[0]).putField(ptsO[1], ptsM[1]);
                        } else if (l[0].equals("MD:")) {
                            String[] ptsO = (String[])rsplit.apply(l[1], Character.valueOf('/'));
                            String[] ptsM = (String[])rsplit.apply(l[3], Character.valueOf('/'));
                            this.map.getClass(ptsO[0]).putMethod(ptsO[1], l[2], ptsM[1], l[4]);
                        }
                    });
                } else {
                    lines.stream().filter(l -> !l.startsWith("\t")).map(l -> l.split(" ")).filter(l -> ((String[])l).length == 2).forEach(l -> this.map.addMapping(l[0], l[1]));
                    Mappings.ClsInfo currentCls = null;
                    for (String line : lines) {
                        String[] parts;
                        if (line.startsWith("\t")) {
                            if (currentCls == null) {
                                Main.LOG.warning("Invalid TSRG Line, Missing Current class: " + line);
                                continue;
                            }
                            parts = line.substring(1).split(" ");
                            if (parts.length == 2) {
                                currentCls.putField(parts[0], parts[1]);
                                continue;
                            }
                            if (parts.length == 3) {
                                currentCls.putMethod(parts[0], parts[1], parts[2], this.map.mapDesc(parts[1]));
                                continue;
                            }
                            Main.LOG.warning("Invalid TSRG Line, To many peices: " + line);
                            continue;
                        }
                        parts = line.split(" ");
                        if (parts.length == 2) {
                            currentCls = this.map.getClass(parts[0]);
                            continue;
                        }
                        if (parts.length == 3) {
                            this.map.getClass(parts[0]).putField(parts[1], parts[2]);
                            continue;
                        }
                        if (parts.length == 4) {
                            this.map.getClass(parts[0]).putMethod(parts[1], parts[2], parts[3], this.map.mapDesc(parts[2]));
                            continue;
                        }
                        Main.LOG.warning("Invalid CSRG Line, To many peices: " + line);
                    }
                }
            } else {
                Main.LOG.warning("Invalid map file: No entries");
            }
        }
        catch (IOException e) {
            throw new IOException("Could not open map file: " + e.getMessage());
        }
    }

    public void loadJar(File input) throws IOException {
        try (ZipFile zip = new ZipFile(input);){
            zip.stream().filter(e -> !e.isDirectory() && e.getName().endsWith(".class") && !e.getName().startsWith("META-INF/")).forEach(e -> {
                try {
                    Main.LOG.info("Loading: " + e.getName());
                    this.inh.processClass(zip.getInputStream((ZipEntry)e));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            });
        }
    }
}

