/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mappingverifier;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class InheratanceMap {
    private Map<String, Class> classes = new HashMap<String, Class>();
    private Map<String, ClassNode> nodes = new HashMap<String, ClassNode>();

    public void processClass(InputStream data) throws IOException {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(data);
        reader.accept((ClassVisitor)node, 0);
        Class cls = this.getClass(node.name);
        cls.parent = this.getClass(node.superName);
        cls.wasRead = true;
        cls.access = node.access;
        for (String intf : node.interfaces) {
            cls.interfaces.add(this.getClass(intf));
        }
        for (FieldNode n : node.fields) {
            cls.fields.put(n.name, new Node(cls, n.name, n.desc, n.access));
        }
        for (FieldNode n : node.methods) {
            cls.methods.put(n.name + n.desc, new Node(cls, n.name, n.desc, n.access));
        }
        this.nodes.put(node.name, node);
    }

    public Class getClass(String name) {
        return this.classes.computeIfAbsent(name, k -> new Class(name));
    }

    public ClassNode getNode(String name) {
        return this.nodes.get(name);
    }

    public Stream<Class> getRead() {
        return this.classes.values().stream().filter(e -> ((Class)e).wasRead);
    }

    public static enum Access {
        PRIVATE,
        DEFAULT,
        PROTECTED,
        PUBLIC;


        public static Access get(int acc) {
            if ((acc & 2) == 2) {
                return PRIVATE;
            }
            if ((acc & 4) == 4) {
                return PROTECTED;
            }
            if ((acc & 1) == 1) {
                return PUBLIC;
            }
            return DEFAULT;
        }

        public static boolean isPrivate(int acc) {
            return Access.get(acc) == PRIVATE;
        }
    }

    public static class Node {
        public final Class owner;
        public final String name;
        public final String desc;
        public final int access;
        private final int hash;

        Node(Class owner, String name, String desc, int access) {
            this.owner = owner;
            this.name = name;
            this.desc = desc;
            this.access = access;
            this.hash = (name + desc).hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return Access.get(this.access).name() + " " + this.name + this.desc;
        }
    }

    public static class Class {
        private boolean wasRead = false;
        private int access = 0;
        private Class parent;
        public final String name;
        public final Map<String, Node> fields = new HashMap<String, Node>();
        public final Map<String, Node> methods = new HashMap<String, Node>();
        public final List<Class> interfaces = new ArrayList<Class>();
        private List<Class> stack = null;

        public Class(String name) {
            this.name = name;
        }

        public boolean wasRead() {
            return this.wasRead;
        }

        public int getAccess() {
            return this.access;
        }

        public Class getParent() {
            return this.parent;
        }

        public String toString() {
            return this.name + " [" + this.fields.size() + ", " + this.methods.size() + "]";
        }

        public Node getField(String name) {
            return this.fields.get(name);
        }

        public Node getMethod(String name, String desc) {
            return this.methods.get(name + desc);
        }

        public List<Class> getStack() {
            if (this.stack == null) {
                HashSet<String> visited = new HashSet<String>();
                this.stack = new ArrayList<Class>();
                ArrayDeque<Class> q = new ArrayDeque<Class>();
                if (this.parent != null) {
                    q.add(this.parent);
                }
                this.interfaces.forEach(q::add);
                while (!q.isEmpty()) {
                    Class cls = (Class)q.poll();
                    if (visited.contains(cls.name)) continue;
                    this.stack.add(cls);
                    visited.add(cls.name);
                    if (cls.parent != null && !visited.contains(cls.parent.name)) {
                        q.add(cls.parent);
                    }
                    cls.interfaces.stream().filter(i -> !visited.contains(i.name)).forEach(q::add);
                }
            }
            return this.stack;
        }
    }
}

