/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mappingverifier;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.objectweb.asm.Type;

public class Mappings {
    private Map<String, ClsInfo> classes = new HashMap<String, ClsInfo>();
    private Map<String, String> co_to_m = new HashMap<String, String>();
    private Map<String, String> cm_to_o = new HashMap<String, String>();
    private Map<String, String> po_to_m = new HashMap<String, String>();
    private Map<String, String> pm_to_o = new HashMap<String, String>();

    public ClsInfo getClass(String cls) {
        return this.classes.computeIfAbsent(cls, k -> new ClsInfo((String)k));
    }

    public void addMapping(String obf, String mapped) {
        this.co_to_m.put(obf, mapped);
        this.cm_to_o.put(mapped, obf);
    }

    public void addPackage(String obfed, String maped) {
        String string = obfed.equals(".") ? "" : (obfed = obfed.endsWith("/") ? obfed : obfed + "/");
        maped = maped.equals(".") ? "" : (maped.endsWith("/") ? maped : obfed + "/");
        this.po_to_m.put(obfed, maped);
        this.pm_to_o.put(maped, obfed);
    }

    public String mapPackage(String pkg) {
        int idx = pkg.indexOf(47);
        return this.po_to_m.getOrDefault(pkg, idx == -1 || idx != pkg.length() ? pkg : this.mapPackage(pkg.substring(0, idx + 1)) + pkg.substring(idx + 1));
    }

    public String unmapPackage(String pkg) {
        int idx = pkg.indexOf(47);
        return this.pm_to_o.getOrDefault(pkg, idx == -1 || idx != pkg.length() ? pkg : this.unmapPackage(pkg.substring(0, idx + 1)) + pkg.substring(idx + 1));
    }

    public String map(String cls) {
        int sub = cls.lastIndexOf(36);
        int idx = cls.lastIndexOf(47);
        String ret = this.co_to_m.get(cls);
        return ret != null ? ret : (sub != -1 ? this.map(cls.substring(0, sub)) + cls.substring(sub) : (idx != -1 ? this.mapPackage(cls.substring(0, idx + 1)) + cls.substring(idx + 1) : cls));
    }

    public String unmap(String cls) {
        int sub = cls.lastIndexOf(36);
        int idx = cls.indexOf(47);
        String ret = this.cm_to_o.get(cls);
        return ret != null ? ret : (sub != -1 ? this.unmap(cls.substring(0, sub)) + cls.substring(sub) : (idx != -1 ? this.unmapPackage(cls.substring(0, idx + 1)) + cls.substring(idx + 1) : cls));
    }

    public String mapDesc(String desc) {
        return this.mapDesc(desc, k -> this.map((String)k));
    }

    public String unmapDesc(String desc) {
        return this.mapDesc(desc, k -> this.unmap((String)k));
    }

    private String mapDesc(String desc, Function<String, String> mapper) {
        StringBuilder sb = new StringBuilder();
        Consumer<Type> append = t -> {
            if (t.getSort() == 9) {
                for (int x = 0; x < t.getDimensions(); ++x) {
                    sb.append('[');
                }
                t = t.getElementType();
            }
            if (t.getSort() == 10) {
                sb.append('L').append((String)mapper.apply(t.getInternalName())).append(';');
            } else {
                sb.append(t.getDescriptor());
            }
        };
        sb.append('(');
        for (Type t2 : Type.getArgumentTypes(desc)) {
            append.accept(t2);
        }
        sb.append(')');
        append.accept(Type.getReturnType(desc));
        return sb.toString();
    }

    public static class ClsInfo {
        private final String name;
        private Map<String, String> fo_to_m = new HashMap<String, String>();
        private Map<String, String> fm_to_o = new HashMap<String, String>();
        private Map<String, String> mo_to_m = new HashMap<String, String>();
        private Map<String, String> mm_to_o = new HashMap<String, String>();

        public ClsInfo(String name) {
            this.name = name;
        }

        public void putField(String obfed, String maped) {
            this.fo_to_m.put(obfed, maped);
            this.fm_to_o.put(maped, obfed);
        }

        public void putMethod(String obfed, String obfedSig, String maped, String mapedSig) {
            this.mo_to_m.put(obfed + obfedSig, maped);
            this.mm_to_o.put(maped + mapedSig, obfed);
        }

        public String map(String field) {
            return this.fo_to_m.getOrDefault(field, field);
        }

        public String unmap(String field) {
            return this.fm_to_o.getOrDefault(field, field);
        }

        public String map(String method, String signature) {
            return this.mo_to_m.getOrDefault(method + signature, method);
        }

        public String unmap(String method, String signature) {
            return this.mm_to_o.getOrDefault(method + signature, method);
        }

        public String toString() {
            return this.name + "[" + this.fo_to_m.size() + ", " + this.mo_to_m.size() + "]";
        }
    }
}

