/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mappingverifier;

import java.util.ArrayDeque;
import java.util.stream.Stream;
import net.minecraftforge.mappingverifier.InheratanceMap;
import net.minecraftforge.mappingverifier.Main;
import net.minecraftforge.mappingverifier.Mappings;
import net.minecraftforge.mappingverifier.SimpleVerifier;

public class OverrideNames
extends SimpleVerifier {
    @Override
    public boolean process(InheratanceMap inh, Mappings map) {
        return inh.getRead().sorted((o1, o2) -> o1.name.compareTo(o2.name)).map(cls -> {
            boolean success = true;
            Main.LOG.info("  Processing: " + map.map(cls.name));
            Mappings.ClsInfo info = map.getClass(cls.name);
            success &= ((Stream)cls.fields.values().stream().sequential()).sorted((o1, o2) -> o1.name.compareTo(o2.name)).map(entry -> {
                String newName = info.map(entry.name);
                ArrayDeque<InheratanceMap.Class> q = new ArrayDeque<InheratanceMap.Class>(cls.getStack());
                while (!q.isEmpty()) {
                    InheratanceMap.Class parent = (InheratanceMap.Class)q.poll();
                    Mappings.ClsInfo pinfo = map.getClass(parent.name);
                    InheratanceMap.Node f = parent.fields.get(pinfo.unmap(newName));
                    if (f != null && !InheratanceMap.Access.isPrivate(f.access)) {
                        this.error("    Shade: %s/%s %s/%s %s", cls.name, entry.name, map.map(parent.name), f.name, newName);
                        return false;
                    }
                    parent = parent.getParent();
                }
                return true;
            }).reduce(true, (a, b) -> a != false && b != false).booleanValue();
            return success &= ((Stream)cls.methods.values().stream().sequential()).sorted((o1, o2) -> o1.name.equals(o2.name) ? o1.desc.compareTo(o2.desc) : o1.name.compareTo(o2.name)).map(mt -> {
                if (mt.name.startsWith("<") || (mt.access & 8) != 0) {
                    return true;
                }
                String newName = map.getClass(cls.name).map(mt.name, mt.desc);
                String newSignature = map.mapDesc(mt.desc);
                ArrayDeque<InheratanceMap.Class> q = new ArrayDeque<InheratanceMap.Class>(cls.getStack());
                while (!q.isEmpty()) {
                    String mapped;
                    InheratanceMap.Class parent = (InheratanceMap.Class)q.poll();
                    Mappings.ClsInfo pinfo = map.getClass(parent.name);
                    String unmapped = pinfo.unmap(newName, newSignature);
                    InheratanceMap.Node m = parent.methods.get(unmapped + mt.desc);
                    if (m != null && !InheratanceMap.Access.isPrivate(m.access) && !mt.name.equals(unmapped)) {
                        this.error("    Shade: %s/%s %s/%s %s %s", cls.name, mt.name, parent.name, unmapped, mt.desc, newName);
                        return false;
                    }
                    m = parent.methods.get(mt.name + mt.desc);
                    if (m == null || InheratanceMap.Access.isPrivate(m.access) || newName.equals(mapped = pinfo.map(mt.name, mt.desc))) continue;
                    this.error("    Override: %s/%s %s -- %s -> %s", cls.name, mt.name, mt.desc, newName, mapped);
                    return false;
                }
                return true;
            }).reduce(true, (a, b) -> a != false && b != false).booleanValue();
        }).reduce(true, (a, b) -> a != false && b != false);
    }
}

