/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mappingverifier;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import net.minecraftforge.mappingverifier.MappingVerifier;

public class Main {
    public static final String SIMPLE_NAME = Main.class.getSimpleName();
    public static final Logger LOG = Logger.getLogger(SIMPLE_NAME);
    public static final String VERSION = SIMPLE_NAME + " v" + Optional.ofNullable(Main.class.getPackage().getImplementationVersion()).orElse("Unknown") + " by LexManos";

    public static void main(String[] args) throws Exception {
        OptionParser parser = new OptionParser();
        parser.accepts("help").forHelp();
        parser.accepts("version").forHelp();
        ArgumentAcceptingOptionSpec jarArg = parser.accepts("jar").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec mapArg = parser.accepts("map").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec logArg = parser.accepts("log").withRequiredArg().ofType(String.class);
        parser.accepts("verbose");
        try {
            OptionSet options = parser.parse(args);
            if (options.has("help")) {
                System.out.println(VERSION);
                parser.printHelpOn((OutputStream)System.out);
                return;
            }
            if (options.has("version")) {
                System.out.println(VERSION);
                return;
            }
            File jarFile = (File)jarArg.value(options);
            File mapFile = (File)mapArg.value(options);
            String logFile = (String)logArg.value(options);
            final boolean verbose = options.has("verbose");
            LOG.setUseParentHandlers(false);
            LOG.setLevel(Level.ALL);
            if (logFile != null) {
                FileHandler filehandler = new FileHandler(logFile);
                filehandler.setFormatter(new Formatter(){

                    @Override
                    public synchronized String format(LogRecord record) {
                        StringBuffer sb = new StringBuffer();
                        String message = this.formatMessage(record);
                        sb.append(record.getLevel().getName()).append(": ").append(message).append("\n");
                        if (record.getThrown() != null) {
                            try {
                                StringWriter sw = new StringWriter();
                                PrintWriter pw = new PrintWriter(sw);
                                record.getThrown().printStackTrace(pw);
                                pw.close();
                                sb.append(sw.toString());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return sb.toString();
                    }
                });
                LOG.addHandler(filehandler);
            }
            LOG.addHandler(new Handler(){

                @Override
                public void publish(LogRecord record) {
                    if (verbose || record.getLevel().intValue() >= Level.WARNING.intValue()) {
                        System.out.println(String.format(record.getMessage(), record.getParameters()));
                    }
                }

                @Override
                public void flush() {
                }

                @Override
                public void close() throws SecurityException {
                }
            });
            Main.log(VERSION);
            Main.log("Jar:      " + jarFile);
            Main.log("Map:      " + mapFile);
            Main.log("Log:      " + logFile);
            try {
                MappingVerifier mv = new MappingVerifier();
                mv.addDefaultTasks();
                mv.loadMap(mapFile);
                mv.loadJar(jarFile);
                mv.verify();
            }
            catch (Exception e) {
                System.err.println("ERROR: " + e.getMessage());
                LOG.log(Level.SEVERE, "ERROR", e);
                e.printStackTrace();
                System.exit(1);
            }
        }
        catch (OptionException e) {
            parser.printHelpOn((OutputStream)System.out);
            e.printStackTrace();
        }
    }

    private static void log(String line) {
        LOG.warning(line);
    }
}

